/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Binding;
import com.icl.saxon.Context;
import com.icl.saxon.Mode;
import com.icl.saxon.NodeHandler;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.RuleManager;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.Pattern;
import com.icl.saxon.style.Procedure;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.trace.TraceListener;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.NodeImpl;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLTemplate
extends StyleElement
implements NodeHandler {
    protected int modeNameCode = -1;
    protected int templateFingerprint = -1;
    protected Pattern match;
    protected boolean prioritySpecified;
    protected double priority;
    protected Procedure procedure = new Procedure();
    protected boolean needsStackFrame;

    @Override
    public boolean mayContainTemplateBody() {
        return true;
    }

    public int getTemplateFingerprint() {
        try {
            if (this.templateFingerprint == -1) {
                StandardNames standardNames = this.getStandardNames();
                String string = this.getAttributeList().getValue(standardNames.NAME);
                if (string != null) {
                    this.templateFingerprint = this.makeNameCode(string, false) & 0xFFFFF;
                }
            }
            return this.templateFingerprint;
        }
        catch (NamespaceException namespaceException) {
            return -1;
        }
    }

    public int getMinImportPrecedence() {
        return ((XSLStyleSheet)this.getDocumentElement()).getMinImportPrecedence();
    }

    @Override
    public boolean needsStackFrame() {
        return this.needsStackFrame;
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            int n2 = n & 0xFFFFF;
            if (n2 == standardNames.MODE) {
                string = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.NAME) {
                string2 = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.MATCH) {
                string4 = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.PRIORITY) {
                string3 = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        try {
            if (string != null) {
                if (!Name.isQName(string)) {
                    if (this.forwardsCompatibleModeIsEnabled()) {
                        string = null;
                    } else {
                        this.compileError("Mode name is not a valid QName");
                    }
                } else {
                    this.modeNameCode = this.makeNameCode(string, false);
                }
            }
            if (string2 != null) {
                if (!Name.isQName(string2)) {
                    this.compileError("Template name is not a valid QName");
                }
                this.templateFingerprint = this.makeNameCode(string2, false) & 0xFFFFF;
            }
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
        boolean bl = this.prioritySpecified = string3 != null;
        if (this.prioritySpecified) {
            try {
                this.priority = Double.parseDouble(string3.trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.compileError("Invalid numeric value for priority (" + this.priority + ')');
            }
        }
        if (string4 != null) {
            this.match = this.makePattern(string4);
        }
        if (this.match == null && string2 == null) {
            this.compileError("xsl:template must have a a name or match attribute (or both)");
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
        if (this.templateFingerprint != -1) {
            for (NodeImpl nodeImpl = (NodeImpl)this.getPreviousSibling(); nodeImpl != null; nodeImpl = (NodeImpl)nodeImpl.getPreviousSibling()) {
                XSLTemplate xSLTemplate;
                if (!(nodeImpl instanceof XSLTemplate) || (xSLTemplate = (XSLTemplate)nodeImpl).getTemplateFingerprint() != this.templateFingerprint || xSLTemplate.getPrecedence() != this.getPrecedence()) continue;
                this.compileError("There is another template with the same name and precedence");
            }
        }
    }

    @Override
    public void preprocess() throws TransformerConfigurationException {
        RuleManager ruleManager = this.getPrincipalStyleSheet().getRuleManager();
        Mode mode = ruleManager.getMode(this.modeNameCode);
        if (this.match != null) {
            NodeHandler nodeHandler = this;
            if (this.getFirstChild() == null) {
                nodeHandler = new NoOpHandler();
            }
            if (this.prioritySpecified) {
                ruleManager.setHandler(this.match, nodeHandler, mode, this.getPrecedence(), this.priority);
            } else {
                ruleManager.setHandler(this.match, nodeHandler, mode, this.getPrecedence());
            }
        }
        this.getPrincipalStyleSheet().allocateLocalSlots(this.procedure.getNumberOfVariables());
        this.needsStackFrame = this.procedure.getNumberOfVariables() > 0;
    }

    @Override
    public void process(Context context) throws TransformerException {
    }

    @Override
    public void start(NodeInfo nodeInfo, Context context) throws TransformerException {
        context.setCurrentTemplate(this);
        if (context.getController().isTracing()) {
            this.traceExpand(context);
        } else {
            this.expand(context);
        }
    }

    protected void traceExpand(Context context) throws TransformerException {
        TraceListener traceListener = context.getController().getTraceListener();
        traceListener.enter(this, context);
        this.expand(context);
        traceListener.leave(this, context);
    }

    protected void expand(Context context) throws TransformerException {
        ParameterSet parameterSet;
        do {
            context.setTailRecursion(null);
            this.processChildren(context);
            parameterSet = context.getTailRecursion();
            if (parameterSet == null) continue;
            context.getBindery().closeStackFrame();
            context.getBindery().openStackFrame(parameterSet);
        } while (parameterSet != null);
    }

    @Override
    public Binding bindVariable(int n) throws XPathException {
        throw new XPathException("The match pattern in xsl:template may not contain references to variables");
    }

    public Procedure getProcedure() {
        return this.procedure;
    }

    private static final class NoOpHandler
    implements NodeHandler {
        private NoOpHandler() {
        }

        @Override
        public void start(NodeInfo nodeInfo, Context context) {
        }

        @Override
        public boolean needsStackFrame() {
            return false;
        }
    }
}

