/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.CommandDecoder;
import VASSAL.chat.HttpMessageServer;
import VASSAL.chat.messageboard.Message;
import VASSAL.chat.peer2peer.DirectPeerPool;
import VASSAL.chat.peer2peer.P2PClient;
import VASSAL.chat.peer2peer.PeerPoolInfo;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.i18n.Resources;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P2PClientFactory
extends ChatServerFactory {
    private static final Logger logger = LoggerFactory.getLogger(ChatServerFactory.class);
    public static final String P2P_TYPE = "peer2peer";
    public static final String P2P_LISTEN_PORT = "listenPort";
    public static final String P2P_MODE_KEY = "mode";
    public static final String P2P_SERVER_MODE = "server";
    public static final String P2P_CLIENT_MODE = "client";
    public static final String P2P_SERVER_IP = "serverIp";
    public static final String P2P_SERVER_PORT = "serverPort";
    public static final String P2P_SERVER_NAME = "serverName";
    public static final String P2P_SERVER_PW = "serverPw";

    public ChatServerConnection buildServer(Properties properties) {
        P2PMessageServer p2PMessageServer = new P2PMessageServer();
        P2PClient p2PClient = new P2PClient(GameModule.getGameModule(), p2PMessageServer, p2PMessageServer, new DirectPeerPool(properties), properties);
        p2PClient.addPropertyChangeListener("Status", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = (String)propertyChangeEvent.getNewValue();
                GameModule.getGameModule().warn(string);
                logger.info(string);
            }
        });
        p2PClient.addPropertyChangeListener("Msg", new CommandDecoder());
        return p2PClient;
    }

    class P2PMessageServer
    extends HttpMessageServer {
        public P2PMessageServer() {
            super(new PeerPoolInfo(){

                public String getModuleName() {
                    return GameModule.getGameModule() == null ? Resources.getString("Chat.unknown_module") : GameModule.getGameModule().getGameName();
                }

                public String getUserName() {
                    return GameModule.getUserId();
                }
            });
        }

        public Command getWelcomeMessage() {
            return new NullCommand();
        }

        public Message[] getMessages() {
            return null;
        }

        public void postMessage(String string) {
        }
    }
}

