/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling.suggest;

import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.expressions.js.JavascriptCompiler;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.suggest.DocumentValueSourceDictionary;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.DoublePointField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.FloatPointField;
import org.apache.solr.schema.IntPointField;
import org.apache.solr.schema.LongPointField;
import org.apache.solr.schema.TrieDoubleField;
import org.apache.solr.schema.TrieFloatField;
import org.apache.solr.schema.TrieIntField;
import org.apache.solr.schema.TrieLongField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.suggest.DictionaryFactory;

public class DocumentExpressionDictionaryFactory
extends DictionaryFactory {
    public static final String FIELD = "field";
    public static final String PAYLOAD_FIELD = "payloadField";
    public static final String WEIGHT_EXPRESSION = "weightExpression";
    public static final String SORT_FIELD = "sortField";

    @Override
    public Dictionary create(SolrCore core, SolrIndexSearcher searcher) {
        if (this.params == null) {
            throw new IllegalStateException("Value of params not set");
        }
        String field = (String)this.params.get(FIELD);
        String payloadField = (String)this.params.get(PAYLOAD_FIELD);
        String weightExpression = (String)this.params.get(WEIGHT_EXPRESSION);
        HashSet<SortField> sortFields = new HashSet<SortField>();
        if (field == null) {
            throw new IllegalArgumentException("field is a mandatory parameter");
        }
        if (weightExpression == null) {
            throw new IllegalArgumentException("weightExpression is a mandatory parameter");
        }
        for (int i = 0; i < this.params.size(); ++i) {
            if (!this.params.getName(i).equals(SORT_FIELD)) continue;
            String sortFieldName = (String)this.params.getVal(i);
            SortField.Type sortFieldType = this.getSortFieldType(core, sortFieldName);
            if (sortFieldType == null) {
                throw new IllegalArgumentException(sortFieldName + " could not be mapped to any appropriate type [long, int, float, double]");
            }
            SortField sortField = new SortField(sortFieldName, sortFieldType);
            sortFields.add(sortField);
        }
        return new DocumentValueSourceDictionary((IndexReader)searcher.getIndexReader(), field, this.fromExpression(weightExpression, sortFields), payloadField);
    }

    public LongValuesSource fromExpression(String weightExpression, Set<SortField> sortFields) {
        Expression expression = null;
        try {
            expression = JavascriptCompiler.compile((String)weightExpression);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        SimpleBindings bindings = new SimpleBindings();
        for (SortField sortField : sortFields) {
            bindings.add(sortField);
        }
        return expression.getDoubleValuesSource((Bindings)bindings).toLongValuesSource();
    }

    private SortField.Type getSortFieldType(SolrCore core, String sortFieldName) {
        SortField.Type type = null;
        String fieldTypeName = core.getLatestSchema().getField(sortFieldName).getType().getTypeName();
        FieldType ft = core.getLatestSchema().getFieldTypes().get(fieldTypeName);
        if (ft instanceof TrieFloatField || ft instanceof FloatPointField) {
            type = SortField.Type.FLOAT;
        } else if (ft instanceof TrieIntField || ft instanceof IntPointField) {
            type = SortField.Type.INT;
        } else if (ft instanceof TrieLongField || ft instanceof LongPointField) {
            type = SortField.Type.LONG;
        } else if (ft instanceof TrieDoubleField || ft instanceof DoublePointField) {
            type = SortField.Type.DOUBLE;
        }
        return type;
    }
}

