/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.solr.common.util.Cache;
import org.apache.solr.search.LRUCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentLRUCache<K, V>
implements Cache<K, V>,
Accountable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ConcurrentLRUCache.class);
    private final ConcurrentHashMap<Object, CacheEntry<K, V>> map;
    private final int upperWaterMark;
    private final int lowerWaterMark;
    private final ReentrantLock markAndSweepLock = new ReentrantLock(true);
    private boolean isCleaning = false;
    private final boolean newThreadForCleanup;
    private volatile boolean islive = true;
    private final Stats stats = new Stats();
    private final int acceptableWaterMark;
    private long oldestEntry = 0L;
    private final EvictionListener<K, V> evictionListener;
    private CleanupThread cleanupThread;
    private final long ramLowerWatermark;
    private final long ramUpperWatermark;
    private final AtomicLong ramBytes = new AtomicLong(0L);
    private boolean isDestroyed = false;

    public ConcurrentLRUCache(long ramLowerWatermark, long ramUpperWatermark, boolean runCleanupThread, EvictionListener<K, V> evictionListener) {
        this.ramLowerWatermark = ramLowerWatermark;
        this.ramUpperWatermark = ramUpperWatermark;
        this.evictionListener = evictionListener;
        this.map = new ConcurrentHashMap();
        this.newThreadForCleanup = false;
        this.acceptableWaterMark = -1;
        this.lowerWaterMark = Integer.MIN_VALUE;
        this.upperWaterMark = Integer.MAX_VALUE;
        if (runCleanupThread) {
            this.cleanupThread = new CleanupThread(this);
            this.cleanupThread.start();
        }
    }

    public ConcurrentLRUCache(int upperWaterMark, int lowerWaterMark, int acceptableWatermark, int initialSize, boolean runCleanupThread, boolean runNewThreadForCleanup, EvictionListener<K, V> evictionListener) {
        if (upperWaterMark < 1) {
            throw new IllegalArgumentException("upperWaterMark must be > 0");
        }
        if (lowerWaterMark >= upperWaterMark) {
            throw new IllegalArgumentException("lowerWaterMark must be  < upperWaterMark");
        }
        this.map = new ConcurrentHashMap(initialSize);
        this.newThreadForCleanup = runNewThreadForCleanup;
        this.upperWaterMark = upperWaterMark;
        this.lowerWaterMark = lowerWaterMark;
        this.acceptableWaterMark = acceptableWatermark;
        this.evictionListener = evictionListener;
        if (runCleanupThread) {
            this.cleanupThread = new CleanupThread(this);
            this.cleanupThread.start();
        }
        this.ramLowerWatermark = Long.MIN_VALUE;
        this.ramUpperWatermark = Long.MAX_VALUE;
    }

    public ConcurrentLRUCache(int size, int lowerWatermark) {
        this(size, lowerWatermark, (int)Math.floor((lowerWatermark + size) / 2), (int)Math.ceil(0.75 * (double)size), false, false, null);
    }

    public void setAlive(boolean live) {
        this.islive = live;
    }

    public V get(K key) {
        CacheEntry<K, V> e = this.map.get(key);
        if (e == null) {
            if (this.islive) {
                this.stats.missCounter.increment();
            }
            return null;
        }
        if (this.islive) {
            e.lastAccessed = this.stats.accessCounter.incrementAndGet();
        }
        return e.value;
    }

    public V remove(K key) {
        CacheEntry<K, V> cacheEntry = this.map.remove(key);
        if (cacheEntry != null) {
            this.stats.size.decrementAndGet();
            if (this.ramUpperWatermark != Long.MAX_VALUE) {
                this.ramBytes.addAndGet(-cacheEntry.ramBytesUsed() - LRUCache.HASHTABLE_RAM_BYTES_PER_ENTRY);
            }
            return cacheEntry.value;
        }
        return null;
    }

    public V put(K key, V val) {
        int currentSize;
        if (val == null) {
            return null;
        }
        CacheEntry<K, V> e = new CacheEntry<K, V>(key, val, this.stats.accessCounter.incrementAndGet());
        CacheEntry<K, V> oldCacheEntry = this.map.put(key, e);
        if (oldCacheEntry == null) {
            currentSize = this.stats.size.incrementAndGet();
            if (this.ramUpperWatermark != Long.MAX_VALUE) {
                this.ramBytes.addAndGet(e.ramBytesUsed() + LRUCache.HASHTABLE_RAM_BYTES_PER_ENTRY);
            }
        } else {
            currentSize = this.stats.size.get();
            if (this.ramUpperWatermark != Long.MAX_VALUE) {
                if (oldCacheEntry.value instanceof Accountable) {
                    this.ramBytes.addAndGet(-((Accountable)oldCacheEntry.value).ramBytesUsed());
                } else {
                    this.ramBytes.addAndGet(-192L);
                }
                if (val instanceof Accountable) {
                    this.ramBytes.addAndGet(((Accountable)val).ramBytesUsed());
                } else {
                    this.ramBytes.addAndGet(192L);
                }
            }
        }
        if (this.islive) {
            this.stats.putCounter.increment();
        } else {
            this.stats.nonLivePutCounter.increment();
        }
        if (!(currentSize <= this.upperWaterMark && this.ramBytes.get() <= this.ramUpperWatermark || this.isCleaning)) {
            if (this.newThreadForCleanup) {
                new Thread(this::markAndSweep).start();
            } else if (this.cleanupThread != null) {
                this.cleanupThread.wakeThread();
            } else {
                this.markAndSweep();
            }
        }
        return oldCacheEntry == null ? null : (V)oldCacheEntry.value;
    }

    private void markAndSweep() {
        block6: {
            if (!this.markAndSweepLock.tryLock()) {
                return;
            }
            try {
                if (this.upperWaterMark != Integer.MAX_VALUE) {
                    this.markAndSweepByCacheSize();
                    break block6;
                }
                if (this.ramUpperWatermark != Long.MAX_VALUE) {
                    this.markAndSweepByRamSize();
                    break block6;
                }
                throw new AssertionError((Object)"ConcurrentLRUCache initialized with neither size limits nor ram limits");
            }
            finally {
                this.isCleaning = false;
                this.markAndSweepLock.unlock();
            }
        }
    }

    private void markAndSweepByRamSize() {
        ArrayList entriesInAccessOrder = new ArrayList(this.map.size());
        this.map.forEach((o, kvCacheEntry) -> {
            kvCacheEntry.lastAccessedCopy = kvCacheEntry.lastAccessed;
            entriesInAccessOrder.add(kvCacheEntry);
        });
        Collections.sort(entriesInAccessOrder);
        for (int i = entriesInAccessOrder.size() - 1; i >= 0; --i) {
            CacheEntry kvCacheEntry2 = (CacheEntry)entriesInAccessOrder.get(i);
            this.evictEntry(kvCacheEntry2.key);
            this.ramBytes.addAndGet(-(kvCacheEntry2.ramBytesUsed() + LRUCache.HASHTABLE_RAM_BYTES_PER_ENTRY));
            if (this.ramBytes.get() <= this.ramLowerWatermark) break;
        }
    }

    private void markAndSweepByCacheSize() {
        long oldestEntry = this.oldestEntry;
        this.isCleaning = true;
        this.oldestEntry = oldestEntry;
        long timeCurrent = this.stats.accessCounter.longValue();
        int sz = this.stats.size.get();
        int numRemoved = 0;
        int numKept = 0;
        long newestEntry = timeCurrent;
        long newNewestEntry = -1L;
        long newOldestEntry = Long.MAX_VALUE;
        int wantToKeep = this.lowerWaterMark;
        int wantToRemove = sz - this.lowerWaterMark;
        CacheEntry[] eset = new CacheEntry[sz];
        int eSize = 0;
        for (CacheEntry<K, V> ce : this.map.values()) {
            ce.lastAccessedCopy = ce.lastAccessed;
            long thisEntry = ce.lastAccessedCopy;
            if (thisEntry > newestEntry - (long)wantToKeep) {
                ++numKept;
                newOldestEntry = Math.min(thisEntry, newOldestEntry);
                continue;
            }
            if (thisEntry < oldestEntry + (long)wantToRemove) {
                this.evictEntry(ce.key);
                ++numRemoved;
                continue;
            }
            if (eSize >= eset.length - 1) continue;
            eset[eSize++] = ce;
            newNewestEntry = Math.max(thisEntry, newNewestEntry);
            newOldestEntry = Math.min(thisEntry, newOldestEntry);
        }
        int numPasses = 1;
        while (sz - numRemoved > this.acceptableWaterMark && --numPasses >= 0) {
            oldestEntry = newOldestEntry == Long.MAX_VALUE ? oldestEntry : newOldestEntry;
            newOldestEntry = Long.MAX_VALUE;
            newestEntry = newNewestEntry;
            newNewestEntry = -1L;
            wantToKeep = this.lowerWaterMark - numKept;
            wantToRemove = sz - this.lowerWaterMark - numRemoved;
            for (int i = eSize - 1; i >= 0; --i) {
                CacheEntry ce = eset[i];
                long thisEntry = ce.lastAccessedCopy;
                if (thisEntry > newestEntry - (long)wantToKeep) {
                    ++numKept;
                    eset[i] = eset[eSize - 1];
                    --eSize;
                    newOldestEntry = Math.min(thisEntry, newOldestEntry);
                    continue;
                }
                if (thisEntry < oldestEntry + (long)wantToRemove) {
                    this.evictEntry(ce.key);
                    ++numRemoved;
                    eset[i] = eset[eSize - 1];
                    --eSize;
                    continue;
                }
                newNewestEntry = Math.max(thisEntry, newNewestEntry);
                newOldestEntry = Math.min(thisEntry, newOldestEntry);
            }
        }
        if (sz - numRemoved > this.acceptableWaterMark) {
            oldestEntry = newOldestEntry == Long.MAX_VALUE ? oldestEntry : newOldestEntry;
            newOldestEntry = Long.MAX_VALUE;
            newestEntry = newNewestEntry;
            newNewestEntry = -1L;
            wantToKeep = this.lowerWaterMark - numKept;
            wantToRemove = sz - this.lowerWaterMark - numRemoved;
            PQueue queue = new PQueue(wantToRemove);
            for (int i = eSize - 1; i >= 0; --i) {
                CacheEntry ce = eset[i];
                long thisEntry = ce.lastAccessedCopy;
                if (thisEntry > newestEntry - (long)wantToKeep) {
                    ++numKept;
                    newOldestEntry = Math.min(thisEntry, newOldestEntry);
                    continue;
                }
                if (thisEntry < oldestEntry + (long)wantToRemove) {
                    this.evictEntry(ce.key);
                    ++numRemoved;
                    continue;
                }
                queue.myMaxSize = sz - this.lowerWaterMark - numRemoved;
                while (queue.size() > queue.myMaxSize && queue.size() > 0) {
                    CacheEntry otherEntry = (CacheEntry)queue.pop();
                    newOldestEntry = Math.min(otherEntry.lastAccessedCopy, newOldestEntry);
                }
                if (queue.myMaxSize <= 0) break;
                CacheEntry o = queue.myInsertWithOverflow(ce);
                if (o == null) continue;
                newOldestEntry = Math.min(o.lastAccessedCopy, newOldestEntry);
            }
            for (CacheEntry ce : queue.getValues()) {
                if (ce == null) continue;
                this.evictEntry(ce.key);
                ++numRemoved;
            }
        }
        this.oldestEntry = oldestEntry = newOldestEntry == Long.MAX_VALUE ? oldestEntry : newOldestEntry;
    }

    private void evictEntry(K key) {
        CacheEntry<K, V> o = this.map.remove(key);
        if (o == null) {
            return;
        }
        this.stats.size.decrementAndGet();
        this.stats.evictionCounter.incrementAndGet();
        if (this.evictionListener != null) {
            this.evictionListener.evictedEntry(o.key, o.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getOldestAccessedItems(int n) {
        LinkedHashMap result = new LinkedHashMap();
        if (n <= 0) {
            return result;
        }
        TreeSet<CacheEntry<K, V>> tree = new TreeSet<CacheEntry<K, V>>();
        this.markAndSweepLock.lock();
        try {
            for (Map.Entry<Object, CacheEntry<K, V>> entry : this.map.entrySet()) {
                CacheEntry<K, V> ce = entry.getValue();
                ce.lastAccessedCopy = ce.lastAccessed;
                if (tree.size() < n) {
                    tree.add(ce);
                    continue;
                }
                if (ce.lastAccessedCopy >= ((CacheEntry)tree.first()).lastAccessedCopy) continue;
                tree.remove(tree.first());
                tree.add(ce);
            }
        }
        finally {
            this.markAndSweepLock.unlock();
        }
        for (CacheEntry cacheEntry : tree) {
            result.put(cacheEntry.key, cacheEntry.value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getLatestAccessedItems(int n) {
        LinkedHashMap result = new LinkedHashMap();
        if (n <= 0) {
            return result;
        }
        TreeSet<CacheEntry<K, V>> tree = new TreeSet<CacheEntry<K, V>>();
        this.markAndSweepLock.lock();
        try {
            for (Map.Entry<Object, CacheEntry<K, V>> entry : this.map.entrySet()) {
                CacheEntry<K, V> ce = entry.getValue();
                ce.lastAccessedCopy = ce.lastAccessed;
                if (tree.size() < n) {
                    tree.add(ce);
                    continue;
                }
                if (ce.lastAccessedCopy <= ((CacheEntry)tree.last()).lastAccessedCopy) continue;
                tree.remove(tree.last());
                tree.add(ce);
            }
        }
        finally {
            this.markAndSweepLock.unlock();
        }
        for (CacheEntry cacheEntry : tree) {
            result.put(cacheEntry.key, cacheEntry.value);
        }
        return result;
    }

    public int size() {
        return this.stats.size.get();
    }

    public void clear() {
        this.map.clear();
    }

    public Map<Object, CacheEntry<K, V>> getMap() {
        return this.map;
    }

    public void destroy() {
        try {
            if (this.cleanupThread != null) {
                this.cleanupThread.stopThread();
            }
        }
        finally {
            this.isDestroyed = true;
        }
    }

    public Stats getStats() {
        return this.stats;
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isDestroyed && this.cleanupThread != null) {
                log.error("ConcurrentLRUCache created with a thread and was not destroyed prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!");
                this.destroy();
            }
        }
        finally {
            super.finalize();
        }
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.ramBytes.get();
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    private static class CleanupThread
    extends Thread {
        private WeakReference<ConcurrentLRUCache> cache;
        private boolean stop = false;

        public CleanupThread(ConcurrentLRUCache c) {
            this.cache = new WeakReference<ConcurrentLRUCache>(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                ConcurrentLRUCache c;
                CleanupThread cleanupThread = this;
                synchronized (cleanupThread) {
                    if (this.stop) {
                        break;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.stop || (c = (ConcurrentLRUCache)this.cache.get()) == null) break;
                c.markAndSweep();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void wakeThread() {
            CleanupThread cleanupThread = this;
            synchronized (cleanupThread) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopThread() {
            CleanupThread cleanupThread = this;
            synchronized (cleanupThread) {
                this.stop = true;
                this.notify();
            }
        }
    }

    public static interface EvictionListener<K, V> {
        public void evictedEntry(K var1, V var2);
    }

    public static class Stats {
        private final AtomicLong accessCounter = new AtomicLong(0L);
        private final LongAdder putCounter = new LongAdder();
        private final LongAdder nonLivePutCounter = new LongAdder();
        private final LongAdder missCounter = new LongAdder();
        private final AtomicInteger size = new AtomicInteger();
        private AtomicLong evictionCounter = new AtomicLong();

        public long getCumulativeLookups() {
            return this.accessCounter.longValue() - this.putCounter.longValue() - this.nonLivePutCounter.longValue() + this.missCounter.longValue();
        }

        public long getCumulativeHits() {
            return this.accessCounter.longValue() - this.putCounter.longValue() - this.nonLivePutCounter.longValue();
        }

        public long getCumulativePuts() {
            return this.putCounter.longValue();
        }

        public long getCumulativeEvictions() {
            return this.evictionCounter.get();
        }

        public int getCurrentSize() {
            return this.size.get();
        }

        public long getCumulativeNonLivePuts() {
            return this.nonLivePutCounter.longValue();
        }

        public long getCumulativeMisses() {
            return this.missCounter.longValue();
        }

        public void add(Stats other) {
            this.accessCounter.addAndGet(other.accessCounter.get());
            this.putCounter.add(other.putCounter.longValue());
            this.nonLivePutCounter.add(other.nonLivePutCounter.longValue());
            this.missCounter.add(other.missCounter.longValue());
            this.evictionCounter.addAndGet(other.evictionCounter.get());
            this.size.set(Math.max(this.size.get(), other.size.get()));
        }
    }

    public static class CacheEntry<K, V>
    implements Comparable<CacheEntry<K, V>>,
    Accountable {
        public static long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOf(CacheEntry.class);
        K key;
        V value;
        volatile long lastAccessed = 0L;
        long lastAccessedCopy = 0L;

        public CacheEntry(K key, V value, long lastAccessed) {
            this.key = key;
            this.value = value;
            this.lastAccessed = lastAccessed;
        }

        public void setLastAccessed(long lastAccessed) {
            this.lastAccessed = lastAccessed;
        }

        @Override
        public int compareTo(CacheEntry<K, V> that) {
            if (this.lastAccessedCopy == that.lastAccessedCopy) {
                return 0;
            }
            return this.lastAccessedCopy < that.lastAccessedCopy ? 1 : -1;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            return this.value.equals(obj);
        }

        public String toString() {
            return "key: " + this.key + " value: " + this.value + " lastAccessed:" + this.lastAccessed;
        }

        public long ramBytesUsed() {
            long ramBytes = BASE_RAM_BYTES_USED;
            ramBytes = this.key instanceof Accountable ? (ramBytes += ((Accountable)this.key).ramBytesUsed()) : (ramBytes += 192L);
            ramBytes = this.value instanceof Accountable ? (ramBytes += ((Accountable)this.value).ramBytesUsed()) : (ramBytes += 192L);
            return ramBytes;
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    private static class PQueue<K, V>
    extends PriorityQueue<CacheEntry<K, V>> {
        int myMaxSize;
        final Object[] heap = this.getHeapArray();

        PQueue(int maxSz) {
            super(maxSz);
            this.myMaxSize = maxSz;
        }

        Iterable<CacheEntry<K, V>> getValues() {
            return Collections.unmodifiableCollection(Arrays.asList(this.heap));
        }

        protected boolean lessThan(CacheEntry a, CacheEntry b) {
            return b.lastAccessedCopy < a.lastAccessedCopy;
        }

        public CacheEntry<K, V> myInsertWithOverflow(CacheEntry<K, V> element) {
            if (this.size() < this.myMaxSize) {
                this.add(element);
                return null;
            }
            if (this.size() > 0 && !this.lessThan(element, (CacheEntry)this.heap[1])) {
                CacheEntry ret = (CacheEntry)this.heap[1];
                this.heap[1] = element;
                this.updateTop();
                return ret;
            }
            return element;
        }
    }
}

