/*
 * Decompiled with CFR 0.152.
 */
package SevenZip;

import SevenZip.Archive.IArchiveExtractCallback;
import SevenZip.Archive.IInArchive;
import SevenZip.Archive.SevenZipEntry;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class ArchiveExtractCallback
implements IArchiveExtractCallback {
    protected IInArchive archiveHandler;
    protected String filePath;
    protected String diskFilePath;
    public long NumErrors;
    public boolean PasswordIsDefined = false;
    protected String Password;
    protected boolean extractMode;
    protected boolean isDirectory;
    protected final File exractPath;

    public ArchiveExtractCallback(File extractPath) {
        this.exractPath = extractPath;
    }

    public ArchiveExtractCallback() {
        this(null);
    }

    public void Init(IInArchive archiveHandler) {
        this.NumErrors = 0L;
        this.archiveHandler = archiveHandler;
    }

    @Override
    public void SetTotal(long size) {
    }

    @Override
    public void SetCompleted(long completeValue) {
    }

    @Override
    public void PrepareOperation(int askExtractMode) {
        this.extractMode = askExtractMode == 0;
        switch (askExtractMode) {
            case 0: {
                System.out.print("Extracting  ");
                break;
            }
            case 1: {
                System.out.print("Testing     ");
                break;
            }
            case 2: {
                System.out.print("Skipping    ");
            }
        }
        System.out.print(this.filePath);
    }

    @Override
    public void SetOperationResult(int operationResult) throws IOException {
        if (operationResult != 0) {
            ++this.NumErrors;
            System.out.print("     ");
            switch (operationResult) {
                case 1: {
                    throw new IOException("Unsupported Method");
                }
                case 3: {
                    throw new IOException("CRC Failed");
                }
                case 2: {
                    throw new IOException("Data Error");
                }
            }
        }
        System.out.println();
    }

    @Override
    public OutputStream GetStream(int index, int askExtractMode) throws IOException {
        RAOutputStream r = null;
        SevenZipEntry item = this.archiveHandler.getEntry(index);
        this.filePath = item.getName();
        File file = this.exractPath == null ? new File(this.filePath) : new File(this.exractPath, this.filePath);
        this.diskFilePath = file.getAbsolutePath();
        if (askExtractMode == 0) {
            this.isDirectory = item.isDirectory();
            if (this.isDirectory) {
                if (!file.isDirectory() && !file.mkdirs()) {
                    throw new IOException("failed to make directories: " + file);
                }
                return null;
            }
            File dirs = file.getParentFile();
            if (dirs != null && !dirs.isDirectory() && !dirs.mkdirs()) {
                throw new IOException("failed to make directories: " + dirs);
            }
            long pos = item.getPosition();
            if (pos == -1L) {
                file.delete();
            }
            RandomAccessFile outStr = new RandomAccessFile(file, "rw");
            if (pos != -1L) {
                outStr.seek(pos);
            }
            r = new RAOutputStream(outStr);
        }
        return r;
    }

    private class RAOutputStream
    extends OutputStream {
        RandomAccessFile file;

        public RAOutputStream(RandomAccessFile f) {
            this.file = f;
        }

        @Override
        public void close() throws IOException {
            this.file.close();
            this.file = null;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.file.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.file.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.file.write(b);
        }
    }
}

