/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiConfig;
import beast.app.beauti.BeautiDoc;
import beast.app.beauti.BeautiSubTemplate;
import beast.app.beauti.PartitionContext;
import beast.app.beauti.TaxonSetDialog;
import beast.app.draw.BEASTObjectPanel;
import beast.app.draw.BooleanInputEditor;
import beast.app.draw.InputEditor;
import beast.app.draw.SmallButton;
import beast.core.BEASTInterface;
import beast.core.Distribution;
import beast.core.Input;
import beast.core.State;
import beast.core.util.CompoundDistribution;
import beast.core.util.Log;
import beast.evolution.alignment.Taxon;
import beast.evolution.alignment.TaxonSet;
import beast.evolution.operators.TipDatesRandomWalker;
import beast.evolution.tree.Tree;
import beast.math.distributions.MRCAPrior;
import beast.math.distributions.OneOnX;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class MRCAPriorInputEditor
extends InputEditor.Base {
    private static final long serialVersionUID = 1L;
    InputEditor tipsonlyEditor;

    public MRCAPriorInputEditor(BeautiDoc beautiDoc) {
        super(beautiDoc);
    }

    @Override
    public Class<?> type() {
        return MRCAPrior.class;
    }

    @Override
    public void init(Input<?> input, BEASTInterface bEASTInterface, int n, InputEditor.ExpandOption expandOption, boolean bl) {
        Object object;
        this.m_bAddButtons = bl;
        this.m_input = input;
        this.m_beastObject = bEASTInterface;
        this.itemNr = n;
        Box box = Box.createHorizontalBox();
        MRCAPrior mRCAPrior = (MRCAPrior)bEASTInterface;
        String string = mRCAPrior.getID();
        JButton jButton = new JButton(string);
        box.add(jButton);
        jButton.addActionListener(actionEvent -> {
            List list = (List)this.m_input.get();
            MRCAPrior mRCAPrior = (MRCAPrior)list.get(this.itemNr);
            try {
                TaxonSet taxonSet = mRCAPrior.taxonsetInput.get();
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(taxonSet.taxonsetInput.get());
                Set<Taxon> set = this.getTaxonCandidates(mRCAPrior);
                TaxonSetDialog taxonSetDialog = new TaxonSetDialog(taxonSet, set, this.doc);
                if (taxonSetDialog.showDialog()) {
                    if (taxonSetDialog.taxonSet.taxonsetInput.get().size() == 0) {
                        JOptionPane.showMessageDialog(this.doc.beauti, "At least one taxon should be included in the taxon set", "Error specifying taxon set", 0);
                        taxonSet.taxonsetInput.get().addAll(arrayList);
                        return;
                    }
                    mRCAPrior.taxonsetInput.setValue(taxonSetDialog.taxonSet, mRCAPrior);
                    int n = 1;
                    String string = taxonSetDialog.taxonSet.getID();
                    while (this.doc.pluginmap.containsKey(taxonSetDialog.taxonSet.getID()) && this.doc.pluginmap.get(taxonSetDialog.taxonSet.getID()) != taxonSetDialog.taxonSet) {
                        taxonSetDialog.taxonSet.setID(string + n);
                        ++n;
                    }
                    BEASTObjectPanel.addPluginToMap(taxonSetDialog.taxonSet, this.doc);
                    mRCAPrior.setID(taxonSetDialog.taxonSet.getID() + ".prior");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.refreshPanel();
        });
        if (mRCAPrior.distInput.getType() == null) {
            try {
                mRCAPrior.distInput.setValue(new OneOnX(), mRCAPrior);
                mRCAPrior.distInput.setValue(null, mRCAPrior);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        List<BeautiSubTemplate> list = this.doc.getInputEditorFactory().getAvailableTemplates(mRCAPrior.distInput, mRCAPrior, null, this.doc);
        JComboBox<BeautiSubTemplate> jComboBox = new JComboBox<BeautiSubTemplate>(list.toArray(new BeautiSubTemplate[0]));
        jComboBox.setName(string + ".distr");
        if (mRCAPrior.distInput.get() != null) {
            object = mRCAPrior.distInput.get().getID();
            object = ((String)object).substring(0, ((String)object).indexOf(46));
            for (BeautiSubTemplate beautiSubTemplate : list) {
                if (beautiSubTemplate.classInput.get() == null || !beautiSubTemplate.shortClassName.equals(object)) continue;
                jComboBox.setSelectedItem(beautiSubTemplate);
            }
        } else {
            jComboBox.setSelectedItem(BeautiConfig.NULL_TEMPLATE);
        }
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                BeautiSubTemplate beautiSubTemplate = (BeautiSubTemplate)jComboBox.getSelectedItem();
                List list = (List)MRCAPriorInputEditor.this.m_input.get();
                MRCAPrior mRCAPrior = (MRCAPrior)list.get(MRCAPriorInputEditor.this.itemNr);
                try {
                    beautiSubTemplate.createSubNet(new PartitionContext(""), mRCAPrior, mRCAPrior.distInput, true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                MRCAPriorInputEditor.this.refreshPanel();
            }
        });
        box.add(jComboBox);
        object = new JCheckBox(this.doc.beautiConfig.getInputLabel(mRCAPrior, mRCAPrior.isMonophyleticInput.getName()));
        ((Component)object).setName(string + ".isMonophyletic");
        ((AbstractButton)object).setSelected(mRCAPrior.isMonophyleticInput.get());
        ((JComponent)object).setToolTipText(mRCAPrior.isMonophyleticInput.getHTMLTipText());
        ((AbstractButton)object).addActionListener(new MRCAPriorActionListener(mRCAPrior));
        box.add((Component)object);
        SmallButton smallButton = new SmallButton("-", true);
        smallButton.setToolTipText("Delete this calibration");
        smallButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Log.warning.println("Trying to delete a calibration");
                List list = (List)MRCAPriorInputEditor.this.m_input.get();
                MRCAPrior mRCAPrior = (MRCAPrior)list.get(MRCAPriorInputEditor.this.itemNr);
                MRCAPriorInputEditor.this.doc.disconnect(mRCAPrior, "prior", "distribution");
                MRCAPriorInputEditor.this.doc.disconnect(mRCAPrior, "tracelog", "log");
                if (mRCAPrior.onlyUseTipsInput.get().booleanValue()) {
                    MRCAPriorInputEditor.disableTipSampling(MRCAPriorInputEditor.this.m_beastObject, MRCAPriorInputEditor.this.doc);
                }
                MRCAPriorInputEditor.this.doc.unregisterPlugin(mRCAPrior);
                MRCAPriorInputEditor.this.refreshPanel();
            }
        });
        box.add(Box.createGlue());
        box.add(smallButton);
        this.add(box);
    }

    public static void customConnector(BeautiDoc beautiDoc) {
        BEASTInterface bEASTInterface = beautiDoc.pluginmap.get("prior");
        if (bEASTInterface != null && bEASTInterface instanceof CompoundDistribution) {
            CompoundDistribution compoundDistribution = (CompoundDistribution)bEASTInterface;
            for (Distribution distribution : compoundDistribution.pDistributions.get()) {
                if (!(distribution instanceof MRCAPrior)) continue;
                MRCAPrior mRCAPrior = (MRCAPrior)distribution;
                if (mRCAPrior.treeInput.get() == null) continue;
                boolean bl = false;
                for (BEASTInterface bEASTInterface2 : mRCAPrior.treeInput.get().getOutputs()) {
                    if (!(bEASTInterface2 instanceof State)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                beautiDoc.disconnect(mRCAPrior, "prior", "distribution");
                beautiDoc.disconnect(mRCAPrior, "tracelog", "log");
                if (mRCAPrior.onlyUseTipsInput.get().booleanValue()) {
                    MRCAPriorInputEditor.disableTipSampling(mRCAPrior, beautiDoc);
                }
                beautiDoc.unregisterPlugin(mRCAPrior);
                return;
            }
        }
    }

    Set<Taxon> getTaxonCandidates(MRCAPrior mRCAPrior) {
        HashSet<Taxon> hashSet = new HashSet<Taxon>();
        Tree tree = mRCAPrior.treeInput.get();
        String[] stringArray = null;
        if (tree.m_taxonset.get() != null) {
            try {
                String[] stringArray2 = tree.m_taxonset.get();
                stringArray2.initAndValidate();
                stringArray = stringArray2.asStringList().toArray(new String[0]);
            }
            catch (Exception exception) {
                stringArray = mRCAPrior.treeInput.get().getTaxaNames();
            }
        } else {
            stringArray = mRCAPrior.treeInput.get().getTaxaNames();
        }
        for (String string : stringArray) {
            hashSet.add(this.doc.getTaxon(string));
        }
        return hashSet;
    }

    public InputEditor createTipsonlyEditor() throws NoSuchMethodException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        BooleanInputEditor booleanInputEditor = new BooleanInputEditor(this.doc){
            private static final long serialVersionUID = 1L;

            @Override
            public void init(Input<?> input, BEASTInterface bEASTInterface, int n, InputEditor.ExpandOption expandOption, boolean bl) {
                super.init(input, bEASTInterface, n, expandOption, bl);
                Component[] componentArray = this.getComponents();
                ((JCheckBox)componentArray[0]).addActionListener(actionEvent -> {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    if (jCheckBox.isSelected()) {
                        MRCAPriorInputEditor.this.enableTipSampling();
                    } else {
                        MRCAPriorInputEditor.disableTipSampling(this.m_beastObject, this.doc);
                    }
                });
            }
        };
        MRCAPrior mRCAPrior = (MRCAPrior)this.m_beastObject;
        Input<Boolean> input = mRCAPrior.onlyUseTipsInput;
        booleanInputEditor.init(input, mRCAPrior, -1, InputEditor.ExpandOption.FALSE, false);
        return booleanInputEditor;
    }

    private void enableTipSampling() {
        TipDatesRandomWalker tipDatesRandomWalker = null;
        MRCAPrior mRCAPrior = (MRCAPrior)this.m_beastObject;
        TaxonSet taxonSet = mRCAPrior.taxonsetInput.get();
        taxonSet.initAndValidate();
        for (BEASTInterface bEASTInterface : taxonSet.getOutputs()) {
            if (!(bEASTInterface instanceof TipDatesRandomWalker)) continue;
            tipDatesRandomWalker = (TipDatesRandomWalker)bEASTInterface;
        }
        if (tipDatesRandomWalker == null) {
            tipDatesRandomWalker = new TipDatesRandomWalker();
            tipDatesRandomWalker.initByName("tree", mRCAPrior.treeInput.get(), "taxonset", taxonSet, "windowSize", 1.0, "weight", 1.0);
        }
        tipDatesRandomWalker.setID("tipDatesSampler." + taxonSet.getID());
        this.doc.mcmc.get().setInputValue("operator", tipDatesRandomWalker);
    }

    private static void disableTipSampling(BEASTInterface bEASTInterface, BeautiDoc beautiDoc) {
        TipDatesRandomWalker tipDatesRandomWalker = null;
        MRCAPrior mRCAPrior = (MRCAPrior)bEASTInterface;
        TaxonSet taxonSet = mRCAPrior.taxonsetInput.get();
        for (BEASTInterface object : taxonSet.getOutputs()) {
            if (!(object instanceof TipDatesRandomWalker)) continue;
            tipDatesRandomWalker = (TipDatesRandomWalker)object;
        }
        if (tipDatesRandomWalker == null) {
            return;
        }
        Input<?> input = beautiDoc.mcmc.get().getInput("operator");
        if (input instanceof Input) {
            Input input2 = input;
            List list = (List)input2.get();
            list.remove(tipDatesRandomWalker);
        }
    }

    class MRCAPriorActionListener
    implements ActionListener {
        MRCAPrior m_prior;

        MRCAPriorActionListener(MRCAPrior mRCAPrior) {
            this.m_prior = mRCAPrior;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.m_prior.isMonophyleticInput.setValue(((JCheckBox)actionEvent.getSource()).isSelected(), this.m_prior);
                MRCAPriorInputEditor.this.refreshPanel();
            }
            catch (Exception exception) {
                Log.warning.println("PriorListInputEditor " + exception.getMessage());
            }
        }
    }
}

