/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree;

import beast.evolution.alignment.TaxonSet;
import beast.evolution.tree.Node;
import java.util.List;

public interface TreeInterface {
    public String getID();

    public int getLeafNodeCount();

    public int getInternalNodeCount();

    public int getNodeCount();

    public Node getRoot();

    public Node getNode(int var1);

    public Node[] getNodesAsArray();

    public List<Node> getExternalNodes();

    public List<Node> getInternalNodes();

    public TaxonSet getTaxonset();

    public boolean somethingIsDirty();

    public void getMetaData(Node var1, Double[] var2, String var3);

    public void setMetaData(Node var1, Double[] var2, String var3);

    default public Node[] listNodesPostOrder(Node node, Node[] nodeArray) {
        if (node == null) {
            node = this.getRoot();
        }
        if (nodeArray == null) {
            int n = node == this.getRoot() ? this.getNodeCount() : node.getNodeCount();
            nodeArray = new Node[n];
        }
        TreeInterface.getNodesPostOrder(node, nodeArray, 0);
        return nodeArray;
    }

    public static int getNodesPostOrder(Node node, Node[] nodeArray, int n) {
        for (Node node2 : node.children) {
            n = TreeInterface.getNodesPostOrder(node2, nodeArray, n);
        }
        nodeArray[n] = node;
        return n + 1;
    }
}

