/*
 * Decompiled with CFR 0.152.
 */
package beast.math.distributions;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.math.distributions.ParametricDistribution;
import org.apache.commons.math.distribution.Distribution;
import org.apache.commons.math.distribution.PoissonDistribution;
import org.apache.commons.math.distribution.PoissonDistributionImpl;

@Description(value="Poisson distribution, used as prior  f(k; lambda)=\\frac{lambda^k e^{-lambda}}{k!}  If the input x is a multidimensional parameter, each of the dimensions is considered as a separate independent component.")
public class Poisson
extends ParametricDistribution {
    public final Input<RealParameter> lambdaInput = new Input("lambda", "rate parameter, defaults to 1");
    static PoissonDistribution dist = new PoissonDistributionImpl(1.0);

    public Poisson() {
    }

    public Poisson(RealParameter realParameter) {
        try {
            this.initByName("lambda", realParameter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Failed to initByName lambda parameter when constructing Poisson instance.");
        }
    }

    @Override
    public void initAndValidate() {
        this.refresh();
    }

    void refresh() {
        double d;
        if (this.lambdaInput.get() == null) {
            d = 1.0;
        } else {
            d = this.lambdaInput.get().getValue();
            if (d < 0.0) {
                d = 1.0;
            }
        }
        dist.setMean(d);
    }

    @Override
    public Distribution getDistribution() {
        this.refresh();
        return dist;
    }

    @Override
    public double getMean() {
        return this.lambdaInput.get().getValue();
    }
}

