/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ConcurrentModificationException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;

public class MathRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -5128983364075381060L;
    private final String pattern;
    private final Object[] arguments;

    public MathRuntimeException(String string, Object ... objectArray) {
        this.pattern = string;
        this.arguments = objectArray == null ? new Object[]{} : (Object[])objectArray.clone();
    }

    public MathRuntimeException(Throwable throwable) {
        super(throwable);
        this.pattern = this.getMessage();
        this.arguments = new Object[0];
    }

    public MathRuntimeException(Throwable throwable, String string, Object ... objectArray) {
        super(throwable);
        this.pattern = string;
        this.arguments = objectArray == null ? new Object[]{} : (Object[])objectArray.clone();
    }

    private static String translate(String string, Locale locale) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("org.apache.commons.math.MessagesResources", locale);
            if (resourceBundle.getLocale().getLanguage().equals(locale.getLanguage())) {
                return resourceBundle.getString(string);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string;
    }

    private static String buildMessage(Locale locale, String string, Object ... objectArray) {
        return string == null ? "" : new MessageFormat(MathRuntimeException.translate(string, locale), locale).format(objectArray);
    }

    public String getPattern() {
        return this.pattern;
    }

    public Object[] getArguments() {
        return (Object[])this.arguments.clone();
    }

    public String getMessage(Locale locale) {
        return MathRuntimeException.buildMessage(locale, this.pattern, this.arguments);
    }

    @Override
    public String getMessage() {
        return this.getMessage(Locale.US);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage(Locale.getDefault());
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            PrintWriter printWriter = new PrintWriter(printStream, false);
            this.printStackTrace(printWriter);
            printWriter.flush();
        }
    }

    public static ArithmeticException createArithmeticException(final String string, final Object ... objectArray) {
        return new ArithmeticException(){
            private static final long serialVersionUID = 7705628723242533939L;

            @Override
            public String getMessage() {
                return MathRuntimeException.buildMessage(Locale.US, string, objectArray);
            }

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), string, objectArray);
            }
        };
    }

    public static ArrayIndexOutOfBoundsException createArrayIndexOutOfBoundsException(final String string, final Object ... objectArray) {
        return new ArrayIndexOutOfBoundsException(){
            private static final long serialVersionUID = -3394748305449283486L;

            @Override
            public String getMessage() {
                return MathRuntimeException.buildMessage(Locale.US, string, objectArray);
            }

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), string, objectArray);
            }
        };
    }

    public static EOFException createEOFException(final String string, final Object ... objectArray) {
        return new EOFException(){
            private static final long serialVersionUID = 279461544586092584L;

            @Override
            public String getMessage() {
                return MathRuntimeException.buildMessage(Locale.US, string, objectArray);
            }

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), string, objectArray);
            }
        };
    }

    public static IOException createIOException(Throwable throwable) {
        IOException iOException = new IOException(throwable.getLocalizedMessage());
        iOException.initCause(throwable);
        return iOException;
    }

    public static IllegalArgumentException createIllegalArgumentException(final String string, final Object ... objectArray) {
        return new IllegalArgumentException(){
            private static final long serialVersionUID = -6555453980658317913L;

            @Override
            public String getMessage() {
                return MathRuntimeException.buildMessage(Locale.US, string, objectArray);
            }

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), string, objectArray);
            }
        };
    }

    public static IllegalArgumentException createIllegalArgumentException(Throwable throwable) {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(throwable.getLocalizedMessage());
        illegalArgumentException.initCause(throwable);
        return illegalArgumentException;
    }

    public static IllegalStateException createIllegalStateException(final String string, final Object ... objectArray) {
        return new IllegalStateException(){
            private static final long serialVersionUID = -95247648156277208L;

            @Override
            public String getMessage() {
                return MathRuntimeException.buildMessage(Locale.US, string, objectArray);
            }

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), string, objectArray);
            }
        };
    }

    public static ConcurrentModificationException createConcurrentModificationException(final String string, final Object ... objectArray) {
        return new ConcurrentModificationException(){
            private static final long serialVersionUID = 6134247282754009421L;

            @Override
            public String getMessage() {
                return MathRuntimeException.buildMessage(Locale.US, string, objectArray);
            }

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), string, objectArray);
            }
        };
    }

    public static NoSuchElementException createNoSuchElementException(final String string, final Object ... objectArray) {
        return new NoSuchElementException(){
            private static final long serialVersionUID = 7304273322489425799L;

            @Override
            public String getMessage() {
                return MathRuntimeException.buildMessage(Locale.US, string, objectArray);
            }

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), string, objectArray);
            }
        };
    }

    public static NullPointerException createNullPointerException(final String string, final Object ... objectArray) {
        return new NullPointerException(){
            private static final long serialVersionUID = -3075660477939965216L;

            @Override
            public String getMessage() {
                return MathRuntimeException.buildMessage(Locale.US, string, objectArray);
            }

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), string, objectArray);
            }
        };
    }

    public static ParseException createParseException(int n, final String string, final Object ... objectArray) {
        return new ParseException(null, n){
            private static final long serialVersionUID = -1103502177342465975L;

            @Override
            public String getMessage() {
                return MathRuntimeException.buildMessage(Locale.US, string, objectArray);
            }

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), string, objectArray);
            }
        };
    }

    public static RuntimeException createInternalError(Throwable throwable) {
        return new RuntimeException(){
            private static final long serialVersionUID = -201865440834027016L;

            @Override
            public String getMessage() {
                return MathRuntimeException.buildMessage(Locale.US, "internal error, please fill a bug report at {0}", new Object[]{"https://issues.apache.org/jira/browse/MATH"});
            }

            @Override
            public String getLocalizedMessage() {
                return MathRuntimeException.buildMessage(Locale.getDefault(), "internal error, please fill a bug report at {0}", new Object[]{"https://issues.apache.org/jira/browse/MATH"});
            }
        };
    }
}

