/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.integration;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.integration.UnivariateRealIntegratorImpl;

public class TrapezoidIntegrator
extends UnivariateRealIntegratorImpl {
    private double s;

    @Deprecated
    public TrapezoidIntegrator(UnivariateRealFunction univariateRealFunction) {
        super(univariateRealFunction, 64);
    }

    public TrapezoidIntegrator() {
        super(64);
    }

    double stage(UnivariateRealFunction univariateRealFunction, double d, double d2, int n) throws FunctionEvaluationException {
        if (n == 0) {
            this.s = 0.5 * (d2 - d) * (univariateRealFunction.value(d) + univariateRealFunction.value(d2));
            return this.s;
        }
        long l = 1L << n - 1;
        double d3 = 0.0;
        double d4 = (d2 - d) / (double)l;
        double d5 = d + 0.5 * d4;
        for (long i = 0L; i < l; ++i) {
            d3 += univariateRealFunction.value(d5);
            d5 += d4;
        }
        this.s = 0.5 * (this.s + d3 * d4);
        return this.s;
    }

    @Override
    @Deprecated
    public double integrate(double d, double d2) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        return this.integrate(this.f, d, d2);
    }

    @Override
    public double integrate(UnivariateRealFunction univariateRealFunction, double d, double d2) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        this.clearResult();
        this.verifyInterval(d, d2);
        this.verifyIterationCount();
        double d3 = this.stage(univariateRealFunction, d, d2, 0);
        for (int i = 1; i <= this.maximalIterationCount; ++i) {
            double d4;
            double d5;
            double d6 = this.stage(univariateRealFunction, d, d2, i);
            if (i >= this.minimalIterationCount && ((d5 = Math.abs(d6 - d3)) <= (d4 = this.relativeAccuracy * (Math.abs(d3) + Math.abs(d6)) * 0.5) || d5 <= this.absoluteAccuracy)) {
                this.setResult(d6, i);
                return this.result;
            }
            d3 = d6;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }

    @Override
    protected void verifyIterationCount() throws IllegalArgumentException {
        super.verifyIterationCount();
        if (this.maximalIterationCount > 64) {
            throw MathRuntimeException.createIllegalArgumentException("invalid iteration limits: min={0}, max={1}", 0, 64);
        }
    }
}

