/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.ExponentialDistribution;

public class ExponentialDistributionImpl
extends AbstractContinuousDistribution
implements ExponentialDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 2401296428283614780L;
    private double mean;
    private final double solverAbsoluteAccuracy;

    public ExponentialDistributionImpl(double d) {
        this(d, 1.0E-9);
    }

    public ExponentialDistributionImpl(double d, double d2) {
        this.setMeanInternal(d);
        this.solverAbsoluteAccuracy = d2;
    }

    @Override
    @Deprecated
    public void setMean(double d) {
        this.setMeanInternal(d);
    }

    private void setMeanInternal(double d) {
        if (d <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("mean must be positive ({0})", d);
        }
        this.mean = d;
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    @Deprecated
    public double density(Double d) {
        return this.density((double)d);
    }

    @Override
    public double density(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        return Math.exp(-d / this.mean) / this.mean;
    }

    @Override
    public double cumulativeProbability(double d) throws MathException {
        double d2 = d <= 0.0 ? 0.0 : 1.0 - Math.exp(-d / this.mean);
        return d2;
    }

    @Override
    public double inverseCumulativeProbability(double d) throws MathException {
        if (d < 0.0 || d > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException("{0} out of [{1}, {2}] range", d, 0.0, 1.0);
        }
        double d2 = d == 1.0 ? Double.POSITIVE_INFINITY : -this.mean * Math.log(1.0 - d);
        return d2;
    }

    @Override
    protected double getDomainLowerBound(double d) {
        return 0.0;
    }

    @Override
    protected double getDomainUpperBound(double d) {
        if (d < 0.5) {
            return this.mean;
        }
        return Double.MAX_VALUE;
    }

    @Override
    protected double getInitialDomain(double d) {
        if (d < 0.5) {
            return this.mean * 0.5;
        }
        return this.mean;
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }
}

