/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.math.MathRuntimeException;

public final class MathUtils {
    public static final double EPSILON = (double)1.110223E-16f;
    public static final double SAFE_MIN = Double.MIN_NORMAL;
    public static final double TWO_PI = Math.PI * 2;
    private static final byte NB = -1;
    private static final short NS = -1;
    private static final byte PB = 1;
    private static final short PS = 1;
    private static final byte ZB = 0;
    private static final short ZS = 0;
    private static final int NAN_GAP = 0x400000;
    private static final long SGN_MASK = Long.MIN_VALUE;
    private static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};

    private MathUtils() {
    }

    public static int addAndCheck(int n, int n2) {
        long l = (long)n + (long)n2;
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: add");
        }
        return (int)l;
    }

    public static long addAndCheck(long l, long l2) {
        return MathUtils.addAndCheck(l, l2, "overflow: add");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long addAndCheck(long l, long l2, String string) {
        if (l > l2) {
            return MathUtils.addAndCheck(l2, l, string);
        }
        if (l < 0L) {
            if (l2 >= 0L) return l + l2;
            if (Long.MIN_VALUE - l2 > l) throw new ArithmeticException(string);
            return l + l2;
        }
        if (l > Long.MAX_VALUE - l2) throw new ArithmeticException(string);
        return l + l2;
    }

    public static long binomialCoefficient(int n, int n2) {
        MathUtils.checkBinomial(n, n2);
        if (n == n2 || n2 == 0) {
            return 1L;
        }
        if (n2 == 1 || n2 == n - 1) {
            return n;
        }
        if (n2 > n / 2) {
            return MathUtils.binomialCoefficient(n, n - n2);
        }
        long l = 1L;
        if (n <= 61) {
            int n3 = n - n2 + 1;
            for (int i = 1; i <= n2; ++i) {
                l = l * (long)n3 / (long)i;
                ++n3;
            }
        } else if (n <= 66) {
            int n4 = n - n2 + 1;
            for (int i = 1; i <= n2; ++i) {
                long l2 = MathUtils.gcd(n4, i);
                l = l / ((long)i / l2) * ((long)n4 / l2);
                ++n4;
            }
        } else {
            int n5 = n - n2 + 1;
            for (int i = 1; i <= n2; ++i) {
                long l3 = MathUtils.gcd(n5, i);
                l = MathUtils.mulAndCheck(l / ((long)i / l3), (long)n5 / l3);
                ++n5;
            }
        }
        return l;
    }

    public static double binomialCoefficientDouble(int n, int n2) {
        MathUtils.checkBinomial(n, n2);
        if (n == n2 || n2 == 0) {
            return 1.0;
        }
        if (n2 == 1 || n2 == n - 1) {
            return n;
        }
        if (n2 > n / 2) {
            return MathUtils.binomialCoefficientDouble(n, n - n2);
        }
        if (n < 67) {
            return MathUtils.binomialCoefficient(n, n2);
        }
        double d = 1.0;
        for (int i = 1; i <= n2; ++i) {
            d *= (double)(n - n2 + i) / (double)i;
        }
        return Math.floor(d + 0.5);
    }

    public static double binomialCoefficientLog(int n, int n2) {
        int n3;
        MathUtils.checkBinomial(n, n2);
        if (n == n2 || n2 == 0) {
            return 0.0;
        }
        if (n2 == 1 || n2 == n - 1) {
            return Math.log(n);
        }
        if (n < 67) {
            return Math.log(MathUtils.binomialCoefficient(n, n2));
        }
        if (n < 1030) {
            return Math.log(MathUtils.binomialCoefficientDouble(n, n2));
        }
        if (n2 > n / 2) {
            return MathUtils.binomialCoefficientLog(n, n - n2);
        }
        double d = 0.0;
        for (n3 = n - n2 + 1; n3 <= n; ++n3) {
            d += Math.log(n3);
        }
        for (n3 = 2; n3 <= n2; ++n3) {
            d -= Math.log(n3);
        }
        return d;
    }

    private static void checkBinomial(int n, int n2) throws IllegalArgumentException {
        if (n < n2) {
            throw MathRuntimeException.createIllegalArgumentException("must have n >= k for binomial coefficient (n,k), got n = {0}, k = {1}", n, n2);
        }
        if (n < 0) {
            throw MathRuntimeException.createIllegalArgumentException("must have n >= 0 for binomial coefficient (n,k), got n = {0}", n);
        }
    }

    public static int compareTo(double d, double d2, double d3) {
        if (MathUtils.equals(d, d2, d3)) {
            return 0;
        }
        if (d < d2) {
            return -1;
        }
        return 1;
    }

    public static double cosh(double d) {
        return (Math.exp(d) + Math.exp(-d)) / 2.0;
    }

    public static boolean equals(double d, double d2) {
        return Double.isNaN(d) && Double.isNaN(d2) || d == d2;
    }

    public static boolean equals(double d, double d2, double d3) {
        return MathUtils.equals(d, d2) || Math.abs(d2 - d) <= d3;
    }

    public static boolean equals(double d, double d2, int n) {
        assert (n > 0 && n < 0x400000);
        long l = Double.doubleToLongBits(d);
        long l2 = Double.doubleToLongBits(d2);
        if (l < 0L) {
            l = Long.MIN_VALUE - l;
        }
        if (l2 < 0L) {
            l2 = Long.MIN_VALUE - l2;
        }
        return Math.abs(l - l2) <= (long)n;
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            return !(dArray == null ^ dArray2 == null);
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (MathUtils.equals(dArray[i], dArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static long factorial(int n) {
        if (n < 0) {
            throw MathRuntimeException.createIllegalArgumentException("must have n >= 0 for n!, got n = {0}", n);
        }
        if (n > 20) {
            throw new ArithmeticException("factorial value is too large to fit in a long");
        }
        return FACTORIALS[n];
    }

    public static double factorialDouble(int n) {
        if (n < 0) {
            throw MathRuntimeException.createIllegalArgumentException("must have n >= 0 for n!, got n = {0}", n);
        }
        if (n < 21) {
            return MathUtils.factorial(n);
        }
        return Math.floor(Math.exp(MathUtils.factorialLog(n)) + 0.5);
    }

    public static double factorialLog(int n) {
        if (n < 0) {
            throw MathRuntimeException.createIllegalArgumentException("must have n >= 0 for n!, got n = {0}", n);
        }
        if (n < 21) {
            return Math.log(MathUtils.factorial(n));
        }
        double d = 0.0;
        for (int i = 2; i <= n; ++i) {
            d += Math.log(i);
        }
        return d;
    }

    public static int gcd(int n, int n2) {
        int n3;
        int n4;
        int n5 = n;
        int n6 = n2;
        if (n5 == 0 || n6 == 0) {
            if (n5 == Integer.MIN_VALUE || n6 == Integer.MIN_VALUE) {
                throw MathRuntimeException.createArithmeticException("overflow: gcd({0}, {1}) is 2^31", n, n2);
            }
            return Math.abs(n5) + Math.abs(n6);
        }
        if (n5 > 0) {
            n5 = -n5;
        }
        if (n6 > 0) {
            n6 = -n6;
        }
        for (n4 = 0; (n5 & 1) == 0 && (n6 & 1) == 0 && n4 < 31; ++n4) {
            n5 /= 2;
            n6 /= 2;
        }
        if (n4 == 31) {
            throw MathRuntimeException.createArithmeticException("overflow: gcd({0}, {1}) is 2^31", n, n2);
        }
        int n7 = n3 = (n5 & 1) == 1 ? n6 : -(n5 / 2);
        while (true) {
            if ((n3 & 1) == 0) {
                n3 /= 2;
                continue;
            }
            if (n3 > 0) {
                n5 = -n3;
            } else {
                n6 = n3;
            }
            if ((n3 = (n6 - n5) / 2) == 0) break;
        }
        return -n5 * (1 << n4);
    }

    public static long gcd(long l, long l2) {
        long l3;
        int n;
        long l4 = l;
        long l5 = l2;
        if (l4 == 0L || l5 == 0L) {
            if (l4 == Long.MIN_VALUE || l5 == Long.MIN_VALUE) {
                throw MathRuntimeException.createArithmeticException("overflow: gcd({0}, {1}) is 2^63", l, l2);
            }
            return Math.abs(l4) + Math.abs(l5);
        }
        if (l4 > 0L) {
            l4 = -l4;
        }
        if (l5 > 0L) {
            l5 = -l5;
        }
        for (n = 0; (l4 & 1L) == 0L && (l5 & 1L) == 0L && n < 63; ++n) {
            l4 /= 2L;
            l5 /= 2L;
        }
        if (n == 63) {
            throw MathRuntimeException.createArithmeticException("overflow: gcd({0}, {1}) is 2^63", l, l2);
        }
        long l6 = l3 = (l4 & 1L) == 1L ? l5 : -(l4 / 2L);
        while (true) {
            if ((l3 & 1L) == 0L) {
                l3 /= 2L;
                continue;
            }
            if (l3 > 0L) {
                l4 = -l3;
            } else {
                l5 = l3;
            }
            if ((l3 = (l5 - l4) / 2L) == 0L) break;
        }
        return -l4 * (1L << n);
    }

    public static int hash(double d) {
        return new Double(d).hashCode();
    }

    public static int hash(double[] dArray) {
        return Arrays.hashCode(dArray);
    }

    public static byte indicator(byte by) {
        return by >= 0 ? (byte)1 : -1;
    }

    public static double indicator(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return d >= 0.0 ? 1.0 : -1.0;
    }

    public static float indicator(float f) {
        if (Float.isNaN(f)) {
            return Float.NaN;
        }
        return f >= 0.0f ? 1.0f : -1.0f;
    }

    public static int indicator(int n) {
        return n >= 0 ? 1 : -1;
    }

    public static long indicator(long l) {
        return l >= 0L ? 1L : -1L;
    }

    public static short indicator(short s) {
        return s >= 0 ? (short)1 : -1;
    }

    public static int lcm(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        int n3 = Math.abs(MathUtils.mulAndCheck(n / MathUtils.gcd(n, n2), n2));
        if (n3 == Integer.MIN_VALUE) {
            throw MathRuntimeException.createArithmeticException("overflow: lcm({0}, {1}) is 2^31", n, n2);
        }
        return n3;
    }

    public static long lcm(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return 0L;
        }
        long l3 = Math.abs(MathUtils.mulAndCheck(l / MathUtils.gcd(l, l2), l2));
        if (l3 == Long.MIN_VALUE) {
            throw MathRuntimeException.createArithmeticException("overflow: lcm({0}, {1}) is 2^63", l, l2);
        }
        return l3;
    }

    public static double log(double d, double d2) {
        return Math.log(d2) / Math.log(d);
    }

    public static int mulAndCheck(int n, int n2) {
        long l = (long)n * (long)n2;
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: mul");
        }
        return (int)l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long mulAndCheck(long l, long l2) {
        String string = "overflow: multiply";
        if (l > l2) {
            return MathUtils.mulAndCheck(l2, l);
        }
        if (l < 0L) {
            if (l2 < 0L) {
                if (l < Long.MAX_VALUE / l2) throw new ArithmeticException(string);
                return l * l2;
            }
            if (l2 <= 0L) return 0L;
            if (Long.MIN_VALUE / l2 > l) throw new ArithmeticException(string);
            return l * l2;
        }
        if (l <= 0L) return 0L;
        if (l > Long.MAX_VALUE / l2) throw new ArithmeticException(string);
        return l * l2;
    }

    public static double nextAfter(double d, double d2) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return d;
        }
        if (d == 0.0) {
            return d2 < 0.0 ? -4.9E-324 : Double.MIN_VALUE;
        }
        long l = Double.doubleToLongBits(d);
        long l2 = l & Long.MIN_VALUE;
        long l3 = l & 0x7FF0000000000000L;
        long l4 = l & 0xFFFFFFFFFFFFFL;
        if (d * (d2 - d) >= 0.0) {
            if (l4 == 0xFFFFFFFFFFFFFL) {
                return Double.longBitsToDouble(l2 | l3 + 0x10000000000000L);
            }
            return Double.longBitsToDouble(l2 | l3 | l4 + 1L);
        }
        if (l4 == 0L) {
            return Double.longBitsToDouble(l2 | l3 - 0x10000000000000L | 0xFFFFFFFFFFFFFL);
        }
        return Double.longBitsToDouble(l2 | l3 | l4 - 1L);
    }

    public static double scalb(double d, int n) {
        if (d == 0.0 || Double.isNaN(d) || Double.isInfinite(d)) {
            return d;
        }
        long l = Double.doubleToLongBits(d);
        long l2 = l & 0x7FF0000000000000L;
        long l3 = l & 0x800FFFFFFFFFFFFFL;
        long l4 = l3 | l2 + ((long)n << 52);
        return Double.longBitsToDouble(l4);
    }

    public static double normalizeAngle(double d, double d2) {
        return d - Math.PI * 2 * Math.floor((d + Math.PI - d2) / (Math.PI * 2));
    }

    public static double[] normalizeArray(double[] dArray, double d) throws ArithmeticException, IllegalArgumentException {
        int n;
        if (Double.isInfinite(d)) {
            throw MathRuntimeException.createIllegalArgumentException("Cannot normalize to an infinite value", new Object[0]);
        }
        if (Double.isNaN(d)) {
            throw MathRuntimeException.createIllegalArgumentException("Cannot normalize to NaN", new Object[0]);
        }
        double d2 = 0.0;
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            if (Double.isInfinite(dArray[n])) {
                throw MathRuntimeException.createArithmeticException("Array contains an infinite element, {0} at index {1}", dArray[n], n);
            }
            if (Double.isNaN(dArray[n])) continue;
            d2 += dArray[n];
        }
        if (d2 == 0.0) {
            throw MathRuntimeException.createArithmeticException("Array sums to zero", new Object[0]);
        }
        for (n = 0; n < n2; ++n) {
            dArray2[n] = Double.isNaN(dArray[n]) ? Double.NaN : dArray[n] * d / d2;
        }
        return dArray2;
    }

    public static double round(double d, int n) {
        return MathUtils.round(d, n, 4);
    }

    public static double round(double d, int n, int n2) {
        try {
            return new BigDecimal(Double.toString(d)).setScale(n, n2).doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            if (Double.isInfinite(d)) {
                return d;
            }
            return Double.NaN;
        }
    }

    public static float round(float f, int n) {
        return MathUtils.round(f, n, 4);
    }

    public static float round(float f, int n, int n2) {
        float f2 = MathUtils.indicator(f);
        float f3 = (float)Math.pow(10.0, n) * f2;
        return (float)MathUtils.roundUnscaled(f * f3, f2, n2) / f3;
    }

    private static double roundUnscaled(double d, double d2, int n) {
        switch (n) {
            case 2: {
                if (d2 == -1.0) {
                    d = Math.floor(MathUtils.nextAfter(d, Double.NEGATIVE_INFINITY));
                    break;
                }
                d = Math.ceil(MathUtils.nextAfter(d, Double.POSITIVE_INFINITY));
                break;
            }
            case 1: {
                d = Math.floor(MathUtils.nextAfter(d, Double.NEGATIVE_INFINITY));
                break;
            }
            case 3: {
                if (d2 == -1.0) {
                    d = Math.ceil(MathUtils.nextAfter(d, Double.POSITIVE_INFINITY));
                    break;
                }
                d = Math.floor(MathUtils.nextAfter(d, Double.NEGATIVE_INFINITY));
                break;
            }
            case 5: {
                d = MathUtils.nextAfter(d, Double.NEGATIVE_INFINITY);
                double d3 = d - Math.floor(d);
                if (d3 > 0.5) {
                    d = Math.ceil(d);
                    break;
                }
                d = Math.floor(d);
                break;
            }
            case 6: {
                double d4 = d - Math.floor(d);
                if (d4 > 0.5) {
                    d = Math.ceil(d);
                    break;
                }
                if (d4 < 0.5) {
                    d = Math.floor(d);
                    break;
                }
                if (Math.floor(d) / 2.0 == Math.floor(Math.floor(d) / 2.0)) {
                    d = Math.floor(d);
                    break;
                }
                d = Math.ceil(d);
                break;
            }
            case 4: {
                d = MathUtils.nextAfter(d, Double.POSITIVE_INFINITY);
                double d5 = d - Math.floor(d);
                if (d5 >= 0.5) {
                    d = Math.ceil(d);
                    break;
                }
                d = Math.floor(d);
                break;
            }
            case 7: {
                if (d == Math.floor(d)) break;
                throw new ArithmeticException("Inexact result from rounding");
            }
            case 0: {
                d = Math.ceil(MathUtils.nextAfter(d, Double.POSITIVE_INFINITY));
                break;
            }
            default: {
                throw MathRuntimeException.createIllegalArgumentException("invalid rounding method {0}, valid methods: {1} ({2}), {3} ({4}), {5} ({6}), {7} ({8}), {9} ({10}), {11} ({12}), {13} ({14}), {15} ({16})", n, "ROUND_CEILING", 2, "ROUND_DOWN", 1, "ROUND_FLOOR", 3, "ROUND_HALF_DOWN", 5, "ROUND_HALF_EVEN", 6, "ROUND_HALF_UP", 4, "ROUND_UNNECESSARY", 7, "ROUND_UP", 0);
            }
        }
        return d;
    }

    public static byte sign(byte by) {
        return (byte)(by == 0 ? 0 : (by > 0 ? 1 : -1));
    }

    public static double sign(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return d == 0.0 ? 0.0 : (d > 0.0 ? 1.0 : -1.0);
    }

    public static float sign(float f) {
        if (Float.isNaN(f)) {
            return Float.NaN;
        }
        return f == 0.0f ? 0.0f : (f > 0.0f ? 1.0f : -1.0f);
    }

    public static int sign(int n) {
        return n == 0 ? 0 : (n > 0 ? 1 : -1);
    }

    public static long sign(long l) {
        return l == 0L ? 0L : (l > 0L ? 1L : -1L);
    }

    public static short sign(short s) {
        return (short)(s == 0 ? 0 : (s > 0 ? 1 : -1));
    }

    public static double sinh(double d) {
        return (Math.exp(d) - Math.exp(-d)) / 2.0;
    }

    public static int subAndCheck(int n, int n2) {
        long l = (long)n - (long)n2;
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: subtract");
        }
        return (int)l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long subAndCheck(long l, long l2) {
        String string = "overflow: subtract";
        if (l2 != Long.MIN_VALUE) return MathUtils.addAndCheck(l, -l2, string);
        if (l >= 0L) throw new ArithmeticException(string);
        return l - l2;
    }

    public static int pow(int n, int n2) throws IllegalArgumentException {
        if (n2 < 0) {
            throw MathRuntimeException.createIllegalArgumentException("cannot raise an integral value to a negative power ({0}^{1})", n, n2);
        }
        int n3 = 1;
        int n4 = n;
        while (n2 != 0) {
            if ((n2 & 1) != 0) {
                n3 *= n4;
            }
            n4 *= n4;
            n2 >>= 1;
        }
        return n3;
    }

    public static int pow(int n, long l) throws IllegalArgumentException {
        if (l < 0L) {
            throw MathRuntimeException.createIllegalArgumentException("cannot raise an integral value to a negative power ({0}^{1})", n, l);
        }
        int n2 = 1;
        int n3 = n;
        while (l != 0L) {
            if ((l & 1L) != 0L) {
                n2 *= n3;
            }
            n3 *= n3;
            l >>= 1;
        }
        return n2;
    }

    public static long pow(long l, int n) throws IllegalArgumentException {
        if (n < 0) {
            throw MathRuntimeException.createIllegalArgumentException("cannot raise an integral value to a negative power ({0}^{1})", l, n);
        }
        long l2 = 1L;
        long l3 = l;
        while (n != 0) {
            if ((n & 1) != 0) {
                l2 *= l3;
            }
            l3 *= l3;
            n >>= 1;
        }
        return l2;
    }

    public static long pow(long l, long l2) throws IllegalArgumentException {
        if (l2 < 0L) {
            throw MathRuntimeException.createIllegalArgumentException("cannot raise an integral value to a negative power ({0}^{1})", l, l2);
        }
        long l3 = 1L;
        long l4 = l;
        while (l2 != 0L) {
            if ((l2 & 1L) != 0L) {
                l3 *= l4;
            }
            l4 *= l4;
            l2 >>= 1;
        }
        return l3;
    }

    public static BigInteger pow(BigInteger bigInteger, int n) throws IllegalArgumentException {
        if (n < 0) {
            throw MathRuntimeException.createIllegalArgumentException("cannot raise an integral value to a negative power ({0}^{1})", bigInteger, n);
        }
        return bigInteger.pow(n);
    }

    public static BigInteger pow(BigInteger bigInteger, long l) throws IllegalArgumentException {
        if (l < 0L) {
            throw MathRuntimeException.createIllegalArgumentException("cannot raise an integral value to a negative power ({0}^{1})", bigInteger, l);
        }
        BigInteger bigInteger2 = BigInteger.ONE;
        BigInteger bigInteger3 = bigInteger;
        while (l != 0L) {
            if ((l & 1L) != 0L) {
                bigInteger2 = bigInteger2.multiply(bigInteger3);
            }
            bigInteger3 = bigInteger3.multiply(bigInteger3);
            l >>= 1;
        }
        return bigInteger2;
    }

    public static BigInteger pow(BigInteger bigInteger, BigInteger bigInteger2) throws IllegalArgumentException {
        if (bigInteger2.compareTo(BigInteger.ZERO) < 0) {
            throw MathRuntimeException.createIllegalArgumentException("cannot raise an integral value to a negative power ({0}^{1})", bigInteger, bigInteger2);
        }
        BigInteger bigInteger3 = BigInteger.ONE;
        BigInteger bigInteger4 = bigInteger;
        while (!BigInteger.ZERO.equals(bigInteger2)) {
            if (bigInteger2.testBit(0)) {
                bigInteger3 = bigInteger3.multiply(bigInteger4);
            }
            bigInteger4 = bigInteger4.multiply(bigInteger4);
            bigInteger2 = bigInteger2.shiftRight(1);
        }
        return bigInteger3;
    }

    public static double distance1(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.abs(dArray[i] - dArray2[i]);
        }
        return d;
    }

    public static int distance1(int[] nArray, int[] nArray2) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += Math.abs(nArray[i] - nArray2[i]);
        }
        return n;
    }

    public static double distance(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i] - dArray2[i];
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    public static double distance(int[] nArray, int[] nArray2) {
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            double d2 = nArray[i] - nArray2[i];
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    public static double distanceInf(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d = Math.max(d, Math.abs(dArray[i] - dArray2[i]));
        }
        return d;
    }

    public static int distanceInf(int[] nArray, int[] nArray2) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n = Math.max(n, Math.abs(nArray[i] - nArray2[i]));
        }
        return n;
    }

    public static void checkOrder(double[] dArray, int n, boolean bl) {
        double d = dArray[0];
        int n2 = dArray.length;
        for (int i = 1; i < n2; ++i) {
            if (n > 0) {
                if (bl) {
                    if (dArray[i] <= d) {
                        throw MathRuntimeException.createIllegalArgumentException("points {0} and {1} are not strictly increasing ({2} >= {3})", i - 1, i, d, dArray[i]);
                    }
                } else if (dArray[i] < d) {
                    throw MathRuntimeException.createIllegalArgumentException("points {0} and {1} are not increasing ({2} > {3})", i - 1, i, d, dArray[i]);
                }
            } else if (bl) {
                if (dArray[i] >= d) {
                    throw MathRuntimeException.createIllegalArgumentException("points {0} and {1} are not strictly decreasing ({2} <= {3})", i - 1, i, d, dArray[i]);
                }
            } else if (dArray[i] > d) {
                throw MathRuntimeException.createIllegalArgumentException("points {0} and {1} are not decreasing ({2} < {3})", i - 1, i, d, dArray[i]);
            }
            d = dArray[i];
        }
    }
}

