/*
 * Decompiled with CFR 0.152.
 */
package viz;

import java.io.FileWriter;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import viz.DensiTree;
import viz.Node;
import viz.TreeFileParser;

public class AddSpeed
extends DensiTree {
    private static final long serialVersionUID = 1L;
    static Pattern g_pattern;
    static final String DEFAULT_PATTERN = "([0-9\\.Ee-]+),y=([0-9\\.Ee-]+)";
    static DensiTree g_densitree;

    static {
        g_densitree = new DensiTree();
    }

    public static void addSpeed(Node node) {
        if (node.isRoot()) {
            AddSpeed.addSpeed(node.m_left);
            AddSpeed.addSpeed(node.m_right);
        } else if (node.isLeaf()) {
            if (node.getParent().getMetaData() != null) {
                float fX = AddSpeed.g_densitree.m_fLongitude.get(node.m_iLabel).floatValue();
                float fY = AddSpeed.g_densitree.m_fLatitude.get(node.m_iLabel).floatValue();
                Matcher matcher2 = g_pattern.matcher(node.getParent().getMetaData());
                matcher2.find();
                float fX2 = Float.parseFloat(matcher2.group(1));
                float fY2 = Float.parseFloat(matcher2.group(2));
                node.setMetaData(String.valueOf(node.getMetaData()) + ",s=" + (float)(Math.sqrt((fX - fX2) * (fX - fX2) + (fY - fY2) * (fY - fY2)) / (double)Math.abs(node.m_fLength)));
            }
        } else {
            AddSpeed.addSpeed(node.m_left);
            AddSpeed.addSpeed(node.m_right);
            if (node.getMetaData() != null && node.getParent().getMetaData() != null) {
                Matcher matcher = g_pattern.matcher(node.getMetaData());
                matcher.find();
                float fX = Float.parseFloat(matcher.group(1));
                float fY = Float.parseFloat(matcher.group(2));
                Matcher matcher2 = g_pattern.matcher(node.getParent().getMetaData());
                matcher2.find();
                float fX2 = Float.parseFloat(matcher2.group(1));
                float fY2 = Float.parseFloat(matcher2.group(2));
                node.setMetaData(String.valueOf(node.getMetaData()) + ",s=" + (float)(Math.sqrt((fX - fX2) * (fX - fX2) + (fY - fY2) * (fY - fY2)) / (double)Math.abs(node.m_fLength)));
            }
        }
    }

    public static void main(String[] args) {
        String sFileIn = "puma2.trees";
        String sFileOut = "puma3.trees";
        if (args.length > 0) {
            sFileIn = args[0];
        }
        if (args.length > 1) {
            sFileOut = args[1];
        }
        try {
            Node[] trees;
            AddSpeed.g_densitree.m_sLabels = new Vector();
            AddSpeed.g_densitree.m_fLongitude = new Vector();
            AddSpeed.g_densitree.m_fLatitude = new Vector();
            g_pattern = Pattern.compile(DEFAULT_PATTERN);
            TreeFileParser parser = new TreeFileParser(g_densitree);
            Node[] nodeArray = trees = parser.parseFile(sFileIn);
            int n = trees.length;
            int n2 = 0;
            while (n2 < n) {
                Node tree = nodeArray[n2];
                AddSpeed.addSpeed(tree);
                ++n2;
            }
            FileWriter outfile = new FileWriter(sFileOut);
            StringBuffer buf = new StringBuffer();
            buf.append("#NEXUS\n");
            buf.append("Begin trees\n");
            buf.append("\tTranslate\n");
            int i = 0;
            while (i < AddSpeed.g_densitree.m_sLabels.size()) {
                buf.append("\t\t" + i + " " + AddSpeed.g_densitree.m_sLabels.get(i));
                if (i < AddSpeed.g_densitree.m_sLabels.size() - 1) {
                    buf.append(",");
                }
                buf.append("\n");
                ++i;
            }
            buf.append(";\n");
            outfile.write(buf.toString());
            i = 0;
            while (i < trees.length) {
                outfile.write("tree STATE_" + i + " = " + trees[i].toString() + ";\n");
                ++i;
            }
            outfile.write("End;\n");
            outfile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

