/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.audio.ui;

import blue.score.TimeState;
import blue.score.layers.audio.core.AudioClip;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class FadeHandle
extends JPanel {
    private final AudioClip audioClip;
    private final TimeState timeState;
    boolean adjustingFade = false;
    private final MouseAdapter mouseAdapter = new MouseAdapter(){
        double max = 0.0;
        double startFade;
        int startX;

        @Override
        public void mouseEntered(MouseEvent e) {
            Component pane = SwingUtilities.getRootPane(FadeHandle.this).getGlassPane();
            if (FadeHandle.this.fadeIn) {
                pane.setCursor(Cursor.getPredefinedCursor(11));
            } else {
                pane.setCursor(Cursor.getPredefinedCursor(10));
            }
            pane.setVisible(true);
            e.consume();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!FadeHandle.this.adjustingFade) {
                Component pane = SwingUtilities.getRootPane(FadeHandle.this).getGlassPane();
                pane.setCursor(null);
                pane.setVisible(false);
            }
            e.consume();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            e.consume();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.max = FadeHandle.this.fadeIn ? FadeHandle.this.audioClip.getDuration() - FadeHandle.this.audioClip.getFadeOut() : FadeHandle.this.audioClip.getDuration() - FadeHandle.this.audioClip.getFadeIn();
            this.startFade = FadeHandle.this.fadeIn ? FadeHandle.this.audioClip.getFadeIn() : FadeHandle.this.audioClip.getFadeOut();
            this.startX = e.getXOnScreen();
            FadeHandle.this.adjustingFade = true;
            e.consume();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (FadeHandle.this.adjustingFade && !FadeHandle.this.contains(e.getPoint())) {
                Component pane = SwingUtilities.getRootPane(FadeHandle.this).getGlassPane();
                pane.setCursor(null);
                pane.setVisible(false);
            }
            FadeHandle.this.adjustingFade = false;
            e.consume();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (FadeHandle.this.adjustingFade) {
                double timeAdj = (double)(e.getXOnScreen() - this.startX) / (double)FadeHandle.this.timeState.getPixelSecond();
                double newFade = FadeHandle.this.fadeIn ? this.startFade + timeAdj : this.startFade - timeAdj;
                newFade = Math.max(0.0, newFade);
                newFade = Math.min(this.max, newFade);
                if (FadeHandle.this.fadeIn) {
                    FadeHandle.this.audioClip.setFadeIn(newFade);
                } else {
                    FadeHandle.this.audioClip.setFadeOut(newFade);
                }
                e.consume();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            e.consume();
        }
    };
    private final boolean fadeIn;

    public FadeHandle(AudioClip audioClip, TimeState timeState, boolean fadeIn) {
        this.fadeIn = fadeIn;
        this.audioClip = audioClip;
        this.timeState = timeState;
        this.setSize(5, 5);
        this.addMouseListener(this.mouseAdapter);
        this.addMouseMotionListener(this.mouseAdapter);
        if (fadeIn) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(10));
        }
    }

    public boolean isAdjustingFade() {
        return this.adjustingFade;
    }
}

