/*
 * Decompiled with CFR 0.152.
 */
package blue.projects.actions;

import blue.BlueData;
import blue.BlueSystem;
import blue.projects.AudioFileDependencyDialog;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.projects.recentProjects.RecentProjectsList;
import blue.score.Score;
import blue.score.layers.LayerGroup;
import blue.settings.GeneralSettings;
import blue.soundObject.AudioFile;
import blue.soundObject.PolyObject;
import blue.soundObject.SoundObject;
import blue.ui.utilities.FileChooserManager;
import blue.utility.TextUtilities;
import electric.xml.Document;
import electric.xml.Element;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javafx.stage.FileChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;

public final class OpenProjectAction
implements ActionListener {
    private static final Logger logger = Logger.getLogger("OpenProjectAction");
    private static AudioFileDependencyDialog dependencyDialog = null;

    public OpenProjectAction() {
        FileChooserManager fcm = FileChooserManager.getDefault();
        fcm.setMultiSelectionEnabled(this.getClass(), true);
        fcm.addFilter(this.getClass(), new FileChooser.ExtensionFilter("blue Project File (*.blue)", new String[]{"*.blue"}));
        fcm.setSelectedFile(this.getClass(), new File(GeneralSettings.getInstance().getDefaultDirectory() + File.separator + "default.blue"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileChooserManager fcm = FileChooserManager.getDefault();
        List rValue = fcm.showOpenDialog(this.getClass(), (Component)WindowManager.getDefault().getMainWindow());
        if (rValue.size() > 0) {
            BlueProjectManager projectManager = BlueProjectManager.getInstance();
            for (File temp : rValue) {
                BlueProject project;
                if (temp.getName().trim().endsWith(".patterns")) continue;
                if (!temp.getName().trim().endsWith(".blue")) {
                    temp = new File(temp.getAbsolutePath() + ".blue");
                }
                if ((project = projectManager.findProjectFromFile(temp)) != null) {
                    projectManager.setCurrentProject(project);
                    continue;
                }
                OpenProjectAction.open(temp);
            }
        } else {
            StatusDisplayer.getDefault().setStatusText("No files selected.");
        }
    }

    public static void open(File selected) {
        File absoluteSelected;
        File temp = absoluteSelected = selected.getAbsoluteFile();
        File backup = new File(absoluteSelected.getAbsolutePath() + "~");
        boolean wasTempFile = false;
        if (backup.exists() && backup.lastModified() > temp.lastModified()) {
            String message = "A backup work file was found. This should only occur if blue did not close successfully.\n\nWould you like to open the backup file?\n\nIf you open the backup file, it will be required to \"Save as\" the file to overwrite your old work.)";
            NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)message, 1);
            Object retVal = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            if (retVal == NotifyDescriptor.YES_OPTION) {
                temp = backup;
                wasTempFile = true;
            } else if (retVal == NotifyDescriptor.CANCEL_OPTION) {
                return;
            }
        }
        try {
            BlueProject project;
            String text = TextUtilities.getTextFromFile((File)temp);
            if (!text.startsWith("<blueData")) {
                return;
            }
            Document d = new Document(text);
            BlueData tempData = BlueData.loadFromXML((Element)d.getElement("blueData"));
            if (wasTempFile) {
                project = new BlueProject(tempData, null);
                project.setTempFile(temp);
                project.setOpenedFromTempFile(true);
            } else {
                project = new BlueProject(tempData, temp);
            }
            BlueProjectManager projectManager = BlueProjectManager.getInstance();
            projectManager.setCurrentProject(project);
            if (!temp.getAbsolutePath().endsWith("~")) {
                RecentProjectsList.getInstance().addFile(temp.getAbsolutePath());
            }
            temp = null;
            OpenProjectAction.checkDependencies(tempData);
        }
        catch (FileNotFoundException fe) {
            String message = "Error: Could not open " + temp.toString();
            StatusDisplayer.getDefault().setStatusText(message);
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)message, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            StatusDisplayer.getDefault().setStatusText("Error: Could not open " + temp.toString());
        }
    }

    private static void checkDependencies(BlueData tempData) {
        Score score = tempData.getScore();
        ArrayList<String> filesList = new ArrayList<String>();
        for (LayerGroup layerGroup : score) {
            if (!(layerGroup instanceof PolyObject)) continue;
            PolyObject pObj = (PolyObject)layerGroup;
            OpenProjectAction.checkAudioFiles(pObj, filesList);
        }
        if (filesList.size() > 0) {
            if (dependencyDialog == null) {
                dependencyDialog = new AudioFileDependencyDialog();
            }
            dependencyDialog.setFilesList(filesList);
            if (dependencyDialog.ask()) {
                Map<String, String> map = dependencyDialog.getFilesMap();
                if (map == null || map.size() == 0) {
                    return;
                }
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String key = entry.getKey();
                    String val = entry.getValue();
                    val = BlueSystem.getRelativePath((String)val);
                    entry.setValue(val);
                }
                System.out.println(map);
                for (LayerGroup layerGroup : score) {
                    if (!(layerGroup instanceof PolyObject)) continue;
                    PolyObject pObj = (PolyObject)layerGroup;
                    OpenProjectAction.reconcileAudioFiles(pObj, map);
                }
            }
        }
    }

    private static void checkAudioFiles(PolyObject pObj, ArrayList<String> filesList) {
        for (SoundObject sObj : pObj.getSoundObjects(true)) {
            if (sObj instanceof AudioFile) {
                AudioFile af = (AudioFile)sObj;
                String soundFileName = af.getSoundFileName();
                if (soundFileName == null || BlueSystem.findFile((String)soundFileName) != null || filesList.contains(soundFileName)) continue;
                filesList.add(soundFileName);
                continue;
            }
            if (!(sObj instanceof PolyObject)) continue;
            OpenProjectAction.checkAudioFiles((PolyObject)sObj, filesList);
        }
    }

    private static void reconcileAudioFiles(PolyObject pObj, Map<String, String> map) {
        for (SoundObject sObj : pObj.getSoundObjects(true)) {
            if (sObj instanceof AudioFile) {
                AudioFile af = (AudioFile)sObj;
                String soundFileName = af.getSoundFileName();
                if (!map.containsKey(soundFileName)) continue;
                af.setSoundFileName(map.get(soundFileName));
                continue;
            }
            if (!(sObj instanceof PolyObject)) continue;
            OpenProjectAction.reconcileAudioFiles((PolyObject)sObj, map);
        }
    }
}

