/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.blueShare.effects;

import blue.BlueSystem;
import blue.mixer.Effect;
import blue.tools.blueShare.BlueShareRemoteCaller;
import blue.tools.blueShare.NamePasswordPanel;
import blue.tools.blueShare.effects.BlueShareEffectCategory;
import blue.ui.core.mixer.EffectsLibrary;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.xmlrpc.XmlRpcException;

public class EffectExportPane
extends JComponent {
    private static final String SELECT_EFFECT_TEXT = "Select an Effect to export";
    NamePasswordPanel namePasswordPanel = new NamePasswordPanel();
    JPanel jPanel2 = new JPanel();
    JSplitPane topSplitPane = new JSplitPane();
    JScrollPane descriptionScrollPane = new JScrollPane();
    JTextArea descriptionText = new JTextArea();
    JButton submitButton = new JButton();
    JPanel instrumentListPanel = new JPanel();
    JTree effectLibraryTree = new JTree();
    JScrollPane instrumentListScrollPane = new JScrollPane();
    JLabel iLabel = new JLabel();
    JSplitPane mainSplitPane = new JSplitPane();
    JPanel categoryPanel = new JPanel();
    JLabel cateogriesLabel = new JLabel();
    JScrollPane categoryScrollPane = new JScrollPane();
    JTree categoryTree = new JTree();

    public EffectExportPane() {
        this.effectLibraryTree.setModel(EffectsLibrary.getInstance());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.descriptionText.setText(SELECT_EFFECT_TEXT);
        this.descriptionText.setEnabled(false);
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.instrumentListPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.categoryPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.cateogriesLabel.setText(BlueSystem.getString((String)"common.categories"));
        this.categoryPanel.setLayout(new BorderLayout());
        this.add((Component)this.namePasswordPanel, "North");
        this.add((Component)this.mainSplitPane, "Center");
        this.add((Component)this.jPanel2, "South");
        this.descriptionText.setText(BlueSystem.getString((String)"blueShare.effect.enterDescription"));
        this.descriptionText.setLineWrap(true);
        this.descriptionScrollPane.setBorder(new TitledBorder(null, BlueSystem.getString((String)"blueShare.effect.effectDescription")));
        this.submitButton.setText(BlueSystem.getString((String)"common.submit"));
        this.instrumentListPanel.setLayout(new BorderLayout());
        this.iLabel.setText(BlueSystem.getString((String)"blueShare.effect.effectsFromEffectsLibrary"));
        this.topSplitPane.add((Component)this.instrumentListPanel, "left");
        this.instrumentListPanel.add((Component)this.instrumentListScrollPane, "Center");
        this.instrumentListPanel.add((Component)this.iLabel, "North");
        this.instrumentListScrollPane.getViewport().add((Component)this.effectLibraryTree, null);
        this.descriptionScrollPane.getViewport().add((Component)this.descriptionText, null);
        this.jPanel2.add((Component)this.submitButton, null);
        this.topSplitPane.setDividerLocation(300);
        this.mainSplitPane.setOrientation(0);
        this.mainSplitPane.add((Component)this.topSplitPane, "top");
        this.mainSplitPane.add((Component)this.descriptionScrollPane, "bottom");
        this.topSplitPane.add((Component)this.categoryPanel, "right");
        this.categoryPanel.add((Component)this.cateogriesLabel, "North");
        this.categoryPanel.add((Component)this.categoryScrollPane, "Center");
        this.categoryScrollPane.getViewport().add((Component)this.categoryTree, null);
        this.mainSplitPane.setDividerLocation(200);
        this.submitButton.addActionListener(e -> this.submitEffect());
        this.effectLibraryTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path = EffectExportPane.this.effectLibraryTree.getSelectionPath();
                if (path == null) {
                    EffectExportPane.this.descriptionText.setText(EffectExportPane.SELECT_EFFECT_TEXT);
                    EffectExportPane.this.descriptionText.setEnabled(false);
                    return;
                }
                Object userObj = path.getLastPathComponent();
                if (!(userObj instanceof Effect)) {
                    EffectExportPane.this.descriptionText.setText(EffectExportPane.SELECT_EFFECT_TEXT);
                    EffectExportPane.this.descriptionText.setEnabled(false);
                    return;
                }
                Effect effect = (Effect)userObj;
                EffectExportPane.this.descriptionText.setText(effect.getComments());
                EffectExportPane.this.descriptionText.setEnabled(true);
            }
        });
    }

    public void setCategories(BlueShareEffectCategory[] categories) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(BlueSystem.getString((String)"common.categories"));
        this.addSubCategories(root, categories);
        this.categoryTree.setModel(new DefaultTreeModel(root));
    }

    private void addSubCategories(DefaultMutableTreeNode parent, BlueShareEffectCategory[] categories) {
        for (int i = 0; i < categories.length; ++i) {
            DefaultMutableTreeNode temp = new DefaultMutableTreeNode(categories[i]);
            parent.add(temp);
            this.addSubCategories(temp, categories[i].getSubCategories());
        }
    }

    private void submitEffect() {
        try {
            TreePath path = this.effectLibraryTree.getSelectionPath();
            if (path == null) {
                return;
            }
            Object userObj = path.getLastPathComponent();
            if (!(userObj instanceof Effect)) {
                return;
            }
            Effect effect = (Effect)userObj;
            DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode)this.categoryTree.getSelectionPath().getLastPathComponent();
            BlueShareEffectCategory category = (BlueShareEffectCategory)tempNode.getUserObject();
            String username = this.namePasswordPanel.getUsername();
            String password = this.namePasswordPanel.getPassword();
            int categoryId = category.getCategoryId();
            String name = effect.getName();
            String description = this.descriptionText.getText();
            String effectText = effect.saveAsXML().toString();
            System.out.println(effect.saveAsXML().getTextString());
            BlueShareRemoteCaller.submitEffect(username, password, categoryId, name, description, effectText);
        }
        catch (IOException | XmlRpcException e) {
            JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"blueShare.effect.errorSubmittingEffect") + "\n\n" + e.getLocalizedMessage(), BlueSystem.getString((String)"common.error"), 0);
            e.printStackTrace();
            return;
        }
        JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"blueShare.effect.successfullyReceived"), BlueSystem.getString((String)"common.success"), -1);
    }

    public static void main(String[] args) {
        EffectExportPane instrumentExportPane1 = new EffectExportPane();
        GUI.showComponentAsStandalone((Component)instrumentExportPane1, (String)"Instrument Export Pane Test", (boolean)true);
    }
}

