/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score;

import blue.score.layers.Layer;
import blue.ui.core.score.MultiLineScoreSelectionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class MultiLineScoreSelection {
    double startTime = -1.0;
    double endTime = -1.0;
    Collection<Layer> selectedLayers = new HashSet<Layer>();
    double translationTime = 0.0;
    private List<MultiLineScoreSelectionListener> listeners = new ArrayList<MultiLineScoreSelectionListener>();
    private static MultiLineScoreSelection INSTANCE = null;

    public static synchronized MultiLineScoreSelection getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MultiLineScoreSelection();
        }
        return INSTANCE;
    }

    public void startSelection(double startTime, double endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public void updateSelection(double startTime, double endTime, Collection<Layer> selectedLayers) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.selectedLayers = selectedLayers;
        this.fireUpdate(UpdateType.SELECTION);
    }

    public void startTranslation() {
        this.translationTime = 0.0;
        this.fireUpdate(UpdateType.TRANSLATION_START);
    }

    public void updateTranslation(double translationTime) {
        this.translationTime = translationTime;
        this.fireUpdate(UpdateType.TRANSLATION);
    }

    public void endTranslation() {
        this.startTime += this.translationTime;
        this.endTime += this.translationTime;
        this.translationTime = 0.0;
        this.fireUpdate(UpdateType.TRANSLATION_COMPLETE);
    }

    public void reset() {
        this.startTime = -1.0;
        this.endTime = -1.0;
        this.translationTime = 0.0;
        this.selectedLayers = null;
        this.fireUpdate(UpdateType.CLEAR);
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public Collection<Layer> getSelectedLayers() {
        return this.selectedLayers;
    }

    public double getTranslationTime() {
        return this.translationTime;
    }

    public void addListener(MultiLineScoreSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MultiLineScoreSelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void fireUpdate(UpdateType updateType) {
        for (MultiLineScoreSelectionListener listener : this.listeners) {
            listener.multiLineSelectionUpdated(updateType);
        }
    }

    public static enum UpdateType {
        SELECTION,
        TRANSLATION_START,
        TRANSLATION,
        TRANSLATION_COMPLETE,
        CLEAR;

    }
}

