/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.object.actions;

import blue.BlueSystem;
import blue.score.ScoreObject;
import blue.soundObject.SoundObject;
import blue.ui.core.score.undo.ResizeScoreObjectEdit;
import blue.undo.BlueUndoManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class SetSubjectiveToObjectiveTimeAction
extends AbstractAction
implements ContextAwareAction {
    private final Collection<? extends ScoreObject> scoreObjects;
    private final Collection<? extends SoundObject> soundObjects;

    public SetSubjectiveToObjectiveTimeAction() {
        this(Utilities.actionsGlobalContext());
    }

    public SetSubjectiveToObjectiveTimeAction(Lookup lookup) {
        super(NbBundle.getMessage(SetSubjectiveToObjectiveTimeAction.class, (String)"CTL_SetSubjectiveToObjectiveTime"));
        this.scoreObjects = lookup.lookupAll(ScoreObject.class);
        this.soundObjects = lookup.lookupAll(SoundObject.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.soundObjects.size() > 0 && this.scoreObjects.size() == this.soundObjects.size()) {
            ResizeScoreObjectEdit top = null;
            for (SoundObject soundObject : this.soundObjects) {
                double newTime;
                if (soundObject.getObjectiveDuration() <= 0.0) {
                    JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"soundObjectPopup.setTime.error.text"), BlueSystem.getString((String)"soundObjectPopup.setTime.error.title"), 0);
                    return;
                }
                double oldTime = soundObject.getSubjectiveDuration();
                if (oldTime == (newTime = soundObject.getObjectiveDuration())) continue;
                soundObject.setSubjectiveDuration(newTime);
                ResizeScoreObjectEdit edit = new ResizeScoreObjectEdit((ScoreObject)soundObject, oldTime, newTime);
                if (top == null) {
                    top = edit;
                    continue;
                }
                top.addEdit(edit);
            }
            if (top != null) {
                BlueUndoManager.setUndoManager((String)"score");
                BlueUndoManager.addEdit(top);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.scoreObjects.size() == this.soundObjects.size() && this.soundObjects.size() > 0;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new SetSubjectiveToObjectiveTimeAction(actionContext);
    }
}

