/*
 * Decompiled with CFR 0.152.
 */
package electric.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;

public final class Strings {
    public static String getString(String string, String[] stringArray, int n) {
        if (n >= stringArray.length) {
            throw new IllegalArgumentException("missing argument to -".concat(String.valueOf(String.valueOf(string))));
        }
        return stringArray[n];
    }

    public static String asJavaName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ((i != 0 || !Character.isJavaIdentifierStart(c)) && !Character.isJavaIdentifierPart(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String getJavaPackage(String string) {
        int n = string.lastIndexOf(46);
        return n != -1 ? string.substring(0, n) : null;
    }

    public static String getLocalJavaName(String string) {
        return Strings.tail(string, '.');
    }

    public static boolean isUTF16(byte[] byArray) {
        if (byArray.length < 2) {
            return false;
        }
        return byArray[0] == -1 && byArray[1] == -2 || byArray[0] == -2 && byArray[1] == -1;
    }

    public static boolean isUTF8(String string) {
        return string == null || string.equalsIgnoreCase("UTF-8") || string.equalsIgnoreCase("UTF8");
    }

    public static String normalizeEncoding(String string) {
        return string == null || string.equalsIgnoreCase("UTF-8") ? "UTF8" : string;
    }

    public static String toString(byte[] byArray) throws UnsupportedEncodingException {
        return Strings.isUTF16(byArray) ? new String(byArray, "UTF-16") : new String(byArray, "UTF8");
    }

    public static String extension(String string) {
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(46);
        return n2 > n ? string.substring(n2 + 1) : null;
    }

    public static String tail(String string, char c) {
        int n = string.lastIndexOf(c);
        return n == -1 ? string : string.substring(n + 1);
    }

    public static String head(String string, char c) {
        int n = string.lastIndexOf(c);
        return n == -1 ? string : string.substring(0, n);
    }

    public static String splice(String string, String string2) {
        if (string2.length() == 0) {
            return string;
        }
        if (string.endsWith("/") && string2.startsWith("/")) {
            return String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(string2.substring(1))));
        }
        if (string.endsWith("/") || string2.startsWith("/")) {
            return String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(string2)));
        }
        if (string.length() > 0) {
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append("/").append(string2)));
        }
        return string2;
    }

    public static String replace(String string, String string2, String string3) {
        if (string.indexOf(string2.charAt(0)) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(string2, n)) == -1) {
                stringBuffer.append(string.substring(n, string.length()));
                return stringBuffer.toString();
            }
            stringBuffer.append(string.substring(n, n2)).append(string3);
            n = n2 + string2.length();
        }
    }

    public static String arrayToString(Object object) {
        int n = Array.getLength(object);
        if (n == 0) {
            return "()";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("( ");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(Array.get(object, i));
        }
        return stringBuffer.append(" )").toString();
    }

    public static String getURN(String string) {
        int n = string.lastIndexOf("/");
        return n == -1 ? string : string.substring(n + 1);
    }

    public static String getEndpoint(String string) {
        int n = string.lastIndexOf("/");
        return n == -1 ? "" : string.substring(0, n);
    }

    public static String toFilename(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append('_');
            stringBuffer.append(Integer.toString(c));
            stringBuffer.append('_');
        }
        return stringBuffer.toString();
    }

    public static String fromFilename(String string) {
        int n = string.indexOf(95);
        if (n == -1) {
            return string;
        }
        int n2 = string.indexOf(95, n + 1);
        char c = (char)Integer.parseInt(string.substring(n + 1, n2));
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string.substring(0, n)))).append(c).append(Strings.fromFilename(string.substring(n2 + 1)))));
    }

    public static void substitute(String[][] stringArray, String[][] stringArray2) throws IOException {
        block0: for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i][1];
            if (string.length() <= 0 || string.charAt(0) != '$') continue;
            String string2 = string.substring(1, string.length());
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray2[j][0].equals(string2)) continue;
                stringArray[i][1] = stringArray2[j][1];
                continue block0;
            }
        }
    }

    public static String getCapitalized(String string) {
        return String.valueOf(String.valueOf(Character.toUpperCase(string.charAt(0)))).concat(String.valueOf(String.valueOf(string.substring(1))));
    }
}

