/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.Node;
import electric.util.Strings;
import electric.util.io.Streams;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Parent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public abstract class Child
extends Node
implements Cloneable {
    Parent parent;

    Child() {
    }

    Child(Parent parent) {
        parent.addChild(this);
    }

    public String toString() {
        return this.toString(0);
    }

    public abstract Object clone();

    void setParent(Parent parent) {
        this.parent = parent;
    }

    public Parent getParent() {
        return this.parent;
    }

    public void replaceWith(Child child) {
        this.parent.replaceChild(this, child);
    }

    public Child getNextSibling() {
        return (Child)this.getNextSiblingNode();
    }

    public Child setNextSibling(Child child) {
        child.setParent(this.parent);
        this.setNextSiblingNode(child);
        return this;
    }

    public Child getPreviousSibling() {
        return (Child)this.getPreviousSiblingNode();
    }

    public Child setPreviousSibling(Child child) {
        child.setParent(this.parent);
        this.setPreviousSiblingNode(child);
        return this;
    }

    public Document getDocument() {
        return this.parent == null ? null : this.parent.getDocument();
    }

    public Element getRoot() {
        return this.parent == null ? null : this.parent.getRoot();
    }

    public abstract void write(Writer var1, int var2) throws IOException;

    public String toString(int n) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.write(stringWriter, n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public void write(Writer writer) throws IOException {
        this.write(writer, 0);
    }

    void indent(Writer writer, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            writer.write(32);
        }
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        String string = Strings.normalizeEncoding(this.getDocument().getEncoding());
        return this.toString(-1).getBytes(string);
    }

    public void write(File file) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(Streams.getWriter(file, this.getDocument().getEncoding()));
        try {
            this.write(bufferedWriter, 0);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((Writer)bufferedWriter).close();
            throw throwable;
        }
        ((Writer)bufferedWriter).close();
    }

    public void write(OutputStream outputStream) throws IOException {
        Writer writer = Streams.getWriter(outputStream, this.getDocument().getEncoding());
        this.write(writer, 0);
        writer.flush();
    }
}

