/*
 * Decompiled with CFR 0.152.
 */
package blue.scripting;

import blue.BlueSystem;
import blue.ExceptionHandler;
import blue.scripting.PythonProxyListener;
import blue.soundObject.NoteList;
import blue.utility.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.python.core.Py;
import org.python.core.PyFloat;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.util.InteractiveInterpreter;
import org.python.util.PythonInterpreter;

public class PythonProxy {
    private static InteractiveInterpreter interp;
    private static PythonInterpreter expressionInterpreter;
    private static PySystemState state;
    private static File libDir;
    private static ArrayList<PythonProxyListener> listeners;

    public static void setLibDir(File newLibDir) {
        libDir = newLibDir;
    }

    public static final void reinitialize() {
        if (Py.getSystemState() != state) {
            for (String pathEntry : PythonProxy.getPythonLibPath().split(File.pathSeparator)) {
                PythonProxy.state.path.append((PyObject)Py.newString((String)pathEntry));
            }
            Py.setSystemState((PySystemState)state);
        }
        interp = new InteractiveInterpreter();
        interp.exec("import site");
        expressionInterpreter = new PythonInterpreter();
        expressionInterpreter.exec("from __future__ import division\n");
        System.out.println(BlueSystem.getString("scripting.python.reinitialized"));
        for (PythonProxyListener listener : listeners) {
            listener.pythonProxyReinitializePerformed();
        }
    }

    public static final void addPythonProxyListener(PythonProxyListener listener) {
        listeners.add(listener);
    }

    public static final void removePythonProxyListener(PythonProxyListener listener) {
        listeners.remove(listener);
    }

    public static final String processPythonScore(String pythonCode, double subjectiveDuration) {
        File currentDirFile;
        if (interp == null) {
            PythonProxy.reinitialize();
        }
        String currentDir = (currentDirFile = BlueSystem.getCurrentProjectDirectory()) == null ? "" : currentDirFile.getAbsolutePath() + File.separator;
        interp.set("score", (PyObject)new PyString());
        interp.set("blueDuration", (PyObject)new PyFloat(subjectiveDuration));
        interp.set("blueProjectDir", (PyObject)new PyString(currentDir));
        interp.exec(pythonCode);
        PyObject tempScore = interp.get("score");
        return tempScore.toString();
    }

    public static final String processPythonInstrument(String pythonCode) {
        if (interp == null) {
            PythonProxy.reinitialize();
        }
        interp.set("instrument", (PyObject)new PyString());
        interp.exec(pythonCode);
        PyObject tempInstr = interp.get("instrument");
        return tempInstr.toString();
    }

    public static void processPythonNoteProcessor(NoteList nl, String pythonCode) {
        if (interp == null) {
            PythonProxy.reinitialize();
        }
        interp.set("noteList", (Object)nl);
        interp.exec(pythonCode);
    }

    public static void processScript(String pythonCode) {
        File currentDirFile;
        if (interp == null) {
            PythonProxy.reinitialize();
        }
        String currentDir = (currentDirFile = BlueSystem.getCurrentProjectDirectory()) == null ? "" : currentDirFile.getAbsolutePath() + File.separator;
        interp.set("blueData", (Object)BlueSystem.getCurrentBlueData());
        interp.set("blueProjectDir", (PyObject)new PyString(currentDir));
        interp.exec(pythonCode);
    }

    public static final double evalExpression(String expression) {
        if (interp == null) {
            PythonProxy.reinitialize();
        }
        expressionInterpreter.exec("temp = " + expression);
        PyObject retVal = expressionInterpreter.get("temp");
        if (retVal.isNumberType()) {
            return Double.parseDouble(retVal.toString());
        }
        return Double.MIN_VALUE;
    }

    private static final String getPythonLibPath() {
        String pythonPath;
        String sep = File.separator;
        File pythonLib = libDir;
        String programPythonPath = null;
        try {
            programPythonPath = pythonLib.getCanonicalPath();
        }
        catch (IOException ex) {
            ExceptionHandler.printStackTrace(ex);
        }
        String userPythonPath = BlueSystem.getUserConfigurationDirectory() + sep + "pythonLib";
        FileUtilities.ensureDirectoryExists(userPythonPath);
        if (programPythonPath != null) {
            String path1 = programPythonPath + File.separator + "standard";
            String path2 = programPythonPath + File.separator + "blue";
            pythonPath = path1 + File.pathSeparator + path2 + File.pathSeparator + userPythonPath;
        } else {
            pythonPath = userPythonPath;
        }
        System.out.println(BlueSystem.getString("scripting.python.libdir") + " " + pythonPath);
        return pythonPath;
    }

    public static InteractiveInterpreter getInterpreter() {
        if (interp == null) {
            PythonProxy.reinitialize();
        }
        return interp;
    }

    static {
        state = new PySystemState();
        libDir = null;
        listeners = new ArrayList();
    }
}

