/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.easymock.IArgumentMatcher;
import org.easymock.internal.Invocation;
import org.easymock.internal.matchers.Equals;

public class ExpectedInvocation
implements Serializable {
    private static final long serialVersionUID = -5554816464613350531L;
    private final Invocation invocation;
    private final List<IArgumentMatcher> matchers;

    public ExpectedInvocation(Invocation invocation, List<IArgumentMatcher> list) {
        this.invocation = invocation;
        this.matchers = this.createMissingMatchers(invocation, list);
    }

    private List<IArgumentMatcher> createMissingMatchers(Invocation invocation, List<IArgumentMatcher> list) {
        if (list != null) {
            if (list.size() != invocation.getArguments().length) {
                throw new IllegalStateException("" + invocation.getArguments().length + " matchers expected, " + list.size() + " recorded.\n" + "This exception usually occurs when matchers are mixed with raw values when recording a method:\n" + "\tfoo(5, eq(6));\t// wrong\n" + "You need to use no matcher at all or a matcher for every single param:\n" + "\tfoo(eq(5), eq(6));\t// right\n" + "\tfoo(5, 6);\t// also right");
            }
            return list;
        }
        ArrayList<IArgumentMatcher> arrayList = new ArrayList<IArgumentMatcher>(invocation.getArguments().length);
        for (Object object : invocation.getArguments()) {
            arrayList.add(new Equals(object));
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ExpectedInvocation expectedInvocation = (ExpectedInvocation)object;
        return this.invocation.equals(expectedInvocation.invocation) && (this.matchers == null && expectedInvocation.matchers == null || this.matchers != null && this.matchers.equals(expectedInvocation.matchers));
    }

    public int hashCode() {
        throw new UnsupportedOperationException("hashCode() is not implemented");
    }

    public boolean matches(Invocation invocation) {
        return this.invocation.getMock().equals(invocation.getMock()) && this.invocation.getMethod().equals(invocation.getMethod()) && this.matches(invocation.getArguments());
    }

    private boolean matches(Object[] objectArray) {
        if (objectArray.length != this.matchers.size()) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.matchers.get(i).matches(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.invocation.getMockAndMethodName());
        stringBuffer.append("(");
        Iterator<IArgumentMatcher> iterator = this.matchers.iterator();
        while (iterator.hasNext()) {
            iterator.next().appendTo(stringBuffer);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public Method getMethod() {
        return this.invocation.getMethod();
    }
}

