/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.cff.CFFCIDFont;
import org.apache.fontbox.cff.CFFCharset;
import org.apache.fontbox.cff.CFFDataInput;
import org.apache.fontbox.cff.CFFEncoding;
import org.apache.fontbox.cff.CFFExpertCharset;
import org.apache.fontbox.cff.CFFExpertEncoding;
import org.apache.fontbox.cff.CFFExpertSubsetCharset;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFISOAdobeCharset;
import org.apache.fontbox.cff.CFFOperator;
import org.apache.fontbox.cff.CFFStandardEncoding;
import org.apache.fontbox.cff.CFFStandardString;
import org.apache.fontbox.cff.CFFType1Font;
import org.apache.fontbox.cff.FDSelect;
import org.apache.fontbox.util.Charsets;

public class CFFParser {
    private static final String TAG_OTTO = "OTTO";
    private static final String TAG_TTCF = "ttcf";
    private static final String TAG_TTFONLY = "\u0000\u0001\u0000\u0000";
    private String[] stringIndex = null;
    private ByteSource source;
    private String debugFontName;

    public List<CFFFont> parse(byte[] byArray, ByteSource byteSource) throws IOException {
        this.source = byteSource;
        return this.parse(byArray);
    }

    public List<CFFFont> parse(byte[] byArray) throws IOException {
        Object object;
        int n;
        CFFDataInput cFFDataInput = new CFFDataInput(byArray);
        String string = CFFParser.readTagName(cFFDataInput);
        if (TAG_OTTO.equals(string)) {
            int n2 = cFFDataInput.readShort();
            short s = cFFDataInput.readShort();
            short s2 = cFFDataInput.readShort();
            short s3 = cFFDataInput.readShort();
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                object = CFFParser.readTagName(cFFDataInput);
                long l = CFFParser.readLong(cFFDataInput);
                long l2 = CFFParser.readLong(cFFDataInput);
                long l3 = CFFParser.readLong(cFFDataInput);
                if (!((String)object).equals("CFF ")) continue;
                bl = true;
                byte[] byArray2 = new byte[(int)l3];
                System.arraycopy(byArray, (int)l2, byArray2, 0, byArray2.length);
                cFFDataInput = new CFFDataInput(byArray2);
                break;
            }
            if (!bl) {
                throw new IOException("CFF tag not found in this OpenType font.");
            }
        } else {
            if (TAG_TTCF.equals(string)) {
                throw new IOException("True Type Collection fonts are not supported.");
            }
            if (TAG_TTFONLY.equals(string)) {
                throw new IOException("OpenType fonts containing a true type font are not supported.");
            }
            cFFDataInput.setPosition(0);
        }
        Header header = CFFParser.readHeader(cFFDataInput);
        String[] stringArray = CFFParser.readStringIndexData(cFFDataInput);
        byte[][] byArray3 = CFFParser.readIndexData(cFFDataInput);
        this.stringIndex = CFFParser.readStringIndexData(cFFDataInput);
        byte[][] byArray4 = CFFParser.readIndexData(cFFDataInput);
        ArrayList<CFFFont> arrayList = new ArrayList<CFFFont>();
        for (n = 0; n < stringArray.length; ++n) {
            object = this.parseFont(cFFDataInput, stringArray[n], byArray3[n]);
            ((CFFFont)object).setGlobalSubrIndex(byArray4);
            ((CFFFont)object).setData(this.source);
            arrayList.add((CFFFont)object);
        }
        return arrayList;
    }

    private static String readTagName(CFFDataInput cFFDataInput) throws IOException {
        byte[] byArray = cFFDataInput.readBytes(4);
        return new String(byArray, Charsets.ISO_8859_1);
    }

    private static long readLong(CFFDataInput cFFDataInput) throws IOException {
        return cFFDataInput.readCard16() << 16 | cFFDataInput.readCard16();
    }

    private static Header readHeader(CFFDataInput cFFDataInput) throws IOException {
        Header header = new Header();
        header.major = cFFDataInput.readCard8();
        header.minor = cFFDataInput.readCard8();
        header.hdrSize = cFFDataInput.readCard8();
        header.offSize = cFFDataInput.readOffSize();
        return header;
    }

    private static int[] readIndexDataOffsets(CFFDataInput cFFDataInput) throws IOException {
        int n = cFFDataInput.readCard16();
        if (n == 0) {
            return null;
        }
        int n2 = cFFDataInput.readOffSize();
        int[] nArray = new int[n + 1];
        for (int i = 0; i <= n; ++i) {
            int n3 = cFFDataInput.readOffset(n2);
            if (n3 > cFFDataInput.length()) {
                throw new IOException("illegal offset value " + n3 + " in CFF font");
            }
            nArray[i] = n3;
        }
        return nArray;
    }

    private static byte[][] readIndexData(CFFDataInput cFFDataInput) throws IOException {
        int[] nArray = CFFParser.readIndexDataOffsets(cFFDataInput);
        if (nArray == null) {
            return null;
        }
        int n = nArray.length - 1;
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i + 1] - nArray[i];
            byArrayArray[i] = cFFDataInput.readBytes(n2);
        }
        return byArrayArray;
    }

    private static String[] readStringIndexData(CFFDataInput cFFDataInput) throws IOException {
        int[] nArray = CFFParser.readIndexDataOffsets(cFFDataInput);
        if (nArray == null) {
            return null;
        }
        int n = nArray.length - 1;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i + 1] - nArray[i];
            if (n2 < 0) {
                throw new IOException("Negative index data length + " + n2 + " at " + i + ": offsets[" + (i + 1) + "]=" + nArray[i + 1] + ", offsets[" + i + "]=" + nArray[i]);
            }
            stringArray[i] = new String(cFFDataInput.readBytes(n2), Charsets.ISO_8859_1);
        }
        return stringArray;
    }

    private static DictData readDictData(CFFDataInput cFFDataInput) throws IOException {
        DictData dictData = new DictData();
        while (cFFDataInput.hasRemaining()) {
            dictData.add(CFFParser.readEntry(cFFDataInput));
        }
        return dictData;
    }

    private static DictData readDictData(CFFDataInput cFFDataInput, int n) throws IOException {
        DictData dictData = new DictData();
        int n2 = cFFDataInput.getPosition() + n;
        while (cFFDataInput.getPosition() < n2) {
            dictData.add(CFFParser.readEntry(cFFDataInput));
        }
        return dictData;
    }

    private static DictData.Entry readEntry(CFFDataInput cFFDataInput) throws IOException {
        int n;
        DictData.Entry entry;
        block3: {
            entry = new DictData.Entry();
            while (true) {
                if ((n = cFFDataInput.readUnsignedByte()) >= 0 && n <= 21) break block3;
                if (n == 28 || n == 29) {
                    entry.operands.add(CFFParser.readIntegerNumber(cFFDataInput, n));
                    continue;
                }
                if (n == 30) {
                    entry.operands.add(CFFParser.readRealNumber(cFFDataInput, n));
                    continue;
                }
                if (n < 32 || n > 254) break;
                entry.operands.add(CFFParser.readIntegerNumber(cFFDataInput, n));
            }
            throw new IOException("invalid DICT data b0 byte: " + n);
        }
        entry.operator = CFFParser.readOperator(cFFDataInput, n);
        return entry;
    }

    private static CFFOperator readOperator(CFFDataInput cFFDataInput, int n) throws IOException {
        CFFOperator.Key key = CFFParser.readOperatorKey(cFFDataInput, n);
        return CFFOperator.getOperator(key);
    }

    private static CFFOperator.Key readOperatorKey(CFFDataInput cFFDataInput, int n) throws IOException {
        if (n == 12) {
            int n2 = cFFDataInput.readUnsignedByte();
            return new CFFOperator.Key(n, n2);
        }
        return new CFFOperator.Key(n);
    }

    private static Integer readIntegerNumber(CFFDataInput cFFDataInput, int n) throws IOException {
        if (n == 28) {
            return cFFDataInput.readShort();
        }
        if (n == 29) {
            return cFFDataInput.readInt();
        }
        if (n >= 32 && n <= 246) {
            return n - 139;
        }
        if (n >= 247 && n <= 250) {
            int n2 = cFFDataInput.readUnsignedByte();
            return (n - 247) * 256 + n2 + 108;
        }
        if (n >= 251 && n <= 254) {
            int n3 = cFFDataInput.readUnsignedByte();
            return -(n - 251) * 256 - n3 - 108;
        }
        throw new IllegalArgumentException();
    }

    private static Double readRealNumber(CFFDataInput cFFDataInput, int n) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            int[] nArray;
            int n2 = cFFDataInput.readUnsignedByte();
            block10: for (int n3 : nArray = new int[]{n2 / 16, n2 % 16}) {
                switch (n3) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        stringBuilder.append(n3);
                        bl2 = false;
                        continue block10;
                    }
                    case 10: {
                        stringBuilder.append(".");
                        continue block10;
                    }
                    case 11: {
                        stringBuilder.append("E");
                        bl2 = true;
                        continue block10;
                    }
                    case 12: {
                        stringBuilder.append("E-");
                        bl2 = true;
                        continue block10;
                    }
                    case 13: {
                        continue block10;
                    }
                    case 14: {
                        stringBuilder.append("-");
                        continue block10;
                    }
                    case 15: {
                        bl = true;
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        if (bl2) {
            stringBuilder.append("0");
        }
        if (stringBuilder.length() == 0) {
            return 0.0;
        }
        return Double.valueOf(stringBuilder.toString());
    }

    private CFFFont parseFont(CFFDataInput cFFDataInput, String string, byte[] byArray) throws IOException {
        CFFCharset cFFCharset;
        DictData.Entry entry;
        CFFFont cFFFont;
        boolean bl;
        CFFDataInput cFFDataInput2 = new CFFDataInput(byArray);
        DictData dictData = CFFParser.readDictData(cFFDataInput2);
        DictData.Entry entry2 = dictData.getEntry("SyntheticBase");
        if (entry2 != null) {
            throw new IOException("Synthetic Fonts are not supported");
        }
        boolean bl2 = bl = dictData.getEntry("ROS") != null;
        if (bl) {
            cFFFont = new CFFCIDFont();
            entry = dictData.getEntry("ROS");
            ((CFFCIDFont)cFFFont).setRegistry(this.readString(entry.getNumber(0).intValue()));
            ((CFFCIDFont)cFFFont).setOrdering(this.readString(entry.getNumber(1).intValue()));
            ((CFFCIDFont)cFFFont).setSupplement(entry.getNumber(2).intValue());
        } else {
            cFFFont = new CFFType1Font();
        }
        this.debugFontName = string;
        cFFFont.setName(string);
        cFFFont.addValueToTopDict("version", this.getString(dictData, "version"));
        cFFFont.addValueToTopDict("Notice", this.getString(dictData, "Notice"));
        cFFFont.addValueToTopDict("Copyright", this.getString(dictData, "Copyright"));
        cFFFont.addValueToTopDict("FullName", this.getString(dictData, "FullName"));
        cFFFont.addValueToTopDict("FamilyName", this.getString(dictData, "FamilyName"));
        cFFFont.addValueToTopDict("Weight", this.getString(dictData, "Weight"));
        cFFFont.addValueToTopDict("isFixedPitch", dictData.getBoolean("isFixedPitch", false));
        cFFFont.addValueToTopDict("ItalicAngle", dictData.getNumber("ItalicAngle", 0));
        cFFFont.addValueToTopDict("UnderlinePosition", dictData.getNumber("UnderlinePosition", -100));
        cFFFont.addValueToTopDict("UnderlineThickness", dictData.getNumber("UnderlineThickness", 50));
        cFFFont.addValueToTopDict("PaintType", dictData.getNumber("PaintType", 0));
        cFFFont.addValueToTopDict("CharstringType", dictData.getNumber("CharstringType", 2));
        cFFFont.addValueToTopDict("FontMatrix", dictData.getArray("FontMatrix", Arrays.asList(0.001, 0.0, 0.0, 0.001, 0.0, 0.0)));
        cFFFont.addValueToTopDict("UniqueID", dictData.getNumber("UniqueID", null));
        cFFFont.addValueToTopDict("FontBBox", dictData.getArray("FontBBox", Arrays.asList(0, 0, 0, 0)));
        cFFFont.addValueToTopDict("StrokeWidth", dictData.getNumber("StrokeWidth", 0));
        cFFFont.addValueToTopDict("XUID", dictData.getArray("XUID", null));
        entry = dictData.getEntry("CharStrings");
        int n = entry.getNumber(0).intValue();
        cFFDataInput.setPosition(n);
        byte[][] byArray2 = CFFParser.readIndexData(cFFDataInput);
        DictData.Entry entry3 = dictData.getEntry("charset");
        if (entry3 != null) {
            int n2 = entry3.getNumber(0).intValue();
            if (!bl && n2 == 0) {
                cFFCharset = CFFISOAdobeCharset.getInstance();
            } else if (!bl && n2 == 1) {
                cFFCharset = CFFExpertCharset.getInstance();
            } else if (!bl && n2 == 2) {
                cFFCharset = CFFExpertSubsetCharset.getInstance();
            } else {
                cFFDataInput.setPosition(n2);
                cFFCharset = this.readCharset(cFFDataInput, byArray2.length, bl);
            }
        } else {
            cFFCharset = bl ? new EmptyCharset(byArray2.length) : CFFISOAdobeCharset.getInstance();
        }
        cFFFont.setCharset(cFFCharset);
        cFFFont.charStrings = byArray2;
        if (bl) {
            List<Number> list;
            this.parseCIDFontDicts(cFFDataInput, dictData, (CFFCIDFont)cFFFont, byArray2.length);
            List list2 = null;
            List<Map<String, Object>> list3 = ((CFFCIDFont)cFFFont).getFontDicts();
            if (list3.size() > 0 && list3.get(0).containsKey("FontMatrix")) {
                list2 = (List)list3.get(0).get("FontMatrix");
            }
            if ((list = dictData.getArray("FontMatrix", null)) == null) {
                if (list2 != null) {
                    cFFFont.addValueToTopDict("FontMatrix", list2);
                } else {
                    cFFFont.addValueToTopDict("FontMatrix", dictData.getArray("FontMatrix", Arrays.asList(0.001, 0.0, 0.0, 0.001, 0.0, 0.0)));
                }
            } else if (list2 != null) {
                this.concatenateMatrix(list, list2);
            }
        } else {
            this.parseType1Dicts(cFFDataInput, dictData, (CFFType1Font)cFFFont, cFFCharset);
        }
        return cFFFont;
    }

    private void concatenateMatrix(List<Number> list, List<Number> list2) {
        double d = list.get(0).doubleValue();
        double d2 = list.get(1).doubleValue();
        double d3 = list.get(2).doubleValue();
        double d4 = list.get(3).doubleValue();
        double d5 = list.get(4).doubleValue();
        double d6 = list.get(5).doubleValue();
        double d7 = list2.get(0).doubleValue();
        double d8 = list2.get(1).doubleValue();
        double d9 = list2.get(2).doubleValue();
        double d10 = list2.get(3).doubleValue();
        double d11 = list2.get(4).doubleValue();
        double d12 = list2.get(5).doubleValue();
        list.set(0, d * d7 + d2 * d9);
        list.set(1, d * d8 + d2 * d4);
        list.set(2, d3 * d7 + d4 * d9);
        list.set(3, d3 * d8 + d4 * d10);
        list.set(4, d5 * d7 + d6 * d9 + d11);
        list.set(5, d5 * d8 + d6 * d10 + d12);
    }

    private void parseCIDFontDicts(CFFDataInput cFFDataInput, DictData dictData, CFFCIDFont cFFCIDFont, int n) throws IOException {
        DictData.Entry entry = dictData.getEntry("FDArray");
        if (entry == null) {
            throw new IOException("FDArray is missing for a CIDKeyed Font.");
        }
        int n2 = entry.getNumber(0).intValue();
        cFFDataInput.setPosition(n2);
        byte[][] byArray = CFFParser.readIndexData(cFFDataInput);
        LinkedList<Map<String, Object>> linkedList = new LinkedList<Map<String, Object>>();
        LinkedList<Map<String, Object>> linkedList2 = new LinkedList<Map<String, Object>>();
        for (byte[] byArray2 : byArray) {
            CFFDataInput cFFDataInput2 = new CFFDataInput(byArray2);
            DictData dictData2 = CFFParser.readDictData(cFFDataInput2);
            DictData.Entry entry2 = dictData2.getEntry("Private");
            if (entry2 == null) {
                throw new IOException("Font DICT invalid without \"Private\" entry");
            }
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(4);
            linkedHashMap.put("FontName", this.getString(dictData2, "FontName"));
            linkedHashMap.put("FontType", dictData2.getNumber("FontType", 0));
            linkedHashMap.put("FontBBox", dictData2.getArray("FontBBox", null));
            linkedHashMap.put("FontMatrix", dictData2.getArray("FontMatrix", null));
            linkedList2.add(linkedHashMap);
            int n3 = entry2.getNumber(1).intValue();
            cFFDataInput.setPosition(n3);
            int n4 = entry2.getNumber(0).intValue();
            DictData dictData3 = CFFParser.readDictData(cFFDataInput, n4);
            Map<String, Object> map = this.readPrivateDict(dictData3);
            linkedList.add(map);
            int n5 = (Integer)dictData3.getNumber("Subrs", 0);
            if (n5 <= 0) continue;
            cFFDataInput.setPosition(n3 + n5);
            map.put("Subrs", CFFParser.readIndexData(cFFDataInput));
        }
        Object object = dictData.getEntry("FDSelect");
        int n6 = ((DictData.Entry)object).getNumber(0).intValue();
        cFFDataInput.setPosition(n6);
        FDSelect fDSelect = CFFParser.readFDSelect(cFFDataInput, n, cFFCIDFont);
        cFFCIDFont.setFontDict(linkedList2);
        cFFCIDFont.setPrivDict(linkedList);
        cFFCIDFont.setFdSelect(fDSelect);
    }

    private Map<String, Object> readPrivateDict(DictData dictData) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(17);
        linkedHashMap.put("BlueValues", dictData.getArray("BlueValues", null));
        linkedHashMap.put("OtherBlues", dictData.getArray("OtherBlues", null));
        linkedHashMap.put("FamilyBlues", dictData.getArray("FamilyBlues", null));
        linkedHashMap.put("FamilyOtherBlues", dictData.getArray("FamilyOtherBlues", null));
        linkedHashMap.put("BlueScale", dictData.getNumber("BlueScale", 0.039625));
        linkedHashMap.put("BlueShift", dictData.getNumber("BlueShift", 7));
        linkedHashMap.put("BlueFuzz", dictData.getNumber("BlueFuzz", 1));
        linkedHashMap.put("StdHW", dictData.getNumber("StdHW", null));
        linkedHashMap.put("StdVW", dictData.getNumber("StdVW", null));
        linkedHashMap.put("StemSnapH", dictData.getArray("StemSnapH", null));
        linkedHashMap.put("StemSnapV", dictData.getArray("StemSnapV", null));
        linkedHashMap.put("ForceBold", dictData.getBoolean("ForceBold", false));
        linkedHashMap.put("LanguageGroup", dictData.getNumber("LanguageGroup", 0));
        linkedHashMap.put("ExpansionFactor", dictData.getNumber("ExpansionFactor", 0.06));
        linkedHashMap.put("initialRandomSeed", dictData.getNumber("initialRandomSeed", 0));
        linkedHashMap.put("defaultWidthX", dictData.getNumber("defaultWidthX", 0));
        linkedHashMap.put("nominalWidthX", dictData.getNumber("nominalWidthX", 0));
        return linkedHashMap;
    }

    private void parseType1Dicts(CFFDataInput cFFDataInput, DictData dictData, CFFType1Font cFFType1Font, CFFCharset cFFCharset) throws IOException {
        CFFEncoding cFFEncoding;
        DictData.Entry entry = dictData.getEntry("Encoding");
        int n = entry != null ? entry.getNumber(0).intValue() : 0;
        switch (n) {
            case 0: {
                cFFEncoding = CFFStandardEncoding.getInstance();
                break;
            }
            case 1: {
                cFFEncoding = CFFExpertEncoding.getInstance();
                break;
            }
            default: {
                cFFDataInput.setPosition(n);
                cFFEncoding = this.readEncoding(cFFDataInput, cFFCharset);
            }
        }
        cFFType1Font.setEncoding(cFFEncoding);
        DictData.Entry entry2 = dictData.getEntry("Private");
        if (entry2 == null) {
            throw new IOException("Private dictionary entry missing for font " + cFFType1Font.fontName);
        }
        int n2 = entry2.getNumber(1).intValue();
        cFFDataInput.setPosition(n2);
        int n3 = entry2.getNumber(0).intValue();
        DictData dictData2 = CFFParser.readDictData(cFFDataInput, n3);
        Map<String, Object> map = this.readPrivateDict(dictData2);
        for (Map.Entry<String, Object> entry3 : map.entrySet()) {
            cFFType1Font.addToPrivateDict(entry3.getKey(), entry3.getValue());
        }
        int n4 = (Integer)dictData2.getNumber("Subrs", 0);
        if (n4 > 0) {
            cFFDataInput.setPosition(n2 + n4);
            cFFType1Font.addToPrivateDict("Subrs", CFFParser.readIndexData(cFFDataInput));
        }
    }

    private String readString(int n) throws IOException {
        if (n >= 0 && n <= 390) {
            return CFFStandardString.getName(n);
        }
        if (n - 391 < this.stringIndex.length) {
            return this.stringIndex[n - 391];
        }
        return "SID" + n;
    }

    private String getString(DictData dictData, String string) throws IOException {
        DictData.Entry entry = dictData.getEntry(string);
        return entry != null ? this.readString(entry.getNumber(0).intValue()) : null;
    }

    private CFFEncoding readEncoding(CFFDataInput cFFDataInput, CFFCharset cFFCharset) throws IOException {
        int n = cFFDataInput.readCard8();
        int n2 = n & 0x7F;
        if (n2 == 0) {
            return this.readFormat0Encoding(cFFDataInput, cFFCharset, n);
        }
        if (n2 == 1) {
            return this.readFormat1Encoding(cFFDataInput, cFFCharset, n);
        }
        throw new IllegalArgumentException();
    }

    private Format0Encoding readFormat0Encoding(CFFDataInput cFFDataInput, CFFCharset cFFCharset, int n) throws IOException {
        Format0Encoding format0Encoding = new Format0Encoding();
        format0Encoding.format = n;
        format0Encoding.nCodes = cFFDataInput.readCard8();
        format0Encoding.add(0, 0, ".notdef");
        for (int i = 1; i <= format0Encoding.nCodes; ++i) {
            int n2 = cFFDataInput.readCard8();
            int n3 = cFFCharset.getSIDForGID(i);
            format0Encoding.add(n2, n3, this.readString(n3));
        }
        if ((n & 0x80) != 0) {
            this.readSupplement(cFFDataInput, format0Encoding);
        }
        return format0Encoding;
    }

    private Format1Encoding readFormat1Encoding(CFFDataInput cFFDataInput, CFFCharset cFFCharset, int n) throws IOException {
        Format1Encoding format1Encoding = new Format1Encoding();
        format1Encoding.format = n;
        format1Encoding.nRanges = cFFDataInput.readCard8();
        format1Encoding.add(0, 0, ".notdef");
        int n2 = 1;
        for (int i = 0; i < format1Encoding.nRanges; ++i) {
            int n3 = cFFDataInput.readCard8();
            int n4 = cFFDataInput.readCard8();
            for (int j = 0; j < 1 + n4; ++j) {
                int n5 = cFFCharset.getSIDForGID(n2);
                int n6 = n3 + j;
                format1Encoding.add(n6, n5, this.readString(n5));
                ++n2;
            }
        }
        if ((n & 0x80) != 0) {
            this.readSupplement(cFFDataInput, format1Encoding);
        }
        return format1Encoding;
    }

    private void readSupplement(CFFDataInput cFFDataInput, CFFBuiltInEncoding cFFBuiltInEncoding) throws IOException {
        cFFBuiltInEncoding.nSups = cFFDataInput.readCard8();
        CFFBuiltInEncoding.access$1602(cFFBuiltInEncoding, new CFFBuiltInEncoding.Supplement[cFFBuiltInEncoding.nSups]);
        for (int i = 0; i < cFFBuiltInEncoding.supplement.length; ++i) {
            CFFBuiltInEncoding.Supplement supplement = new CFFBuiltInEncoding.Supplement();
            supplement.code = cFFDataInput.readCard8();
            supplement.sid = cFFDataInput.readSID();
            supplement.name = this.readString(supplement.sid);
            ((CFFBuiltInEncoding)cFFBuiltInEncoding).supplement[i] = supplement;
            cFFBuiltInEncoding.add(supplement.code, supplement.sid, this.readString(supplement.sid));
        }
    }

    private static FDSelect readFDSelect(CFFDataInput cFFDataInput, int n, CFFCIDFont cFFCIDFont) throws IOException {
        int n2 = cFFDataInput.readCard8();
        if (n2 == 0) {
            return CFFParser.readFormat0FDSelect(cFFDataInput, n2, n, cFFCIDFont);
        }
        if (n2 == 3) {
            return CFFParser.readFormat3FDSelect(cFFDataInput, n2, n, cFFCIDFont);
        }
        throw new IllegalArgumentException();
    }

    private static Format0FDSelect readFormat0FDSelect(CFFDataInput cFFDataInput, int n, int n2, CFFCIDFont cFFCIDFont) throws IOException {
        Format0FDSelect format0FDSelect = new Format0FDSelect(cFFCIDFont);
        format0FDSelect.format = n;
        Format0FDSelect.access$2202(format0FDSelect, new int[n2]);
        for (int i = 0; i < format0FDSelect.fds.length; ++i) {
            ((Format0FDSelect)format0FDSelect).fds[i] = cFFDataInput.readCard8();
        }
        return format0FDSelect;
    }

    private static Format3FDSelect readFormat3FDSelect(CFFDataInput cFFDataInput, int n, int n2, CFFCIDFont cFFCIDFont) throws IOException {
        Format3FDSelect format3FDSelect = new Format3FDSelect(cFFCIDFont);
        format3FDSelect.format = n;
        format3FDSelect.nbRanges = cFFDataInput.readCard16();
        Format3FDSelect.access$2602(format3FDSelect, new Range3[format3FDSelect.nbRanges]);
        for (int i = 0; i < format3FDSelect.nbRanges; ++i) {
            Range3 range3 = new Range3();
            range3.first = cFFDataInput.readCard16();
            range3.fd = cFFDataInput.readCard8();
            ((Format3FDSelect)format3FDSelect).range3[i] = range3;
        }
        format3FDSelect.sentinel = cFFDataInput.readCard16();
        return format3FDSelect;
    }

    private CFFCharset readCharset(CFFDataInput cFFDataInput, int n, boolean bl) throws IOException {
        int n2 = cFFDataInput.readCard8();
        if (n2 == 0) {
            return this.readFormat0Charset(cFFDataInput, n2, n, bl);
        }
        if (n2 == 1) {
            return this.readFormat1Charset(cFFDataInput, n2, n, bl);
        }
        if (n2 == 2) {
            return this.readFormat2Charset(cFFDataInput, n2, n, bl);
        }
        throw new IllegalArgumentException();
    }

    private Format0Charset readFormat0Charset(CFFDataInput cFFDataInput, int n, int n2, boolean bl) throws IOException {
        Format0Charset format0Charset = new Format0Charset(bl);
        format0Charset.format = n;
        if (bl) {
            format0Charset.addCID(0, 0);
        } else {
            format0Charset.addSID(0, 0, ".notdef");
        }
        for (int i = 1; i < n2; ++i) {
            int n3 = cFFDataInput.readSID();
            if (bl) {
                format0Charset.addCID(i, n3);
                continue;
            }
            format0Charset.addSID(i, n3, this.readString(n3));
        }
        return format0Charset;
    }

    private Format1Charset readFormat1Charset(CFFDataInput cFFDataInput, int n, int n2, boolean bl) throws IOException {
        Format1Charset format1Charset = new Format1Charset(bl);
        format1Charset.format = n;
        if (bl) {
            format1Charset.addCID(0, 0);
            format1Charset.rangesCID2GID = new ArrayList();
        } else {
            format1Charset.addSID(0, 0, ".notdef");
        }
        for (int i = 1; i < n2; ++i) {
            int n3 = cFFDataInput.readSID();
            int n4 = cFFDataInput.readCard8();
            if (!bl) {
                for (int j = 0; j < 1 + n4; ++j) {
                    int n5 = n3 + j;
                    format1Charset.addSID(i + j, n5, this.readString(n5));
                }
            } else {
                format1Charset.rangesCID2GID.add(new RangeMapping(i, n3, n4));
            }
            i += n4;
        }
        return format1Charset;
    }

    private Format2Charset readFormat2Charset(CFFDataInput cFFDataInput, int n, int n2, boolean bl) throws IOException {
        Format2Charset format2Charset = new Format2Charset(bl);
        format2Charset.format = n;
        if (bl) {
            format2Charset.addCID(0, 0);
            format2Charset.rangesCID2GID = new ArrayList();
        } else {
            format2Charset.addSID(0, 0, ".notdef");
        }
        for (int i = 1; i < n2; ++i) {
            int n3 = cFFDataInput.readSID();
            int n4 = cFFDataInput.readCard16();
            if (!bl) {
                for (int j = 0; j < 1 + n4; ++j) {
                    int n5 = n3 + j;
                    format2Charset.addSID(i + j, n5, this.readString(n5));
                }
            } else {
                format2Charset.rangesCID2GID.add(new RangeMapping(i, n3, n4));
            }
            i += n4;
        }
        return format2Charset;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.debugFontName + "]";
    }

    private static final class RangeMapping {
        private final int startValue;
        private final int endValue;
        private final int startMappedValue;
        private final int endMappedValue;

        private RangeMapping(int n, int n2, int n3) {
            this.startValue = n;
            this.endValue = this.startValue + n3;
            this.startMappedValue = n2;
            this.endMappedValue = this.startMappedValue + n3;
        }

        boolean isInRange(int n) {
            return n >= this.startValue && n <= this.endValue;
        }

        boolean isInReverseRange(int n) {
            return n >= this.startMappedValue && n <= this.endMappedValue;
        }

        int mapValue(int n) {
            if (this.isInRange(n)) {
                return this.startMappedValue + (n - this.startValue);
            }
            return 0;
        }

        int mapReverseValue(int n) {
            if (this.isInReverseRange(n)) {
                return this.startValue + (n - this.startMappedValue);
            }
            return 0;
        }

        public String toString() {
            return this.getClass().getName() + "[start value=" + this.startValue + ", end value=" + this.endValue + ", start mapped-value=" + this.startMappedValue + ", end mapped-value=" + this.endMappedValue + "]";
        }
    }

    private static class Format2Charset
    extends EmbeddedCharset {
        private int format;
        private List<RangeMapping> rangesCID2GID;

        protected Format2Charset(boolean bl) {
            super(bl);
        }

        @Override
        public int getCIDForGID(int n) {
            for (RangeMapping rangeMapping : this.rangesCID2GID) {
                if (!rangeMapping.isInRange(n)) continue;
                return rangeMapping.mapValue(n);
            }
            return super.getCIDForGID(n);
        }

        @Override
        public int getGIDForCID(int n) {
            for (RangeMapping rangeMapping : this.rangesCID2GID) {
                if (!rangeMapping.isInReverseRange(n)) continue;
                return rangeMapping.mapReverseValue(n);
            }
            return super.getGIDForCID(n);
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + "]";
        }
    }

    private static class Format1Charset
    extends EmbeddedCharset {
        private int format;
        private List<RangeMapping> rangesCID2GID;

        protected Format1Charset(boolean bl) {
            super(bl);
        }

        @Override
        public int getCIDForGID(int n) {
            if (this.isCIDFont()) {
                for (RangeMapping rangeMapping : this.rangesCID2GID) {
                    if (!rangeMapping.isInRange(n)) continue;
                    return rangeMapping.mapValue(n);
                }
            }
            return super.getCIDForGID(n);
        }

        @Override
        public int getGIDForCID(int n) {
            if (this.isCIDFont()) {
                for (RangeMapping rangeMapping : this.rangesCID2GID) {
                    if (!rangeMapping.isInReverseRange(n)) continue;
                    return rangeMapping.mapReverseValue(n);
                }
            }
            return super.getGIDForCID(n);
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + "]";
        }
    }

    private static class Format0Charset
    extends EmbeddedCharset {
        private int format;

        protected Format0Charset(boolean bl) {
            super(bl);
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + "]";
        }
    }

    private static class EmptyCharset
    extends EmbeddedCharset {
        protected EmptyCharset(int n) {
            super(true);
            this.addCID(0, 0);
            for (int i = 1; i <= n; ++i) {
                this.addCID(i, i);
            }
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    static abstract class EmbeddedCharset
    extends CFFCharset {
        protected EmbeddedCharset(boolean bl) {
            super(bl);
        }
    }

    private static class Format1Encoding
    extends CFFBuiltInEncoding {
        private int format;
        private int nRanges;

        private Format1Encoding() {
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + ", nRanges=" + this.nRanges + ", supplement=" + Arrays.toString(((CFFBuiltInEncoding)this).supplement) + "]";
        }
    }

    private static class Format0Encoding
    extends CFFBuiltInEncoding {
        private int format;
        private int nCodes;

        private Format0Encoding() {
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + ", nCodes=" + this.nCodes + ", supplement=" + Arrays.toString(((CFFBuiltInEncoding)this).supplement) + "]";
        }
    }

    static abstract class CFFBuiltInEncoding
    extends CFFEncoding {
        private int nSups;
        private Supplement[] supplement;

        CFFBuiltInEncoding() {
        }

        static /* synthetic */ Supplement[] access$1602(CFFBuiltInEncoding cFFBuiltInEncoding, Supplement[] supplementArray) {
            cFFBuiltInEncoding.supplement = supplementArray;
            return supplementArray;
        }

        static class Supplement {
            private int code;
            private int sid;
            private String name;

            Supplement() {
            }

            public int getCode() {
                return this.code;
            }

            public int getSID() {
                return this.sid;
            }

            public String getName() {
                return this.name;
            }

            public String toString() {
                return this.getClass().getName() + "[code=" + this.code + ", sid=" + this.sid + "]";
            }
        }
    }

    private static class DictData {
        private final Map<String, Entry> entries = new HashMap<String, Entry>();

        private DictData() {
        }

        public void add(Entry entry) {
            if (entry.operator != null) {
                this.entries.put(entry.operator.getName(), entry);
            }
        }

        public Entry getEntry(String string) {
            return this.entries.get(string);
        }

        public Boolean getBoolean(String string, boolean bl) {
            Entry entry = this.getEntry(string);
            return entry != null && entry.getArray().size() > 0 ? entry.getBoolean(0) : bl;
        }

        public List<Number> getArray(String string, List<Number> list) {
            Entry entry = this.getEntry(string);
            return entry != null && entry.getArray().size() > 0 ? entry.getArray() : list;
        }

        public Number getNumber(String string, Number number) {
            Entry entry = this.getEntry(string);
            return entry != null && entry.getArray().size() > 0 ? (Number)entry.getNumber(0) : (Number)number;
        }

        public String toString() {
            return this.getClass().getName() + "[entries=" + this.entries + "]";
        }

        private static class Entry {
            private List<Number> operands = new ArrayList<Number>();
            private CFFOperator operator = null;

            private Entry() {
            }

            public Number getNumber(int n) {
                return this.operands.get(n);
            }

            public Boolean getBoolean(int n) {
                Number number = this.operands.get(n);
                if (number instanceof Integer) {
                    switch (number.intValue()) {
                        case 0: {
                            return Boolean.FALSE;
                        }
                        case 1: {
                            return Boolean.TRUE;
                        }
                    }
                }
                throw new IllegalArgumentException();
            }

            public List<Number> getArray() {
                return this.operands;
            }

            public String toString() {
                return this.getClass().getName() + "[operands=" + this.operands + ", operator=" + this.operator + "]";
            }
        }
    }

    private static class Header {
        private int major;
        private int minor;
        private int hdrSize;
        private int offSize;

        private Header() {
        }

        public String toString() {
            return this.getClass().getName() + "[major=" + this.major + ", minor=" + this.minor + ", hdrSize=" + this.hdrSize + ", offSize=" + this.offSize + "]";
        }
    }

    private static class Format0FDSelect
    extends FDSelect {
        private int format;
        private int[] fds;

        private Format0FDSelect(CFFCIDFont cFFCIDFont) {
            super(cFFCIDFont);
        }

        @Override
        public int getFDIndex(int n) {
            if (n < this.fds.length) {
                return this.fds[n];
            }
            return 0;
        }

        public String toString() {
            return this.getClass().getName() + "[fds=" + Arrays.toString(this.fds) + "]";
        }

        static /* synthetic */ int[] access$2202(Format0FDSelect format0FDSelect, int[] nArray) {
            format0FDSelect.fds = nArray;
            return nArray;
        }
    }

    private static final class Range3 {
        private int first;
        private int fd;

        private Range3() {
        }

        public String toString() {
            return this.getClass().getName() + "[first=" + this.first + ", fd=" + this.fd + "]";
        }
    }

    private static final class Format3FDSelect
    extends FDSelect {
        private int format;
        private int nbRanges;
        private Range3[] range3;
        private int sentinel;

        private Format3FDSelect(CFFCIDFont cFFCIDFont) {
            super(cFFCIDFont);
        }

        @Override
        public int getFDIndex(int n) {
            for (int i = 0; i < this.nbRanges; ++i) {
                if (this.range3[i].first > n) continue;
                if (i + 1 < this.nbRanges) {
                    if (this.range3[i + 1].first <= n) continue;
                    return this.range3[i].fd;
                }
                if (this.sentinel > n) {
                    return this.range3[i].fd;
                }
                return -1;
            }
            return 0;
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + " nbRanges=" + this.nbRanges + ", range3=" + Arrays.toString(this.range3) + " sentinel=" + this.sentinel + "]";
        }

        static /* synthetic */ Range3[] access$2602(Format3FDSelect format3FDSelect, Range3[] range3Array) {
            format3FDSelect.range3 = range3Array;
            return range3Array;
        }
    }

    public static interface ByteSource {
        public byte[] getBytes() throws IOException;
    }
}

