/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.PeerNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.lang.ref.WeakReference;

class PeerNodeBackoffStatusChecker
implements Runnable {
    final WeakReference<PeerNode> ref;
    private static volatile boolean logMINOR;

    public PeerNodeBackoffStatusChecker(WeakReference<PeerNode> ref) {
        this.ref = ref;
    }

    @Override
    public void run() {
        PeerNode pn = (PeerNode)this.ref.get();
        if (pn == null) {
            return;
        }
        if (pn.cachedRemoved()) {
            if (logMINOR && pn.node.peers.havePeer(pn)) {
                Logger.error(this, "Removed flag is set yet is in peers table?!: " + pn);
            } else {
                return;
            }
        }
        if (!pn.node.peers.havePeer(pn)) {
            if (!pn.cachedRemoved()) {
                Logger.error(this, "Not in peers table but not flagged as removed: " + pn);
            }
            return;
        }
        pn.setPeerNodeStatus(System.currentTimeMillis(), true);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

