/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.DSAPublicKey;
import freenet.crypt.SHA256;
import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerContext;
import freenet.io.comm.SlowAsyncMessageFilterCallback;
import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.keys.SSKVerifyException;
import freenet.node.AnyInsertSender;
import freenet.node.BaseSender;
import freenet.node.InsertTag;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.node.SyncSendWaitedTooLongException;
import freenet.node.UIDTag;
import freenet.support.Logger;
import freenet.support.ShortBuffer;
import freenet.support.io.NativeThread;
import java.util.concurrent.TimeUnit;

public class SSKInsertSender
extends BaseSender
implements PrioRunnable,
AnyInsertSender,
ByteCounter {
    static final long ACCEPTED_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    final NodeSSK myKey;
    final long origUID;
    final InsertTag origTag;
    final DSAPublicKey pubKey;
    final byte[] pubKeyHash;
    byte[] data;
    byte[] headers;
    final boolean fromStore;
    final long startTime;
    private boolean hasCollided;
    private boolean hasRecentlyCollided;
    private SSKBlock block;
    private static boolean logMINOR;
    private static boolean logDEBUG;
    private final boolean forkOnCacheable;
    private final boolean preferInsert;
    private final boolean ignoreLowBackoff;
    private final boolean realTimeFlag;
    private InsertTag forkedRequestTag;
    private int status = -1;
    static final int NOT_FINISHED = -1;
    static final int SUCCESS = 0;
    static final int ROUTE_NOT_FOUND = 1;
    static final int INTERNAL_ERROR = 3;
    static final int TIMED_OUT = 4;
    static final int GENERATED_REJECTED_OVERLOAD = 5;
    static final int ROUTE_REALLY_NOT_FOUND = 6;
    static final int MAX_HIGH_HTL_FAILURES = 5;
    private static final long TIMEOUT_AFTER_ACCEPTEDREJECTED_TIMEOUT;
    private boolean hasForwardedRejectedOverload;
    private final Object totalBytesSync = new Object();
    private int totalBytesSent;
    private int totalBytesReceived;
    private boolean needPubKey;

    SSKInsertSender(SSKBlock block, long uid, InsertTag tag, short htl, PeerNode source, Node node, boolean fromStore, boolean canWriteClientCache, boolean forkOnCacheable, boolean preferInsert, boolean ignoreLowBackoff, boolean realTimeFlag) {
        super(block.getKey(), realTimeFlag, source, node, htl, uid);
        this.fromStore = fromStore;
        this.origUID = uid;
        this.origTag = tag;
        this.myKey = block.getKey();
        this.data = block.getRawData();
        this.headers = block.getRawHeaders();
        this.pubKey = this.myKey.getPubKey();
        if (this.pubKey == null) {
            throw new IllegalArgumentException("Must have pubkey to insert data!!");
        }
        byte[] pubKeyAsBytes = this.pubKey.asBytes();
        this.pubKeyHash = SHA256.digest(pubKeyAsBytes);
        this.block = block;
        this.startTime = System.currentTimeMillis();
        this.forkOnCacheable = forkOnCacheable;
        this.preferInsert = preferInsert;
        this.ignoreLowBackoff = ignoreLowBackoff;
        this.realTimeFlag = realTimeFlag;
    }

    void start() {
        this.node.executor.execute(this, "SSKInsertSender for UID " + this.uid + " on " + this.node.getDarknetPortNumber() + " at " + System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Logger.OSThread.logPID(this);
        this.origTag.startedSender();
        try {
            this.routeRequests();
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
            if (this.status == -1) {
                this.finish(3, null);
            }
        }
        finally {
            if (logMINOR) {
                Logger.minor(this, "Finishing " + this);
            }
            if (this.status == -1) {
                this.finish(3, null);
            }
            this.origTag.finishedSender();
            if (this.forkedRequestTag != null) {
                this.forkedRequestTag.finishedSender();
            }
        }
    }

    @Override
    protected void routeRequests() {
        PeerNode next = null;
        int highHTLFailureCount = 0;
        boolean starting = true;
        boolean canWriteStorePrev = this.node.canWriteDatastoreInsert(this.htl);
        if (!starting && !canWriteStorePrev) {
            if (highHTLFailureCount++ >= 5) {
                if (logMINOR) {
                    Logger.minor(this, "Too many failures at non-cacheable HTL");
                }
                this.finish(1, null);
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Allowing failure " + highHTLFailureCount + " htl is still " + this.htl);
            }
        } else {
            this.htl = this.node.decrementHTL(this.hasForwarded ? next : this.source, this.htl);
            if (logMINOR) {
                Logger.minor(this, "Decremented HTL to " + this.htl);
            }
        }
        starting = false;
        if (this.htl <= 0) {
            if (!this.hasForwarded) {
                this.origTag.setNotRoutedOnwards();
            }
            this.finish(0, null);
            return;
        }
        if (this.origTag.shouldStop()) {
            this.finish(0, null);
            return;
        }
        if (this.node.canWriteDatastoreInsert(this.htl) && !canWriteStorePrev && this.forkOnCacheable && this.forkedRequestTag == null) {
            this.uid = this.node.clientCore.makeUID();
            this.forkedRequestTag = new InsertTag(true, InsertTag.START.REMOTE, this.source, this.realTimeFlag, this.uid, this.node);
            this.forkedRequestTag.reassignToSelf();
            this.forkedRequestTag.startedSender();
            this.forkedRequestTag.unlockHandler();
            this.forkedRequestTag.setAccepted();
            Logger.normal(this, "FORKING SSK INSERT " + this.origUID + " to " + this.uid);
            this.nodesRoutedTo.clear();
            this.node.tracker.lockUID(this.forkedRequestTag);
        }
        if ((next = this.node.peers.closerPeer(this.forkedRequestTag == null ? this.source : null, this.nodesRoutedTo, this.target, true, this.node.isAdvancedModeEnabled(), -1, null, null, this.htl, this.ignoreLowBackoff ? Node.LOW_BACKOFF : 0L, this.source == null, this.realTimeFlag, this.newLoadManagement)) == null) {
            if (!this.hasForwarded) {
                this.origTag.setNotRoutedOnwards();
            }
            this.finish(1, null);
            return;
        }
        InsertTag thisTag = this.forkedRequestTag;
        if (this.forkedRequestTag == null) {
            thisTag = this.origTag;
        }
        this.innerRouteRequests(next, thisTag);
    }

    private void handleNoPubkeyAccepted(PeerNode next, InsertTag thisTag) {
        Logger.error(this, "Timeout waiting for FNPSSKPubKeyAccepted on " + next);
        next.localRejectedOverload("Timeout2", this.realTimeFlag);
        this.forwardRejectedOverload();
        next.fatalTimeout(thisTag, false);
    }

    private MessageFilter makeSearchFilter(PeerNode next, int searchTimeout) {
        MessageFilter mfInsertReply = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(searchTimeout).setType(DMT.FNPInsertReply);
        MessageFilter mfRejectedOverload = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(searchTimeout).setType(DMT.FNPRejectedOverload);
        MessageFilter mfRouteNotFound = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(searchTimeout).setType(DMT.FNPRouteNotFound);
        MessageFilter mfDataInsertRejected = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(searchTimeout).setType(DMT.FNPDataInsertRejected);
        MessageFilter mfSSKDataFoundHeaders = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(searchTimeout).setType(DMT.FNPSSKDataFoundHeaders);
        return mfRouteNotFound.or(mfInsertReply.or(mfRejectedOverload.or(mfDataInsertRejected.or(mfSSKDataFoundHeaders))));
    }

    private DO handleMessage(Message msg, PeerNode next, InsertTag thisTag) {
        if (msg.getSpec() == DMT.FNPRejectedOverload) {
            if (this.handleRejectedOverload(msg, next, thisTag)) {
                return DO.NEXT_PEER;
            }
            return DO.WAIT;
        }
        if (msg.getSpec() == DMT.FNPRouteNotFound) {
            this.handleRouteNotFound(msg, next, thisTag);
            return DO.NEXT_PEER;
        }
        if (msg.getSpec() == DMT.FNPDataInsertRejected) {
            this.handleDataInsertRejected(msg, next, thisTag);
            return DO.NEXT_PEER;
        }
        if (msg.getSpec() == DMT.FNPSSKDataFoundHeaders) {
            return this.handleSSKDataFoundHeaders(msg, next, thisTag);
        }
        if (msg.getSpec() != DMT.FNPInsertReply) {
            Logger.error(this, "Unknown reply: " + msg);
            this.finish(3, next);
            return DO.FINISHED;
        }
        next.successNotOverload(this.realTimeFlag);
        this.finish(0, next);
        return DO.FINISHED;
    }

    @Override
    protected void handleAcceptedRejectedTimeout(final PeerNode next, final UIDTag tag) {
        Logger.warning(this, "Timeout awaiting Accepted/Rejected " + this + " to " + next);
        final long uid = tag.uid;
        tag.handlingTimeout(next);
        MessageFilter mf = this.makeAcceptedRejectedFilter(next, TIMEOUT_AFTER_ACCEPTEDREJECTED_TIMEOUT, tag);
        try {
            this.node.usm.addAsyncFilter(mf, new SlowAsyncMessageFilterCallback(){

                @Override
                public void onMatched(Message m) {
                    if (m.getSpec() == DMT.FNPRejectedLoop || m.getSpec() == DMT.FNPRejectedOverload) {
                        next.noLongerRoutingTo(tag, false);
                    } else {
                        assert (m.getSpec() == DMT.FNPSSKAccepted);
                        if (logMINOR) {
                            Logger.minor(this, "Accepted after timeout on " + SSKInsertSender.this + " - will not send DataInsert, waiting for RejectedTimeout");
                        }
                        if (logMINOR) {
                            Logger.minor(this, "Forked timed out insert but not going to send DataInsert on " + SSKInsertSender.this + " to " + next);
                        }
                        try {
                            next.sendAsync(DMT.createFNPDataInsertRejected(uid, (short)4), new AsyncMessageCallback(){

                                @Override
                                public void sent() {
                                    if (logDEBUG) {
                                        Logger.debug(this, "DataInsertRejected sent after accepted timeout on " + SSKInsertSender.this);
                                    }
                                }

                                @Override
                                public void acknowledged() {
                                    if (logDEBUG) {
                                        Logger.debug(this, "DataInsertRejected acknowledged after accepted timeout on " + SSKInsertSender.this);
                                    }
                                    next.noLongerRoutingTo(tag, false);
                                }

                                @Override
                                public void disconnected() {
                                    if (logDEBUG) {
                                        Logger.debug(this, "DataInsertRejected peer disconnected after accepted timeout on " + SSKInsertSender.this);
                                    }
                                    next.noLongerRoutingTo(tag, false);
                                }

                                @Override
                                public void fatalError() {
                                    if (logDEBUG) {
                                        Logger.debug(this, "DataInsertRejected fatal error after accepted timeout on " + SSKInsertSender.this);
                                    }
                                    next.noLongerRoutingTo(tag, false);
                                }
                            }, SSKInsertSender.this);
                        }
                        catch (NotConnectedException e) {
                            next.noLongerRoutingTo(tag, false);
                        }
                    }
                }

                @Override
                public boolean shouldTimeout() {
                    return false;
                }

                @Override
                public void onTimeout() {
                    Logger.error(this, "Fatal: No Accepted/Rejected for " + SSKInsertSender.this);
                    next.fatalTimeout(tag, false);
                }

                @Override
                public void onDisconnect(PeerContext ctx) {
                    next.noLongerRoutingTo(tag, false);
                }

                @Override
                public void onRestarted(PeerContext ctx) {
                    next.noLongerRoutingTo(tag, false);
                }

                @Override
                public int getPriority() {
                    return NativeThread.NORM_PRIORITY;
                }
            }, this);
        }
        catch (DisconnectedException e) {
            next.noLongerRoutingTo(tag, false);
        }
    }

    private boolean handleRejectedOverload(Message msg, PeerNode next, InsertTag thisTag) {
        if (msg.getBoolean("isLocal")) {
            next.localRejectedOverload("ForwardRejectedOverload4", this.realTimeFlag);
            if (logMINOR) {
                Logger.minor(this, "Local RejectedOverload, moving on to next peer");
            }
            next.noLongerRoutingTo(thisTag, false);
            return true;
        }
        this.forwardRejectedOverload();
        return false;
    }

    private void handleRouteNotFound(Message msg, PeerNode next, InsertTag thisTag) {
        short newHtl;
        if (logMINOR) {
            Logger.minor(this, "Rejected: RNF");
        }
        if ((newHtl = msg.getShort("hopsToLive")) < 0) {
            newHtl = 0;
        }
        if (this.htl > newHtl) {
            this.htl = newHtl;
        }
        next.successNotOverload(this.realTimeFlag);
        next.noLongerRoutingTo(thisTag, false);
    }

    private void handleDataInsertRejected(Message msg, PeerNode next, InsertTag thisTag) {
        next.successNotOverload(this.realTimeFlag);
        short reason = msg.getShort("dataInsertRejectedReason");
        if (logMINOR) {
            Logger.minor(this, "DataInsertRejected: " + reason);
        }
        if (reason == 1 && this.fromStore) {
            Logger.error(this, "Verify failed on next node " + next + " for DataInsert but we were sending from the store!");
        }
        Logger.error(this, "SSK insert rejected! Reason=" + DMT.getDataInsertRejectedReason(reason));
        next.noLongerRoutingTo(thisTag, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DO handleSSKDataFoundHeaders(Message msg, PeerNode next, InsertTag thisTag) {
        Message dataMessage;
        Logger.normal(this, "Got collision on " + this.myKey + " (" + this.uid + ") sending to " + next.getPeer());
        this.headers = ((ShortBuffer)msg.getObject("blockHeaders")).getData();
        MessageFilter mfData = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(30000L).setType(DMT.FNPSSKDataFoundData);
        try {
            dataMessage = this.node.usm.waitFor(mfData, this);
        }
        catch (DisconnectedException e) {
            if (logMINOR) {
                Logger.minor(this, "Disconnected: " + next + " getting datareply for " + this);
            }
            next.noLongerRoutingTo(thisTag, false);
            return DO.NEXT_PEER;
        }
        if (dataMessage == null) {
            Logger.error(this, "Got headers but not data for datareply for insert from " + this);
            next.noLongerRoutingTo(thisTag, false);
            return DO.NEXT_PEER;
        }
        try {
            this.data = ((ShortBuffer)dataMessage.getObject("data")).getData();
            this.block = new SSKBlock(this.data, this.headers, this.block.getKey(), false);
            SSKInsertSender e = this;
            synchronized (e) {
                this.hasRecentlyCollided = true;
                this.hasCollided = true;
                this.notifyAll();
            }
            return DO.WAIT;
        }
        catch (SSKVerifyException e) {
            Logger.error(this, "Invalid SSK from remote on collusion: " + this + ":" + this.block);
            this.finish(3, next);
            return DO.FINISHED;
        }
    }

    @Override
    protected MessageFilter makeAcceptedRejectedFilter(PeerNode next, long acceptedTimeout, UIDTag tag) {
        long uid = tag.uid;
        MessageFilter mfAccepted = MessageFilter.create().setSource(next).setField("uid", uid).setTimeout(acceptedTimeout).setType(DMT.FNPSSKAccepted);
        MessageFilter mfRejectedLoop = MessageFilter.create().setSource(next).setField("uid", uid).setTimeout(acceptedTimeout).setType(DMT.FNPRejectedLoop);
        MessageFilter mfRejectedOverload = MessageFilter.create().setSource(next).setField("uid", uid).setTimeout(acceptedTimeout).setType(DMT.FNPRejectedOverload);
        return mfAccepted.or(mfRejectedLoop.or(mfRejectedOverload));
    }

    synchronized boolean receivedRejectedOverload() {
        return this.hasForwardedRejectedOverload;
    }

    @Override
    protected synchronized void forwardRejectedOverload() {
        if (this.hasForwardedRejectedOverload) {
            return;
        }
        this.hasForwardedRejectedOverload = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(int code, PeerNode next) {
        if (logMINOR) {
            Logger.minor(this, "Finished: " + SSKInsertSender.getStatusString(code) + " on " + this + " from " + (next == null ? "(null)" : next.shortToString()), (Throwable)new Exception("debug"));
        }
        if (next != null) {
            if (this.origTag != null) {
                next.noLongerRoutingTo(this.origTag, false);
            }
            if (this.forkedRequestTag != null) {
                next.noLongerRoutingTo(this.forkedRequestTag, false);
            }
        }
        SSKInsertSender sSKInsertSender = this;
        synchronized (sSKInsertSender) {
            if (this.status != -1 && this.status != 4) {
                throw new IllegalStateException("finish() called with " + code + " when was already " + this.status);
            }
            if (code == 1 && !this.hasForwarded) {
                code = 6;
            }
            if (this.status != 4) {
                this.status = code;
                this.notifyAll();
            }
        }
        if (code == 0 && next != null) {
            next.onSuccess(true, true);
        }
        if (logMINOR) {
            Logger.minor(this, "Set status code: " + this.getStatusString());
        }
    }

    @Override
    public synchronized int getStatus() {
        return this.status;
    }

    @Override
    public synchronized short getHTL() {
        return this.htl;
    }

    @Override
    public synchronized String getStatusString() {
        return SSKInsertSender.getStatusString(this.status);
    }

    public static String getStatusString(int status) {
        if (status == 0) {
            return "SUCCESS";
        }
        if (status == 1) {
            return "ROUTE NOT FOUND";
        }
        if (status == -1) {
            return "NOT FINISHED";
        }
        if (status == 3) {
            return "INTERNAL ERROR";
        }
        if (status == 4) {
            return "TIMED OUT";
        }
        if (status == 5) {
            return "GENERATED REJECTED OVERLOAD";
        }
        if (status == 6) {
            return "ROUTE REALLY NOT FOUND";
        }
        return "UNKNOWN STATUS CODE: " + status;
    }

    @Override
    public boolean sentRequest() {
        return this.hasForwarded;
    }

    public synchronized boolean hasRecentlyCollided() {
        boolean status = this.hasRecentlyCollided;
        this.hasRecentlyCollided = false;
        return status;
    }

    public boolean hasCollided() {
        return this.hasCollided;
    }

    public byte[] getPubkeyHash() {
        return this.headers;
    }

    public byte[] getHeaders() {
        return this.headers;
    }

    public byte[] getData() {
        return this.data;
    }

    public SSKBlock getBlock() {
        return this.block;
    }

    @Override
    public long getUID() {
        return this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sentBytes(int x) {
        Object object = this.totalBytesSync;
        synchronized (object) {
            this.totalBytesSent += x;
        }
        this.node.nodeStats.insertSentBytes(true, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalSentBytes() {
        Object object = this.totalBytesSync;
        synchronized (object) {
            return this.totalBytesSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedBytes(int x) {
        Object object = this.totalBytesSync;
        synchronized (object) {
            this.totalBytesReceived += x;
        }
        this.node.nodeStats.insertReceivedBytes(true, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalReceivedBytes() {
        Object object = this.totalBytesSync;
        synchronized (object) {
            return this.totalBytesReceived;
        }
    }

    @Override
    public void sentPayload(int x) {
        this.node.sentPayload(x);
        this.node.nodeStats.insertSentBytes(true, -x);
    }

    @Override
    public int getPriority() {
        return NativeThread.HIGH_PRIORITY;
    }

    public String toString() {
        return "SSKInsertSender:" + this.myKey + ":" + this.uid;
    }

    public PeerNode[] getRoutedTo() {
        return this.nodesRoutedTo.toArray(new PeerNode[this.nodesRoutedTo.size()]);
    }

    @Override
    protected Message createDataRequest() {
        Message request = DMT.createFNPSSKInsertRequestNew(this.uid, this.htl, this.myKey);
        if (!this.forkOnCacheable) {
            request.addSubMessage(DMT.createFNPSubInsertForkControl(this.forkOnCacheable));
        }
        if (this.ignoreLowBackoff) {
            request.addSubMessage(DMT.createFNPSubInsertIgnoreLowBackoff(this.ignoreLowBackoff));
        }
        if (this.preferInsert) {
            request.addSubMessage(DMT.createFNPSubInsertPreferInsert(this.preferInsert));
        }
        request.addSubMessage(DMT.createFNPRealTimeFlag(this.realTimeFlag));
        return request;
    }

    @Override
    protected long getAcceptedTimeout() {
        return ACCEPTED_TIMEOUT;
    }

    @Override
    protected void timedOutWhileWaiting(double load) {
        this.htl = (short)(this.htl - (short)Math.max(0, this.hopsForFatalTimeoutWaitingForPeer()));
        if (this.htl < 0) {
            this.htl = 0;
        }
        if (!this.hasForwarded) {
            this.origTag.setNotRoutedOnwards();
        }
        this.finish(1, null);
    }

    @Override
    protected boolean isAccepted(Message msg) {
        if (msg.getSpec() == DMT.FNPSSKAccepted) {
            this.needPubKey = msg.getBoolean("needPubKey");
            return true;
        }
        return false;
    }

    @Override
    protected void onAccepted(PeerNode next) {
        DO action;
        if (logMINOR) {
            Logger.minor(this, "Got Accepted on " + this);
        }
        InsertTag thisTag = this.forkedRequestTag;
        if (this.forkedRequestTag == null) {
            thisTag = this.origTag;
        }
        Message headersMsg = DMT.createFNPSSKInsertRequestHeaders(this.uid, this.headers, this.realTimeFlag);
        Message dataMsg = DMT.createFNPSSKInsertRequestData(this.uid, this.data, this.realTimeFlag);
        try {
            next.sendAsync(headersMsg, null, this);
            next.sendSync(dataMsg, this, this.realTimeFlag);
            this.sentPayload(this.data.length);
        }
        catch (NotConnectedException e1) {
            if (logMINOR) {
                Logger.minor(this, "Not connected to " + next);
            }
            next.noLongerRoutingTo(thisTag, false);
            this.routeRequests();
            return;
        }
        catch (SyncSendWaitedTooLongException e) {
            Logger.error(this, "Waited too long to send " + dataMsg + " to " + next + " on " + this);
            next.noLongerRoutingTo(thisTag, false);
            this.routeRequests();
            return;
        }
        if (this.needPubKey) {
            Message newAck;
            Message pkMsg = DMT.createFNPSSKPubKey(this.uid, this.pubKey, this.realTimeFlag);
            try {
                next.sendSync(pkMsg, this, this.realTimeFlag);
            }
            catch (NotConnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Node disconnected while sending pubkey: " + next);
                }
                next.noLongerRoutingTo(thisTag, false);
                this.routeRequests();
                return;
            }
            catch (SyncSendWaitedTooLongException e) {
                Logger.warning(this, "Took too long to send pubkey to " + next + " on " + this);
                next.noLongerRoutingTo(thisTag, false);
                this.routeRequests();
                return;
            }
            MessageFilter mf1 = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(ACCEPTED_TIMEOUT * 2L).setType(DMT.FNPSSKPubKeyAccepted);
            try {
                newAck = this.node.usm.waitFor(mf1, this);
            }
            catch (DisconnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Disconnected from " + next);
                }
                next.noLongerRoutingTo(thisTag, false);
                this.routeRequests();
                return;
            }
            if (newAck == null) {
                this.handleNoPubkeyAccepted(next, thisTag);
                this.routeRequests();
                return;
            }
        }
        MessageFilter mf = this.makeSearchFilter(next, this.calculateTimeout(this.htl));
        do {
            Message msg;
            try {
                msg = this.node.usm.waitFor(mf, this);
            }
            catch (DisconnectedException e) {
                Logger.normal(this, "Disconnected from " + next + " while waiting for InsertReply on " + this);
                next.noLongerRoutingTo(thisTag, false);
                break;
            }
            if (msg == null) {
                Logger.warning(this, "Timeout waiting for reply after Accepted in " + this + " from " + next);
                next.localRejectedOverload("AfterInsertAcceptedTimeout", this.realTimeFlag);
                this.forwardRejectedOverload();
                this.finish(4, next);
                do {
                    try {
                        msg = this.node.usm.waitFor(mf, this);
                    }
                    catch (DisconnectedException e) {
                        Logger.normal(this, "Disconnected from " + next + " while waiting for InsertReply on " + this);
                        next.noLongerRoutingTo(thisTag, false);
                        return;
                    }
                    if (msg == null) {
                        Logger.error(this, "Fatal timeout waiting for reply after Accepted on " + this + " from " + next);
                        next.fatalTimeout(thisTag, false);
                        return;
                    }
                    action = this.handleMessage(msg, next, thisTag);
                    if (action != DO.FINISHED) continue;
                    return;
                } while (action != DO.NEXT_PEER);
                next.noLongerRoutingTo(thisTag, false);
                return;
            }
            action = this.handleMessage(msg, next, thisTag);
            if (action != DO.FINISHED) continue;
            return;
        } while (action != DO.NEXT_PEER);
        this.routeRequests();
    }

    @Override
    protected boolean isInsert() {
        return true;
    }

    @Override
    protected PeerNode sourceForRouting() {
        if (this.forkedRequestTag != null) {
            return null;
        }
        return this.source;
    }

    @Override
    protected long ignoreLowBackoff() {
        return this.ignoreLowBackoff ? Node.LOW_BACKOFF : 0L;
    }

    static {
        Logger.registerClass(SSKInsertSender.class);
        TIMEOUT_AFTER_ACCEPTEDREJECTED_TIMEOUT = TimeUnit.SECONDS.toMillis(60L);
    }

    private static enum DO {
        FINISHED,
        WAIT,
        NEXT_PEER;

    }
}

