/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.client.async.ClientContext;
import freenet.support.api.Bucket;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.ByteArrayRandomAccessBuffer;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class SimpleReadOnlyArrayBucket
implements Bucket,
RandomAccessBucket {
    private static final long serialVersionUID = 1L;
    final byte[] buf;
    final int offset;
    final int length;

    public SimpleReadOnlyArrayBucket(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.offset = offset;
        this.length = length;
    }

    public SimpleReadOnlyArrayBucket(byte[] buf) {
        this(buf, 0, buf.length);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Read only");
    }

    @Override
    public OutputStream getOutputStreamUnbuffered() throws IOException {
        throw new IOException("Read only");
    }

    @Override
    public InputStream getInputStreamUnbuffered() throws IOException {
        return new ByteArrayInputStream(this.buf, this.offset, this.length);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getInputStreamUnbuffered();
    }

    @Override
    public String getName() {
        return "SimpleReadOnlyArrayBucket: len=" + this.length + ' ' + super.toString();
    }

    @Override
    public long size() {
        return this.length;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void setReadOnly() {
    }

    @Override
    public void free() {
    }

    @Override
    public RandomAccessBucket createShadow() {
        if (this.buf.length < 262144) {
            return new SimpleReadOnlyArrayBucket(Arrays.copyOfRange(this.buf, this.offset, this.offset + this.length));
        }
        return null;
    }

    @Override
    public void onResume(ClientContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeTo(DataOutputStream dos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LockableRandomAccessBuffer toRandomAccessBuffer() throws IOException {
        ByteArrayRandomAccessBuffer raf = new ByteArrayRandomAccessBuffer(this.buf, this.offset, this.length, true);
        raf.setReadOnly();
        return raf;
    }
}

