/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Compression.LZMA;

import SevenZip.Compression.LZ.BinTree;
import SevenZip.Compression.LZMA.Base;
import SevenZip.Compression.RangeCoder.BitTreeEncoder;
import SevenZip.ICodeProgress;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Encoder {
    public static final int EMatchFinderTypeBT2 = 0;
    public static final int EMatchFinderTypeBT4 = 1;
    static final int kIfinityPrice = 0xFFFFFFF;
    static byte[] g_FastPos = new byte[2048];
    int _state = Base.StateInit();
    byte _previousByte;
    int[] _repDistances = new int[4];
    static final int kDefaultDictionaryLogSize = 22;
    static final int kNumFastBytesDefault = 32;
    public static final int kNumLenSpecSymbols = 16;
    static final int kNumOpts = 4096;
    Optimal[] _optimum = new Optimal[4096];
    BinTree _matchFinder = null;
    SevenZip.Compression.RangeCoder.Encoder _rangeEncoder = new SevenZip.Compression.RangeCoder.Encoder();
    short[] _isMatch = new short[192];
    short[] _isRep = new short[12];
    short[] _isRepG0 = new short[12];
    short[] _isRepG1 = new short[12];
    short[] _isRepG2 = new short[12];
    short[] _isRep0Long = new short[192];
    BitTreeEncoder[] _posSlotEncoder = new BitTreeEncoder[4];
    short[] _posEncoders = new short[114];
    BitTreeEncoder _posAlignEncoder = new BitTreeEncoder(4);
    LenPriceTableEncoder _lenEncoder = new LenPriceTableEncoder();
    LenPriceTableEncoder _repMatchLenEncoder = new LenPriceTableEncoder();
    LiteralEncoder _literalEncoder = new LiteralEncoder();
    int[] _matchDistances = new int[548];
    int _numFastBytes = 32;
    int _longestMatchLength;
    int _numDistancePairs;
    int _additionalOffset;
    int _optimumEndIndex;
    int _optimumCurrentIndex;
    boolean _longestMatchWasFound;
    int[] _posSlotPrices = new int[256];
    int[] _distancesPrices = new int[512];
    int[] _alignPrices = new int[16];
    int _alignPriceCount;
    int _distTableSize = 44;
    int _posStateBits = 2;
    int _posStateMask = 3;
    int _numLiteralPosStateBits = 0;
    int _numLiteralContextBits = 3;
    int _dictionarySize = 0x400000;
    int _dictionarySizePrev = -1;
    int _numFastBytesPrev = -1;
    long nowPos64;
    boolean _finished;
    InputStream _inStream;
    int _matchFinderType = 1;
    boolean _writeEndMark = false;
    boolean _needReleaseMFStream = false;
    int[] reps = new int[4];
    int[] repLens = new int[4];
    int backRes;
    long[] processedInSize = new long[1];
    long[] processedOutSize = new long[1];
    boolean[] finished = new boolean[1];
    public static final int kPropSize = 5;
    byte[] properties = new byte[5];
    int[] tempPrices = new int[128];
    int _matchPriceCount;

    static int GetPosSlot(int n) {
        if (n < 2048) {
            return g_FastPos[n];
        }
        if (n < 0x200000) {
            return g_FastPos[n >> 10] + 20;
        }
        return g_FastPos[n >> 20] + 40;
    }

    static int GetPosSlot2(int n) {
        if (n < 131072) {
            return g_FastPos[n >> 6] + 12;
        }
        if (n < 0x8000000) {
            return g_FastPos[n >> 16] + 32;
        }
        return g_FastPos[n >> 26] + 52;
    }

    void BaseInit() {
        this._state = Base.StateInit();
        this._previousByte = 0;
        for (int i = 0; i < 4; ++i) {
            this._repDistances[i] = 0;
        }
    }

    void Create() {
        if (this._matchFinder == null) {
            BinTree binTree = new BinTree();
            int n = 4;
            if (this._matchFinderType == 0) {
                n = 2;
            }
            binTree.SetType(n);
            this._matchFinder = binTree;
        }
        this._literalEncoder.Create(this._numLiteralPosStateBits, this._numLiteralContextBits);
        if (this._dictionarySize == this._dictionarySizePrev && this._numFastBytesPrev == this._numFastBytes) {
            return;
        }
        this._matchFinder.Create(this._dictionarySize, 4096, this._numFastBytes, 274);
        this._dictionarySizePrev = this._dictionarySize;
        this._numFastBytesPrev = this._numFastBytes;
    }

    public Encoder() {
        int n;
        for (n = 0; n < 4096; ++n) {
            this._optimum[n] = new Optimal();
        }
        for (n = 0; n < 4; ++n) {
            this._posSlotEncoder[n] = new BitTreeEncoder(6);
        }
    }

    void SetWriteEndMarkerMode(boolean bl) {
        this._writeEndMark = bl;
    }

    void Init() {
        this.BaseInit();
        this._rangeEncoder.Init();
        SevenZip.Compression.RangeCoder.Encoder.InitBitModels(this._isMatch);
        SevenZip.Compression.RangeCoder.Encoder.InitBitModels(this._isRep0Long);
        SevenZip.Compression.RangeCoder.Encoder.InitBitModels(this._isRep);
        SevenZip.Compression.RangeCoder.Encoder.InitBitModels(this._isRepG0);
        SevenZip.Compression.RangeCoder.Encoder.InitBitModels(this._isRepG1);
        SevenZip.Compression.RangeCoder.Encoder.InitBitModels(this._isRepG2);
        SevenZip.Compression.RangeCoder.Encoder.InitBitModels(this._posEncoders);
        this._literalEncoder.Init();
        for (int i = 0; i < 4; ++i) {
            this._posSlotEncoder[i].Init();
        }
        this._lenEncoder.Init(1 << this._posStateBits);
        this._repMatchLenEncoder.Init(1 << this._posStateBits);
        this._posAlignEncoder.Init();
        this._longestMatchWasFound = false;
        this._optimumEndIndex = 0;
        this._optimumCurrentIndex = 0;
        this._additionalOffset = 0;
    }

    int ReadMatchDistances() throws IOException {
        int n = 0;
        this._numDistancePairs = this._matchFinder.GetMatches(this._matchDistances);
        if (this._numDistancePairs > 0 && (n = this._matchDistances[this._numDistancePairs - 2]) == this._numFastBytes) {
            n += this._matchFinder.GetMatchLen(n - 1, this._matchDistances[this._numDistancePairs - 1], 273 - n);
        }
        ++this._additionalOffset;
        return n;
    }

    void MovePos(int n) throws IOException {
        if (n > 0) {
            this._matchFinder.Skip(n);
            this._additionalOffset += n;
        }
    }

    int GetRepLen1Price(int n, int n2) {
        return SevenZip.Compression.RangeCoder.Encoder.GetPrice0(this._isRepG0[n]) + SevenZip.Compression.RangeCoder.Encoder.GetPrice0(this._isRep0Long[(n << 4) + n2]);
    }

    int GetPureRepPrice(int n, int n2, int n3) {
        int n4;
        if (n == 0) {
            n4 = SevenZip.Compression.RangeCoder.Encoder.GetPrice0(this._isRepG0[n2]);
            n4 += SevenZip.Compression.RangeCoder.Encoder.GetPrice1(this._isRep0Long[(n2 << 4) + n3]);
        } else {
            n4 = SevenZip.Compression.RangeCoder.Encoder.GetPrice1(this._isRepG0[n2]);
            if (n == 1) {
                n4 += SevenZip.Compression.RangeCoder.Encoder.GetPrice0(this._isRepG1[n2]);
            } else {
                n4 += SevenZip.Compression.RangeCoder.Encoder.GetPrice1(this._isRepG1[n2]);
                n4 += SevenZip.Compression.RangeCoder.Encoder.GetPrice(this._isRepG2[n2], n - 2);
            }
        }
        return n4;
    }

    int GetRepPrice(int n, int n2, int n3, int n4) {
        int n5 = this._repMatchLenEncoder.GetPrice(n2 - 2, n4);
        return n5 + this.GetPureRepPrice(n, n3, n4);
    }

    int GetPosLenPrice(int n, int n2, int n3) {
        int n4 = Base.GetLenToPosState(n2);
        int n5 = n < 128 ? this._distancesPrices[n4 * 128 + n] : this._posSlotPrices[(n4 << 6) + Encoder.GetPosSlot2(n)] + this._alignPrices[n & 0xF];
        return n5 + this._lenEncoder.GetPrice(n2 - 2, n3);
    }

    int Backward(int n) {
        int n2;
        this._optimumEndIndex = n;
        int n3 = this._optimum[n].PosPrev;
        int n4 = this._optimum[n].BackPrev;
        do {
            if (this._optimum[n].Prev1IsChar) {
                this._optimum[n3].MakeAsChar();
                this._optimum[n3].PosPrev = n3 - 1;
                if (this._optimum[n].Prev2) {
                    this._optimum[n3 - 1].Prev1IsChar = false;
                    this._optimum[n3 - 1].PosPrev = this._optimum[n].PosPrev2;
                    this._optimum[n3 - 1].BackPrev = this._optimum[n].BackPrev2;
                }
            }
            n2 = n3;
            int n5 = n4;
            n4 = this._optimum[n2].BackPrev;
            n3 = this._optimum[n2].PosPrev;
            this._optimum[n2].BackPrev = n5;
            this._optimum[n2].PosPrev = n;
        } while ((n = n2) > 0);
        this.backRes = this._optimum[0].BackPrev;
        this._optimumCurrentIndex = this._optimum[0].PosPrev;
        return this._optimumCurrentIndex;
    }

    /*
     * Unable to fully structure code
     */
    int GetOptimum(int var1_1) throws IOException {
        if (this._optimumEndIndex != this._optimumCurrentIndex) {
            var2_2 = this._optimum[this._optimumCurrentIndex].PosPrev - this._optimumCurrentIndex;
            this.backRes = this._optimum[this._optimumCurrentIndex].BackPrev;
            this._optimumCurrentIndex = this._optimum[this._optimumCurrentIndex].PosPrev;
            return var2_2;
        }
        this._optimumEndIndex = 0;
        this._optimumCurrentIndex = 0;
        if (!this._longestMatchWasFound) {
            var2_3 = this.ReadMatchDistances();
        } else {
            var2_3 = this._longestMatchLength;
            this._longestMatchWasFound = false;
        }
        var3_4 = this._numDistancePairs;
        var4_5 = this._matchFinder.GetNumAvailableBytes() + 1;
        if (var4_5 < 2) {
            this.backRes = -1;
            return 1;
        }
        if (var4_5 > 273) {
            var4_5 = 273;
        }
        var5_6 = 0;
        for (var6_7 = 0; var6_7 < 4; ++var6_7) {
            this.reps[var6_7] = this._repDistances[var6_7];
            this.repLens[var6_7] = this._matchFinder.GetMatchLen(-1, this.reps[var6_7], 273);
            if (this.repLens[var6_7] <= this.repLens[var5_6]) continue;
            var5_6 = var6_7;
        }
        if (this.repLens[var5_6] >= this._numFastBytes) {
            this.backRes = var5_6;
            var7_8 = this.repLens[var5_6];
            this.MovePos(var7_8 - 1);
            return var7_8;
        }
        if (var2_3 >= this._numFastBytes) {
            this.backRes = this._matchDistances[var3_4 - 1] + 4;
            this.MovePos(var2_3 - 1);
            return var2_3;
        }
        var7_9 = this._matchFinder.GetIndexByte(-1);
        var8_10 = this._matchFinder.GetIndexByte(0 - this._repDistances[0] - 1 - 1);
        if (var2_3 < 2 && var7_9 != var8_10 && this.repLens[var5_6] < 2) {
            this.backRes = -1;
            return 1;
        }
        this._optimum[0].State = this._state;
        var9_11 = var1_1 & this._posStateMask;
        this._optimum[1].Price = SevenZip.Compression.RangeCoder.Encoder.GetPrice0(this._isMatch[(this._state << 4) + var9_11]) + this._literalEncoder.GetSubCoder(var1_1, this._previousByte).GetPrice(Base.StateIsCharState(this._state) == false, var8_10, var7_9);
        this._optimum[1].MakeAsChar();
        var10_12 = SevenZip.Compression.RangeCoder.Encoder.GetPrice1(this._isMatch[(this._state << 4) + var9_11]);
        var11_13 = var10_12 + SevenZip.Compression.RangeCoder.Encoder.GetPrice1(this._isRep[this._state]);
        if (var8_10 == var7_9 && (var12_14 = var11_13 + this.GetRepLen1Price(this._state, var9_11)) < this._optimum[1].Price) {
            this._optimum[1].Price = var12_14;
            this._optimum[1].MakeAsShortRep();
        }
        v0 = var12_14 = var2_3 >= this.repLens[var5_6] ? var2_3 : this.repLens[var5_6];
        if (var12_14 < 2) {
            this.backRes = this._optimum[1].BackPrev;
            return 1;
        }
        this._optimum[1].PosPrev = 0;
        this._optimum[0].Backs0 = this.reps[0];
        this._optimum[0].Backs1 = this.reps[1];
        this._optimum[0].Backs2 = this.reps[2];
        this._optimum[0].Backs3 = this.reps[3];
        var13_15 = var12_14;
        do {
            this._optimum[var13_15--].Price = 0xFFFFFFF;
        } while (var13_15 >= 2);
        for (var6_7 = 0; var6_7 < 4; ++var6_7) {
            var14_16 = this.repLens[var6_7];
            if (var14_16 < 2) continue;
            var15_17 = var11_13 + this.GetPureRepPrice(var6_7, this._state, var9_11);
            do {
                var16_18 = var15_17 + this._repMatchLenEncoder.GetPrice(var14_16 - 2, var9_11);
                var17_19 = this._optimum[var14_16];
                if (var16_18 >= var17_19.Price) continue;
                var17_19.Price = var16_18;
                var17_19.PosPrev = 0;
                var17_19.BackPrev = var6_7;
                var17_19.Prev1IsChar = false;
            } while (--var14_16 >= 2);
        }
        var14_16 = var10_12 + SevenZip.Compression.RangeCoder.Encoder.GetPrice0(this._isRep[this._state]);
        v1 = var13_15 = this.repLens[0] >= 2 ? this.repLens[0] + 1 : 2;
        if (var13_15 <= var2_3) {
            var15_17 = 0;
            while (var13_15 > this._matchDistances[var15_17]) {
                var15_17 += 2;
            }
            while (true) {
                var16_18 = this._matchDistances[var15_17 + 1];
                var17_20 = var14_16 + this.GetPosLenPrice(var16_18, var13_15, var9_11);
                var18_22 = this._optimum[var13_15];
                if (var17_20 < var18_22.Price) {
                    var18_22.Price = var17_20;
                    var18_22.PosPrev = 0;
                    var18_22.BackPrev = var16_18 + 4;
                    var18_22.Prev1IsChar = false;
                }
                if (var13_15 == this._matchDistances[var15_17] && (var15_17 += 2) == var3_4) break;
                ++var13_15;
            }
        }
        var15_17 = 0;
        block6: while (true) {
            if (++var15_17 == var12_14) {
                return this.Backward(var15_17);
            }
            var16_18 = this.ReadMatchDistances();
            var3_4 = this._numDistancePairs;
            if (var16_18 >= this._numFastBytes) {
                this._longestMatchLength = var16_18;
                this._longestMatchWasFound = true;
                return this.Backward(var15_17);
            }
            ++var1_1;
            var17_21 = this._optimum[var15_17].PosPrev;
            if (this._optimum[var15_17].Prev1IsChar) {
                --var17_21;
                if (this._optimum[var15_17].Prev2) {
                    var18_23 = this._optimum[this._optimum[var15_17].PosPrev2].State;
                    var18_23 = this._optimum[var15_17].BackPrev2 < 4 ? Base.StateUpdateRep(var18_23) : Base.StateUpdateMatch(var18_23);
                } else {
                    var18_23 = this._optimum[var17_21].State;
                }
                var18_23 = Base.StateUpdateChar(var18_23);
            } else {
                var18_23 = this._optimum[var17_21].State;
            }
            if (var17_21 == var15_17 - 1) {
                var18_23 = this._optimum[var15_17].IsShortRep() ? Base.StateUpdateShortRep(var18_23) : Base.StateUpdateChar(var18_23);
            } else {
                if (this._optimum[var15_17].Prev1IsChar && this._optimum[var15_17].Prev2) {
                    var17_21 = this._optimum[var15_17].PosPrev2;
                    var19_24 = this._optimum[var15_17].BackPrev2;
                    var18_23 = Base.StateUpdateRep(var18_23);
                } else {
                    var19_24 = this._optimum[var15_17].BackPrev;
                    var18_23 = var19_24 < 4 ? Base.StateUpdateRep(var18_23) : Base.StateUpdateMatch(var18_23);
                }
                var20_26 = this._optimum[var17_21];
                if (var19_24 < 4) {
                    if (var19_24 == 0) {
                        this.reps[0] = var20_26.Backs0;
                        this.reps[1] = var20_26.Backs1;
                        this.reps[2] = var20_26.Backs2;
                        this.reps[3] = var20_26.Backs3;
                    } else if (var19_24 == 1) {
                        this.reps[0] = var20_26.Backs1;
                        this.reps[1] = var20_26.Backs0;
                        this.reps[2] = var20_26.Backs2;
                        this.reps[3] = var20_26.Backs3;
                    } else if (var19_24 == 2) {
                        this.reps[0] = var20_26.Backs2;
                        this.reps[1] = var20_26.Backs0;
                        this.reps[2] = var20_26.Backs1;
                        this.reps[3] = var20_26.Backs3;
                    } else {
                        this.reps[0] = var20_26.Backs3;
                        this.reps[1] = var20_26.Backs0;
                        this.reps[2] = var20_26.Backs1;
                        this.reps[3] = var20_26.Backs2;
                    }
                } else {
                    this.reps[0] = var19_24 - 4;
                    this.reps[1] = var20_26.Backs0;
                    this.reps[2] = var20_26.Backs1;
                    this.reps[3] = var20_26.Backs2;
                }
            }
            this._optimum[var15_17].State = var18_23;
            this._optimum[var15_17].Backs0 = this.reps[0];
            this._optimum[var15_17].Backs1 = this.reps[1];
            this._optimum[var15_17].Backs2 = this.reps[2];
            this._optimum[var15_17].Backs3 = this.reps[3];
            var19_24 = this._optimum[var15_17].Price;
            var7_9 = this._matchFinder.GetIndexByte(-1);
            var8_10 = this._matchFinder.GetIndexByte(0 - this.reps[0] - 1 - 1);
            var9_11 = var1_1 & this._posStateMask;
            var20_25 = var19_24 + SevenZip.Compression.RangeCoder.Encoder.GetPrice0(this._isMatch[(var18_23 << 4) + var9_11]) + this._literalEncoder.GetSubCoder(var1_1, this._matchFinder.GetIndexByte(-2)).GetPrice(Base.StateIsCharState(var18_23) == false, var8_10, var7_9);
            var21_27 = this._optimum[var15_17 + 1];
            var22_28 = false;
            if (var20_25 < var21_27.Price) {
                var21_27.Price = var20_25;
                var21_27.PosPrev = var15_17;
                var21_27.MakeAsChar();
                var22_28 = true;
            }
            var10_12 = var19_24 + SevenZip.Compression.RangeCoder.Encoder.GetPrice1(this._isMatch[(var18_23 << 4) + var9_11]);
            var11_13 = var10_12 + SevenZip.Compression.RangeCoder.Encoder.GetPrice1(this._isRep[var18_23]);
            if (var8_10 == var7_9 && (var21_27.PosPrev >= var15_17 || var21_27.BackPrev != 0) && (var23_29 = var11_13 + this.GetRepLen1Price(var18_23, var9_11)) <= var21_27.Price) {
                var21_27.Price = var23_29;
                var21_27.PosPrev = var15_17;
                var21_27.MakeAsShortRep();
                var22_28 = true;
            }
            var23_29 = this._matchFinder.GetNumAvailableBytes() + 1;
            var4_5 = var23_29 = Math.min(4095 - var15_17, var23_29);
            if (var4_5 < 2) continue;
            if (var4_5 > this._numFastBytes) {
                var4_5 = this._numFastBytes;
            }
            if (!var22_28 && var8_10 != var7_9 && (var25_31 = this._matchFinder.GetMatchLen(0, this.reps[0], var24_30 = Math.min(var23_29 - 1, this._numFastBytes))) >= 2) {
                var26_32 = Base.StateUpdateChar(var18_23);
                var27_33 = var1_1 + 1 & this._posStateMask;
                var28_34 = var20_25 + SevenZip.Compression.RangeCoder.Encoder.GetPrice1(this._isMatch[(var26_32 << 4) + var27_33]) + SevenZip.Compression.RangeCoder.Encoder.GetPrice1(this._isRep[var26_32]);
                var29_35 = var15_17 + 1 + var25_31;
                while (var12_14 < var29_35) {
                    this._optimum[++var12_14].Price = 0xFFFFFFF;
                }
                var30_39 = var28_34 + this.GetRepPrice(0, var25_31, var26_32, var27_33);
                var31_40 = this._optimum[var29_35];
                if (var30_39 < var31_40.Price) {
                    var31_40.Price = var30_39;
                    var31_40.PosPrev = var15_17 + 1;
                    var31_40.BackPrev = 0;
                    var31_40.Prev1IsChar = true;
                    var31_40.Prev2 = false;
                }
            }
            var24_30 = 2;
            for (var25_31 = 0; var25_31 < 4; ++var25_31) {
                var26_32 = this._matchFinder.GetMatchLen(-1, this.reps[var25_31], var4_5);
                if (var26_32 < 2) continue;
                var27_33 = var26_32;
                while (true) {
                    if (var12_14 < var15_17 + var26_32) {
                        this._optimum[++var12_14].Price = 0xFFFFFFF;
                        continue;
                    }
                    var28_34 = var11_13 + this.GetRepPrice(var25_31, var26_32, var18_23, var9_11);
                    var29_36 = this._optimum[var15_17 + var26_32];
                    if (var28_34 < var29_36.Price) {
                        var29_36.Price = var28_34;
                        var29_36.PosPrev = var15_17;
                        var29_36.BackPrev = var25_31;
                        var29_36.Prev1IsChar = false;
                    }
                    if (--var26_32 < 2) break;
                }
                var26_32 = var27_33;
                if (var25_31 == 0) {
                    var24_30 = var26_32 + 1;
                }
                if (var26_32 >= var23_29 || (var29_37 = this._matchFinder.GetMatchLen(var26_32, this.reps[var25_31], var28_34 = Math.min(var23_29 - 1 - var26_32, this._numFastBytes))) < 2) continue;
                var30_39 = Base.StateUpdateRep(var18_23);
                var31_41 = var1_1 + var26_32 & this._posStateMask;
                var32_43 = var11_13 + this.GetRepPrice(var25_31, var26_32, var18_23, var9_11) + SevenZip.Compression.RangeCoder.Encoder.GetPrice0(this._isMatch[(var30_39 << 4) + var31_41]) + this._literalEncoder.GetSubCoder(var1_1 + var26_32, this._matchFinder.GetIndexByte(var26_32 - 1 - 1)).GetPrice(true, this._matchFinder.GetIndexByte(var26_32 - 1 - (this.reps[var25_31] + 1)), this._matchFinder.GetIndexByte(var26_32 - 1));
                var30_39 = Base.StateUpdateChar(var30_39);
                var31_41 = var1_1 + var26_32 + 1 & this._posStateMask;
                var33_44 = var32_43 + SevenZip.Compression.RangeCoder.Encoder.GetPrice1(this._isMatch[(var30_39 << 4) + var31_41]);
                var34_45 = var33_44 + SevenZip.Compression.RangeCoder.Encoder.GetPrice1(this._isRep[var30_39]);
                var35_46 = var26_32 + 1 + var29_37;
                while (var12_14 < var15_17 + var35_46) {
                    this._optimum[++var12_14].Price = 0xFFFFFFF;
                }
                var36_47 = var34_45 + this.GetRepPrice(0, var29_37, var30_39, var31_41);
                var37_48 = this._optimum[var15_17 + var35_46];
                if (var36_47 >= var37_48.Price) continue;
                var37_48.Price = var36_47;
                var37_48.PosPrev = var15_17 + var26_32 + 1;
                var37_48.BackPrev = 0;
                var37_48.Prev1IsChar = true;
                var37_48.Prev2 = true;
                var37_48.PosPrev2 = var15_17;
                var37_48.BackPrev2 = var25_31;
            }
            if (var16_18 > var4_5) {
                var16_18 = var4_5;
                var3_4 = 0;
                while (var16_18 > this._matchDistances[var3_4]) {
                    var3_4 += 2;
                }
                this._matchDistances[var3_4] = var16_18;
                var3_4 += 2;
            }
            if (var16_18 < var24_30) continue;
            var14_16 = var10_12 + SevenZip.Compression.RangeCoder.Encoder.GetPrice0(this._isRep[var18_23]);
            while (var12_14 < var15_17 + var16_18) {
                this._optimum[++var12_14].Price = 0xFFFFFFF;
            }
            var25_31 = 0;
            while (var24_30 > this._matchDistances[var25_31]) {
                var25_31 += 2;
            }
            var26_32 = var24_30;
            while (true) {
                var27_33 = this._matchDistances[var25_31 + 1];
                var28_34 = var14_16 + this.GetPosLenPrice(var27_33, var26_32, var9_11);
                var29_38 = this._optimum[var15_17 + var26_32];
                if (var28_34 < var29_38.Price) {
                    var29_38.Price = var28_34;
                    var29_38.PosPrev = var15_17;
                    var29_38.BackPrev = var27_33 + 4;
                    var29_38.Prev1IsChar = false;
                }
                if (var26_32 == this._matchDistances[var25_31]) {
                    if (var26_32 < var23_29 && (var31_42 = this._matchFinder.GetMatchLen(var26_32, var27_33, var30_39 = Math.min(var23_29 - 1 - var26_32, this._numFastBytes))) >= 2) {
                        var32_43 = Base.StateUpdateMatch(var18_23);
                        var33_44 = var1_1 + var26_32 & this._posStateMask;
                        var34_45 = var28_34 + SevenZip.Compression.RangeCoder.Encoder.GetPrice0(this._isMatch[(var32_43 << 4) + var33_44]) + this._literalEncoder.GetSubCoder(var1_1 + var26_32, this._matchFinder.GetIndexByte(var26_32 - 1 - 1)).GetPrice(true, this._matchFinder.GetIndexByte(var26_32 - (var27_33 + 1) - 1), this._matchFinder.GetIndexByte(var26_32 - 1));
                        var32_43 = Base.StateUpdateChar(var32_43);
                        var33_44 = var1_1 + var26_32 + 1 & this._posStateMask;
                        var35_46 = var34_45 + SevenZip.Compression.RangeCoder.Encoder.GetPrice1(this._isMatch[(var32_43 << 4) + var33_44]);
                        var36_47 = var35_46 + SevenZip.Compression.RangeCoder.Encoder.GetPrice1(this._isRep[var32_43]);
                        var37_49 = var26_32 + 1 + var31_42;
                        while (var12_14 < var15_17 + var37_49) {
                            this._optimum[++var12_14].Price = 0xFFFFFFF;
                        }
                        var28_34 = var36_47 + this.GetRepPrice(0, var31_42, var32_43, var33_44);
                        var29_38 = this._optimum[var15_17 + var37_49];
                        if (var28_34 < var29_38.Price) {
                            var29_38.Price = var28_34;
                            var29_38.PosPrev = var15_17 + var26_32 + 1;
                            var29_38.BackPrev = 0;
                            var29_38.Prev1IsChar = true;
                            var29_38.Prev2 = true;
                            var29_38.PosPrev2 = var15_17;
                            var29_38.BackPrev2 = var27_33 + 4;
                        }
                    }
                    if ((var25_31 += 2) != var3_4) ** break;
                    continue block6;
                }
                ++var26_32;
            }
            break;
        }
    }

    boolean ChangePair(int n, int n2) {
        int n3 = 7;
        return n < 1 << 32 - n3 && n2 >= n << n3;
    }

    void WriteEndMarker(int n) throws IOException {
        if (!this._writeEndMark) {
            return;
        }
        this._rangeEncoder.Encode(this._isMatch, (this._state << 4) + n, 1);
        this._rangeEncoder.Encode(this._isRep, this._state, 0);
        this._state = Base.StateUpdateMatch(this._state);
        int n2 = 2;
        this._lenEncoder.Encode(this._rangeEncoder, n2 - 2, n);
        int n3 = 63;
        int n4 = Base.GetLenToPosState(n2);
        this._posSlotEncoder[n4].Encode(this._rangeEncoder, n3);
        int n5 = 30;
        int n6 = (1 << n5) - 1;
        this._rangeEncoder.EncodeDirectBits(n6 >> 4, n5 - 4);
        this._posAlignEncoder.ReverseEncode(this._rangeEncoder, n6 & 0xF);
    }

    void Flush(int n) throws IOException {
        this.ReleaseMFStream();
        this.WriteEndMarker(n & this._posStateMask);
        this._rangeEncoder.FlushData();
        this._rangeEncoder.FlushStream();
    }

    public void CodeOneBlock(long[] lArray, long[] lArray2, boolean[] blArray) throws IOException {
        int n;
        int n2;
        lArray[0] = 0L;
        lArray2[0] = 0L;
        blArray[0] = true;
        if (this._inStream != null) {
            this._matchFinder.SetStream(this._inStream);
            this._matchFinder.Init();
            this._needReleaseMFStream = true;
            this._inStream = null;
        }
        if (this._finished) {
            return;
        }
        this._finished = true;
        long l = this.nowPos64;
        if (this.nowPos64 == 0L) {
            if (this._matchFinder.GetNumAvailableBytes() == 0) {
                this.Flush((int)this.nowPos64);
                return;
            }
            this.ReadMatchDistances();
            n2 = (int)this.nowPos64 & this._posStateMask;
            this._rangeEncoder.Encode(this._isMatch, (this._state << 4) + n2, 0);
            this._state = Base.StateUpdateChar(this._state);
            n = this._matchFinder.GetIndexByte(0 - this._additionalOffset);
            this._literalEncoder.GetSubCoder((int)this.nowPos64, this._previousByte).Encode(this._rangeEncoder, (byte)n);
            this._previousByte = n;
            --this._additionalOffset;
            ++this.nowPos64;
        }
        if (this._matchFinder.GetNumAvailableBytes() == 0) {
            this.Flush((int)this.nowPos64);
            return;
        }
        while (true) {
            int n3;
            int n4;
            n2 = this.GetOptimum((int)this.nowPos64);
            n = this.backRes;
            int n5 = (int)this.nowPos64 & this._posStateMask;
            int n6 = (this._state << 4) + n5;
            if (n2 == 1 && n == -1) {
                this._rangeEncoder.Encode(this._isMatch, n6, 0);
                n4 = this._matchFinder.GetIndexByte(0 - this._additionalOffset);
                LiteralEncoder.Encoder2 encoder2 = this._literalEncoder.GetSubCoder((int)this.nowPos64, this._previousByte);
                if (!Base.StateIsCharState(this._state)) {
                    n3 = this._matchFinder.GetIndexByte(0 - this._repDistances[0] - 1 - this._additionalOffset);
                    encoder2.EncodeMatched(this._rangeEncoder, (byte)n3, (byte)n4);
                } else {
                    encoder2.Encode(this._rangeEncoder, (byte)n4);
                }
                this._previousByte = (byte)n4;
                this._state = Base.StateUpdateChar(this._state);
            } else {
                this._rangeEncoder.Encode(this._isMatch, n6, 1);
                if (n < 4) {
                    this._rangeEncoder.Encode(this._isRep, this._state, 1);
                    if (n == 0) {
                        this._rangeEncoder.Encode(this._isRepG0, this._state, 0);
                        if (n2 == 1) {
                            this._rangeEncoder.Encode(this._isRep0Long, n6, 0);
                        } else {
                            this._rangeEncoder.Encode(this._isRep0Long, n6, 1);
                        }
                    } else {
                        this._rangeEncoder.Encode(this._isRepG0, this._state, 1);
                        if (n == 1) {
                            this._rangeEncoder.Encode(this._isRepG1, this._state, 0);
                        } else {
                            this._rangeEncoder.Encode(this._isRepG1, this._state, 1);
                            this._rangeEncoder.Encode(this._isRepG2, this._state, n - 2);
                        }
                    }
                    if (n2 == 1) {
                        this._state = Base.StateUpdateShortRep(this._state);
                    } else {
                        this._repMatchLenEncoder.Encode(this._rangeEncoder, n2 - 2, n5);
                        this._state = Base.StateUpdateRep(this._state);
                    }
                    n4 = this._repDistances[n];
                    if (n != 0) {
                        for (int i = n; i >= 1; --i) {
                            this._repDistances[i] = this._repDistances[i - 1];
                        }
                        this._repDistances[0] = n4;
                    }
                } else {
                    int n7;
                    this._rangeEncoder.Encode(this._isRep, this._state, 0);
                    this._state = Base.StateUpdateMatch(this._state);
                    this._lenEncoder.Encode(this._rangeEncoder, n2 - 2, n5);
                    n4 = Encoder.GetPosSlot(n -= 4);
                    int n8 = Base.GetLenToPosState(n2);
                    this._posSlotEncoder[n8].Encode(this._rangeEncoder, n4);
                    if (n4 >= 4) {
                        n3 = (n4 >> 1) - 1;
                        n7 = (2 | n4 & 1) << n3;
                        int n9 = n - n7;
                        if (n4 < 14) {
                            BitTreeEncoder.ReverseEncode(this._posEncoders, n7 - n4 - 1, this._rangeEncoder, n3, n9);
                        } else {
                            this._rangeEncoder.EncodeDirectBits(n9 >> 4, n3 - 4);
                            this._posAlignEncoder.ReverseEncode(this._rangeEncoder, n9 & 0xF);
                            ++this._alignPriceCount;
                        }
                    }
                    n3 = n;
                    for (n7 = 3; n7 >= 1; --n7) {
                        this._repDistances[n7] = this._repDistances[n7 - 1];
                    }
                    this._repDistances[0] = n3;
                    ++this._matchPriceCount;
                }
                this._previousByte = this._matchFinder.GetIndexByte(n2 - 1 - this._additionalOffset);
            }
            this._additionalOffset -= n2;
            this.nowPos64 += (long)n2;
            if (this._additionalOffset != 0) continue;
            if (this._matchPriceCount >= 128) {
                this.FillDistancesPrices();
            }
            if (this._alignPriceCount >= 16) {
                this.FillAlignPrices();
            }
            lArray[0] = this.nowPos64;
            lArray2[0] = this._rangeEncoder.GetProcessedSizeAdd();
            if (this._matchFinder.GetNumAvailableBytes() == 0) {
                this.Flush((int)this.nowPos64);
                return;
            }
            if (this.nowPos64 - l >= 4096L) break;
        }
        this._finished = false;
        blArray[0] = false;
    }

    void ReleaseMFStream() {
        if (this._matchFinder != null && this._needReleaseMFStream) {
            this._matchFinder.ReleaseStream();
            this._needReleaseMFStream = false;
        }
    }

    void SetOutStream(OutputStream outputStream) {
        this._rangeEncoder.SetStream(outputStream);
    }

    void ReleaseOutStream() {
        this._rangeEncoder.ReleaseStream();
    }

    void ReleaseStreams() {
        this.ReleaseMFStream();
        this.ReleaseOutStream();
    }

    void SetStreams(InputStream inputStream, OutputStream outputStream, long l, long l2) {
        this._inStream = inputStream;
        this._finished = false;
        this.Create();
        this.SetOutStream(outputStream);
        this.Init();
        this.FillDistancesPrices();
        this.FillAlignPrices();
        this._lenEncoder.SetTableSize(this._numFastBytes + 1 - 2);
        this._lenEncoder.UpdateTables(1 << this._posStateBits);
        this._repMatchLenEncoder.SetTableSize(this._numFastBytes + 1 - 2);
        this._repMatchLenEncoder.UpdateTables(1 << this._posStateBits);
        this.nowPos64 = 0L;
    }

    public void Code(InputStream inputStream, OutputStream outputStream, long l, long l2, ICodeProgress iCodeProgress) throws IOException {
        this._needReleaseMFStream = false;
        try {
            this.SetStreams(inputStream, outputStream, l, l2);
            while (true) {
                this.CodeOneBlock(this.processedInSize, this.processedOutSize, this.finished);
                if (this.finished[0]) {
                    return;
                }
                if (iCodeProgress == null) continue;
                iCodeProgress.SetProgress(this.processedInSize[0], this.processedOutSize[0]);
            }
        }
        finally {
            this.ReleaseStreams();
        }
    }

    public void WriteCoderProperties(OutputStream outputStream) throws IOException {
        this.properties[0] = (byte)((this._posStateBits * 5 + this._numLiteralPosStateBits) * 9 + this._numLiteralContextBits);
        for (int i = 0; i < 4; ++i) {
            this.properties[1 + i] = (byte)(this._dictionarySize >> 8 * i);
        }
        outputStream.write(this.properties, 0, 5);
    }

    void FillDistancesPrices() {
        int n;
        int n2;
        int n3;
        for (n3 = 4; n3 < 128; ++n3) {
            n2 = Encoder.GetPosSlot(n3);
            int n4 = (n2 >> 1) - 1;
            n = (2 | n2 & 1) << n4;
            this.tempPrices[n3] = BitTreeEncoder.ReverseGetPrice(this._posEncoders, n - n2 - 1, n4, n3 - n);
        }
        for (n3 = 0; n3 < 4; ++n3) {
            int n5;
            BitTreeEncoder bitTreeEncoder = this._posSlotEncoder[n3];
            n = n3 << 6;
            for (n2 = 0; n2 < this._distTableSize; ++n2) {
                this._posSlotPrices[n + n2] = bitTreeEncoder.GetPrice(n2);
            }
            for (n2 = 14; n2 < this._distTableSize; ++n2) {
                int n6 = n + n2;
                this._posSlotPrices[n6] = this._posSlotPrices[n6] + ((n2 >> 1) - 1 - 4 << 6);
            }
            int n7 = n3 * 128;
            for (n5 = 0; n5 < 4; ++n5) {
                this._distancesPrices[n7 + n5] = this._posSlotPrices[n + n5];
            }
            while (n5 < 128) {
                this._distancesPrices[n7 + n5] = this._posSlotPrices[n + Encoder.GetPosSlot(n5)] + this.tempPrices[n5];
                ++n5;
            }
        }
        this._matchPriceCount = 0;
    }

    void FillAlignPrices() {
        for (int i = 0; i < 16; ++i) {
            this._alignPrices[i] = this._posAlignEncoder.ReverseGetPrice(i);
        }
        this._alignPriceCount = 0;
    }

    public boolean SetAlgorithm(int n) {
        return true;
    }

    public boolean SetDictionarySize(int n) {
        int n2 = 29;
        if (n < 1 || n > 1 << n2) {
            return false;
        }
        this._dictionarySize = n;
        int n3 = 0;
        while (n > 1 << n3) {
            ++n3;
        }
        this._distTableSize = n3 * 2;
        return true;
    }

    public boolean SetNumFastBytes(int n) {
        if (n < 5 || n > 273) {
            return false;
        }
        this._numFastBytes = n;
        return true;
    }

    public boolean SetMatchFinder(int n) {
        if (n < 0 || n > 2) {
            return false;
        }
        int n2 = this._matchFinderType;
        this._matchFinderType = n;
        if (this._matchFinder != null && n2 != this._matchFinderType) {
            this._dictionarySizePrev = -1;
            this._matchFinder = null;
        }
        return true;
    }

    public boolean SetLcLpPb(int n, int n2, int n3) {
        if (n2 < 0 || n2 > 4 || n < 0 || n > 8 || n3 < 0 || n3 > 4) {
            return false;
        }
        this._numLiteralPosStateBits = n2;
        this._numLiteralContextBits = n;
        this._posStateBits = n3;
        this._posStateMask = (1 << this._posStateBits) - 1;
        return true;
    }

    public void SetEndMarkerMode(boolean bl) {
        this._writeEndMark = bl;
    }

    static {
        int n = 22;
        int n2 = 2;
        Encoder.g_FastPos[0] = 0;
        Encoder.g_FastPos[1] = 1;
        for (int i = 2; i < n; ++i) {
            int n3 = 1 << (i >> 1) - 1;
            int n4 = 0;
            while (n4 < n3) {
                Encoder.g_FastPos[n2] = (byte)i;
                ++n4;
                ++n2;
            }
        }
    }

    class Optimal {
        public int State;
        public boolean Prev1IsChar;
        public boolean Prev2;
        public int PosPrev2;
        public int BackPrev2;
        public int Price;
        public int PosPrev;
        public int BackPrev;
        public int Backs0;
        public int Backs1;
        public int Backs2;
        public int Backs3;

        Optimal() {
        }

        public void MakeAsChar() {
            this.BackPrev = -1;
            this.Prev1IsChar = false;
        }

        public void MakeAsShortRep() {
            this.BackPrev = 0;
            this.Prev1IsChar = false;
        }

        public boolean IsShortRep() {
            return this.BackPrev == 0;
        }
    }

    class LenPriceTableEncoder
    extends LenEncoder {
        int[] _prices;
        int _tableSize;
        int[] _counters;

        LenPriceTableEncoder() {
            this._prices = new int[4352];
            this._counters = new int[16];
        }

        public void SetTableSize(int n) {
            this._tableSize = n;
        }

        public int GetPrice(int n, int n2) {
            return this._prices[n2 * 272 + n];
        }

        void UpdateTable(int n) {
            this.SetPrices(n, this._tableSize, this._prices, n * 272);
            this._counters[n] = this._tableSize;
        }

        public void UpdateTables(int n) {
            for (int i = 0; i < n; ++i) {
                this.UpdateTable(i);
            }
        }

        @Override
        public void Encode(SevenZip.Compression.RangeCoder.Encoder encoder, int n, int n2) throws IOException {
            super.Encode(encoder, n, n2);
            int n3 = n2;
            this._counters[n3] = this._counters[n3] - 1;
            if (this._counters[n3] == 0) {
                this.UpdateTable(n2);
            }
        }
    }

    class LenEncoder {
        short[] _choice = new short[2];
        BitTreeEncoder[] _lowCoder = new BitTreeEncoder[16];
        BitTreeEncoder[] _midCoder = new BitTreeEncoder[16];
        BitTreeEncoder _highCoder = new BitTreeEncoder(8);

        public LenEncoder() {
            for (int i = 0; i < 16; ++i) {
                this._lowCoder[i] = new BitTreeEncoder(3);
                this._midCoder[i] = new BitTreeEncoder(3);
            }
        }

        public void Init(int n) {
            SevenZip.Compression.RangeCoder.Encoder.InitBitModels(this._choice);
            for (int i = 0; i < n; ++i) {
                this._lowCoder[i].Init();
                this._midCoder[i].Init();
            }
            this._highCoder.Init();
        }

        public void Encode(SevenZip.Compression.RangeCoder.Encoder encoder, int n, int n2) throws IOException {
            if (n < 8) {
                encoder.Encode(this._choice, 0, 0);
                this._lowCoder[n2].Encode(encoder, n);
            } else {
                encoder.Encode(this._choice, 0, 1);
                if ((n -= 8) < 8) {
                    encoder.Encode(this._choice, 1, 0);
                    this._midCoder[n2].Encode(encoder, n);
                } else {
                    encoder.Encode(this._choice, 1, 1);
                    this._highCoder.Encode(encoder, n - 8);
                }
            }
        }

        public void SetPrices(int n, int n2, int[] nArray, int n3) {
            int n4 = SevenZip.Compression.RangeCoder.Encoder.GetPrice0(this._choice[0]);
            int n5 = SevenZip.Compression.RangeCoder.Encoder.GetPrice1(this._choice[0]);
            int n6 = n5 + SevenZip.Compression.RangeCoder.Encoder.GetPrice0(this._choice[1]);
            int n7 = n5 + SevenZip.Compression.RangeCoder.Encoder.GetPrice1(this._choice[1]);
            int n8 = 0;
            for (n8 = 0; n8 < 8; ++n8) {
                if (n8 >= n2) {
                    return;
                }
                nArray[n3 + n8] = n4 + this._lowCoder[n].GetPrice(n8);
            }
            while (n8 < 16) {
                if (n8 >= n2) {
                    return;
                }
                nArray[n3 + n8] = n6 + this._midCoder[n].GetPrice(n8 - 8);
                ++n8;
            }
            while (n8 < n2) {
                nArray[n3 + n8] = n7 + this._highCoder.GetPrice(n8 - 8 - 8);
                ++n8;
            }
        }
    }

    class LiteralEncoder {
        Encoder2[] m_Coders;
        int m_NumPrevBits;
        int m_NumPosBits;
        int m_PosMask;

        LiteralEncoder() {
        }

        public void Create(int n, int n2) {
            if (this.m_Coders != null && this.m_NumPrevBits == n2 && this.m_NumPosBits == n) {
                return;
            }
            this.m_NumPosBits = n;
            this.m_PosMask = (1 << n) - 1;
            this.m_NumPrevBits = n2;
            int n3 = 1 << this.m_NumPrevBits + this.m_NumPosBits;
            this.m_Coders = new Encoder2[n3];
            for (int i = 0; i < n3; ++i) {
                this.m_Coders[i] = new Encoder2();
            }
        }

        public void Init() {
            int n = 1 << this.m_NumPrevBits + this.m_NumPosBits;
            for (int i = 0; i < n; ++i) {
                this.m_Coders[i].Init();
            }
        }

        public Encoder2 GetSubCoder(int n, byte by) {
            return this.m_Coders[((n & this.m_PosMask) << this.m_NumPrevBits) + ((by & 0xFF) >>> 8 - this.m_NumPrevBits)];
        }

        class Encoder2 {
            short[] m_Encoders = new short[768];

            Encoder2() {
            }

            public void Init() {
                SevenZip.Compression.RangeCoder.Encoder.InitBitModels(this.m_Encoders);
            }

            public void Encode(SevenZip.Compression.RangeCoder.Encoder encoder, byte by) throws IOException {
                int n = 1;
                for (int i = 7; i >= 0; --i) {
                    int n2 = by >> i & 1;
                    encoder.Encode(this.m_Encoders, n, n2);
                    n = n << 1 | n2;
                }
            }

            public void EncodeMatched(SevenZip.Compression.RangeCoder.Encoder encoder, byte by, byte by2) throws IOException {
                int n = 1;
                boolean bl = true;
                for (int i = 7; i >= 0; --i) {
                    int n2 = by2 >> i & 1;
                    int n3 = n;
                    if (bl) {
                        int n4 = by >> i & 1;
                        n3 += 1 + n4 << 8;
                        bl = n4 == n2;
                    }
                    encoder.Encode(this.m_Encoders, n3, n2);
                    n = n << 1 | n2;
                }
            }

            public int GetPrice(boolean bl, byte by, byte by2) {
                int n;
                int n2;
                int n3 = 0;
                int n4 = 1;
                if (bl) {
                    for (n2 = 7; n2 >= 0; --n2) {
                        n = by >> n2 & 1;
                        int n5 = by2 >> n2 & 1;
                        n3 += SevenZip.Compression.RangeCoder.Encoder.GetPrice(this.m_Encoders[(1 + n << 8) + n4], n5);
                        n4 = n4 << 1 | n5;
                        if (n == n5) continue;
                        --n2;
                        break;
                    }
                }
                while (n2 >= 0) {
                    n = by2 >> n2 & 1;
                    n3 += SevenZip.Compression.RangeCoder.Encoder.GetPrice(this.m_Encoders[n4], n);
                    n4 = n4 << 1 | n;
                    --n2;
                }
                return n3;
            }
        }
    }
}

