/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.foundation.PreparedComparison;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.IDHandler;
import com.db4o.internal.IllegalComparisonException;
import com.db4o.internal.Indexable4;
import com.db4o.internal.btree.FieldIndexKey;
import com.db4o.internal.handlers.IntHandler;
import com.db4o.marshall.Context;

public class FieldIndexKeyHandler
implements Indexable4 {
    private final Indexable4 _valueHandler;
    private final IntHandler _parentIdHandler = new IDHandler();

    public FieldIndexKeyHandler(Indexable4 delegate_) {
        this._valueHandler = delegate_;
    }

    @Override
    public int linkLength() {
        return this._valueHandler.linkLength() + 4;
    }

    @Override
    public Object readIndexEntry(ByteArrayBuffer a_reader) {
        int parentID = this.readParentID(a_reader);
        Object objPart = this._valueHandler.readIndexEntry(a_reader);
        if (parentID < 0) {
            objPart = null;
            parentID = -parentID;
        }
        return new FieldIndexKey(parentID, objPart);
    }

    private int readParentID(ByteArrayBuffer a_reader) {
        return (Integer)this._parentIdHandler.readIndexEntry(a_reader);
    }

    @Override
    public void writeIndexEntry(ByteArrayBuffer writer, Object obj) {
        FieldIndexKey composite = (FieldIndexKey)obj;
        int parentID = composite.parentID();
        Object value = composite.value();
        if (value == null) {
            parentID = -parentID;
        }
        this._parentIdHandler.write(parentID, writer);
        this._valueHandler.writeIndexEntry(writer, composite.value());
    }

    public Indexable4 valueHandler() {
        return this._valueHandler;
    }

    @Override
    public void defragIndexEntry(DefragmentContextImpl context) {
        this._parentIdHandler.defragIndexEntry(context);
        this._valueHandler.defragIndexEntry(context);
    }

    @Override
    public PreparedComparison prepareComparison(Context context, Object fieldIndexKey) {
        FieldIndexKey source = (FieldIndexKey)fieldIndexKey;
        final PreparedComparison preparedValueComparison = this._valueHandler.prepareComparison(context, source.value());
        final PreparedComparison preparedParentIdComparison = this._parentIdHandler.newPrepareCompare(source.parentID());
        return new PreparedComparison(){

            @Override
            public int compareTo(Object obj) {
                FieldIndexKey target = (FieldIndexKey)obj;
                try {
                    int delegateResult = preparedValueComparison.compareTo(target.value());
                    if (delegateResult != 0) {
                        return delegateResult;
                    }
                }
                catch (IllegalComparisonException illegalComparisonException) {
                    // empty catch block
                }
                return preparedParentIdComparison.compareTo(new Integer(target.parentID()));
            }
        };
    }
}

