/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver;

import com.github.zafarkhaja.semver.MetadataVersion;
import com.github.zafarkhaja.semver.NormalVersion;
import com.github.zafarkhaja.semver.Parser;
import com.github.zafarkhaja.semver.VersionParser;
import com.github.zafarkhaja.semver.expr.Expression;
import com.github.zafarkhaja.semver.expr.ExpressionParser;
import java.util.Comparator;

public class Version
implements Comparable<Version> {
    private final NormalVersion normal;
    private final MetadataVersion preRelease;
    private final MetadataVersion build;
    private static final String PRE_RELEASE_PREFIX = "-";
    private static final String BUILD_PREFIX = "+";
    public static final Comparator<Version> BUILD_AWARE_ORDER = new BuildAwareOrder();

    Version(NormalVersion normalVersion) {
        this(normalVersion, MetadataVersion.NULL, MetadataVersion.NULL);
    }

    Version(NormalVersion normalVersion, MetadataVersion metadataVersion) {
        this(normalVersion, metadataVersion, MetadataVersion.NULL);
    }

    Version(NormalVersion normalVersion, MetadataVersion metadataVersion, MetadataVersion metadataVersion2) {
        this.normal = normalVersion;
        this.preRelease = metadataVersion;
        this.build = metadataVersion2;
    }

    public static Version valueOf(String string) {
        return VersionParser.parseValidSemVer(string);
    }

    public static Version forIntegers(int n) {
        return new Version(new NormalVersion(n, 0, 0));
    }

    public static Version forIntegers(int n, int n2) {
        return new Version(new NormalVersion(n, n2, 0));
    }

    public static Version forIntegers(int n, int n2, int n3) {
        return new Version(new NormalVersion(n, n2, n3));
    }

    public boolean satisfies(String string) {
        Parser<Expression> parser = ExpressionParser.newInstance();
        return this.satisfies(parser.parse(string));
    }

    public boolean satisfies(Expression expression) {
        return expression.interpret(this);
    }

    public Version incrementMajorVersion() {
        return new Version(this.normal.incrementMajor());
    }

    public Version incrementMajorVersion(String string) {
        return new Version(this.normal.incrementMajor(), VersionParser.parsePreRelease(string));
    }

    public Version incrementMinorVersion() {
        return new Version(this.normal.incrementMinor());
    }

    public Version incrementMinorVersion(String string) {
        return new Version(this.normal.incrementMinor(), VersionParser.parsePreRelease(string));
    }

    public Version incrementPatchVersion() {
        return new Version(this.normal.incrementPatch());
    }

    public Version incrementPatchVersion(String string) {
        return new Version(this.normal.incrementPatch(), VersionParser.parsePreRelease(string));
    }

    public Version incrementPreReleaseVersion() {
        return new Version(this.normal, this.preRelease.increment());
    }

    public Version incrementBuildMetadata() {
        return new Version(this.normal, this.preRelease, this.build.increment());
    }

    public Version setPreReleaseVersion(String string) {
        return new Version(this.normal, VersionParser.parsePreRelease(string));
    }

    public Version setBuildMetadata(String string) {
        return new Version(this.normal, this.preRelease, VersionParser.parseBuild(string));
    }

    public int getMajorVersion() {
        return this.normal.getMajor();
    }

    public int getMinorVersion() {
        return this.normal.getMinor();
    }

    public int getPatchVersion() {
        return this.normal.getPatch();
    }

    public String getNormalVersion() {
        return this.normal.toString();
    }

    public String getPreReleaseVersion() {
        return this.preRelease.toString();
    }

    public String getBuildMetadata() {
        return this.build.toString();
    }

    public boolean greaterThan(Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean greaterThanOrEqualTo(Version version) {
        return this.compareTo(version) >= 0;
    }

    public boolean lessThan(Version version) {
        return this.compareTo(version) < 0;
    }

    public boolean lessThanOrEqualTo(Version version) {
        return this.compareTo(version) <= 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)object) == 0;
    }

    public int hashCode() {
        int n = 5;
        n = 97 * n + this.normal.hashCode();
        n = 97 * n + this.preRelease.hashCode();
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getNormalVersion());
        if (!this.getPreReleaseVersion().isEmpty()) {
            stringBuilder.append(PRE_RELEASE_PREFIX).append(this.getPreReleaseVersion());
        }
        if (!this.getBuildMetadata().isEmpty()) {
            stringBuilder.append(BUILD_PREFIX).append(this.getBuildMetadata());
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(Version version) {
        int n = this.normal.compareTo(version.normal);
        if (n == 0) {
            n = this.preRelease.compareTo(version.preRelease);
        }
        return n;
    }

    public int compareWithBuildsTo(Version version) {
        return BUILD_AWARE_ORDER.compare(this, version);
    }

    private static class BuildAwareOrder
    implements Comparator<Version> {
        private BuildAwareOrder() {
        }

        @Override
        public int compare(Version version, Version version2) {
            int n = version.compareTo(version2);
            if (n == 0) {
                n = version.build.compareTo(version2.build);
                if (version.build == MetadataVersion.NULL || version2.build == MetadataVersion.NULL) {
                    n = -1 * n;
                }
            }
            return n;
        }
    }

    public static class Builder {
        private String normal;
        private String preRelease;
        private String build;

        public Builder() {
        }

        public Builder(String string) {
            this.normal = string;
        }

        public Builder setNormalVersion(String string) {
            this.normal = string;
            return this;
        }

        public Builder setPreReleaseVersion(String string) {
            this.preRelease = string;
            return this;
        }

        public Builder setBuildMetadata(String string) {
            this.build = string;
            return this;
        }

        public Version build() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.isFilled(this.normal)) {
                stringBuilder.append(this.normal);
            }
            if (this.isFilled(this.preRelease)) {
                stringBuilder.append(Version.PRE_RELEASE_PREFIX).append(this.preRelease);
            }
            if (this.isFilled(this.build)) {
                stringBuilder.append(Version.BUILD_PREFIX).append(this.build);
            }
            return VersionParser.parseValidSemVer(stringBuilder.toString());
        }

        private boolean isFilled(String string) {
            return string != null && !string.isEmpty();
        }
    }
}

