/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snac;

import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;

public final class MutableSnacPacket {
    private int family;
    private int command;
    private long reqid;
    private short flag1;
    private short flag2;
    private ByteBlock data;
    private boolean changed = false;

    public MutableSnacPacket(SnacPacket packet) {
        DefensiveTools.checkNull(packet, "packet");
        this.family = packet.getFamily();
        this.command = packet.getCommand();
        this.reqid = packet.getReqid();
        this.flag1 = packet.getFlag1();
        this.flag2 = packet.getFlag2();
        this.data = packet.getData();
    }

    public final int getFamily() {
        return this.family;
    }

    public final int getCommand() {
        return this.command;
    }

    public final long getReqid() {
        return this.reqid;
    }

    public final short getFlag1() {
        return this.flag1;
    }

    public final short getFlag2() {
        return this.flag2;
    }

    public final ByteBlock getData() {
        return this.data;
    }

    public void setFamily(int family) {
        DefensiveTools.checkRange(family, "family", 0);
        if (!this.changed) {
            this.changed = family != this.family;
        }
        this.family = family;
    }

    public void setCommand(int command) {
        DefensiveTools.checkRange(command, "command", 0);
        if (!this.changed) {
            this.changed = command != this.command;
        }
        this.command = command;
    }

    public void setReqid(long reqid) {
        DefensiveTools.checkRange(reqid, "reqid", 0L);
        if (!this.changed) {
            this.changed = reqid != this.reqid;
        }
        this.reqid = reqid;
    }

    public void setFlag1(short flag1) {
        DefensiveTools.checkRange(flag1, "flag1", 0);
        if (!this.changed) {
            this.changed = flag1 != this.flag1;
        }
        this.flag1 = flag1;
    }

    public void setFlag2(short flag2) {
        DefensiveTools.checkRange(flag2, "flag2", 0);
        if (!this.changed) {
            this.changed = flag2 != this.flag2;
        }
        this.flag2 = flag2;
    }

    public void setData(ByteBlock data) {
        DefensiveTools.checkNull(data, "data");
        if (!this.changed) {
            this.changed = data != this.data;
        }
        this.data = data;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public SnacPacket toSnacPacket() {
        return new SnacPacket(this.family, this.command, this.reqid, this.flag1, this.flag2, this.data);
    }

    public String toString() {
        return "MutableSnacPacket type 0x" + Integer.toHexString(this.family) + "/0x" + Integer.toHexString(this.command) + (this.flag1 == 0 ? "" : ", flag1=0x" + Integer.toHexString(this.flag1)) + (this.flag2 == 0 ? "" : ", flag2=0x" + Integer.toHexString(this.flag2)) + ": " + (this.data == null ? null : this.data.getLength() + " bytes") + " (id=" + this.reqid + ")";
    }
}

