/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.icbm.AbstractImIcbm;
import net.kano.joscar.snaccmd.icbm.InstantMessage;
import net.kano.joscar.snaccmd.icbm.OldIconHashInfo;
import net.kano.joscar.snaccmd.icbm.RecvIcbm;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecvImIcbm
extends AbstractImIcbm
implements RecvIcbm {
    private static final int TYPE_CAN_TYPE = 11;
    private final boolean canType;
    private final FullUserInfo userInfo;

    protected RecvImIcbm(SnacPacket packet) {
        super(7, packet);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = this.getChannelData();
        this.userInfo = FullUserInfo.readUserInfo(snacData);
        ByteBlock tlvBlock = snacData.subBlock(this.userInfo.getTotalSize());
        ImmutableTlvChain chain = TlvTools.readChain(tlvBlock);
        this.processImTlvs(chain);
        this.canType = chain.hasTlv(11);
    }

    public RecvImIcbm(long messageId, FullUserInfo userInfo, InstantMessage message, boolean autoResponse, boolean wantsIcon, OldIconHashInfo iconInfo, Collection<ExtraInfoBlock> expInfoBlocks, ByteBlock featuresBlock, boolean canType) {
        super(7, messageId, message, autoResponse, wantsIcon, iconInfo, expInfoBlocks, featuresBlock);
        DefensiveTools.checkNull(userInfo, "userInfo");
        this.canType = canType;
        this.userInfo = userInfo;
    }

    @Override
    public final FullUserInfo getSenderInfo() {
        return this.userInfo;
    }

    public final boolean canType() {
        return this.canType;
    }

    @Override
    protected final void writeChannelData(OutputStream out) throws IOException {
        this.userInfo.write(out);
        if (this.canType) {
            new Tlv(11).write(out);
        }
        this.writeImTlvs(out);
    }

    @Override
    public String toString() {
        return "RecvImIcbm: message from " + this.userInfo + ": " + this.getMessage();
    }
}

