/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.chatrooms;

import java.util.logging.Logger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.snac.SnacRequestAdapter;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snaccmd.FullRoomInfo;
import net.kano.joscar.snaccmd.MiniRoomInfo;
import net.kano.joscar.snaccmd.conn.SnacFamilyInfo;
import net.kano.joscar.snaccmd.rooms.JoinRoomCmd;
import net.kano.joscar.snaccmd.rooms.RoomCommand;
import net.kano.joscar.snaccmd.rooms.RoomInfoReq;
import net.kano.joscar.snaccmd.rooms.RoomResponse;
import net.kano.joscar.snaccmd.rooms.RoomRightsRequest;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.ExternalServiceManager;
import net.kano.joustsim.oscar.oscar.BasicConnection;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.AbstractService;
import net.kano.joustsim.oscar.oscar.service.MutableService;
import net.kano.joustsim.oscar.oscar.service.ServiceFactory;
import net.kano.joustsim.oscar.oscar.service.bos.ExternalBosServiceImpl;
import net.kano.joustsim.oscar.oscar.service.bos.MainBosService;
import net.kano.joustsim.oscar.oscar.service.bos.OpenedChatRoomServiceListener;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomService;
import net.kano.joustsim.oscar.oscar.service.chatrooms.RoomFinderServiceListener;
import org.jetbrains.annotations.Nullable;

public class RoomFinderService
extends AbstractService {
    private static final Logger LOGGER = Logger.getLogger(RoomFinderService.class.getName());
    @Nullable
    private Integer maxRoomsAllowed = null;
    private CopyOnWriteArrayList<RoomFinderServiceListener> listeners = new CopyOnWriteArrayList();

    public RoomFinderService(AimConnection aimConnection, OscarConnection oscarConnection) {
        super(aimConnection, oscarConnection, 13);
    }

    public void connected() {
        this.sendSnacRequest(new RoomRightsRequest(), new SnacRequestAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleResponse(SnacResponseEvent e) {
                SnacCommand cmd = e.getSnacCommand();
                if (cmd instanceof RoomResponse) {
                    RoomResponse response = (RoomResponse)cmd;
                    int max = response.getMaxRooms();
                    if (max != -1) {
                        RoomFinderService roomFinderService = RoomFinderService.this;
                        synchronized (roomFinderService) {
                            RoomFinderService.this.maxRoomsAllowed = max;
                        }
                    }
                    RoomFinderService.this.setReady();
                }
            }
        });
    }

    @Nullable
    public synchronized Integer getMaxRoomsAllowed() {
        return this.maxRoomsAllowed;
    }

    public void joinChatRoom(int exchange, String name) {
        FullRoomInfo roomInfo = new FullRoomInfo(exchange, name);
        JoinRoomCmd cmd = new JoinRoomCmd(roomInfo);
        this.sendSnacRequest(cmd, new SnacRequestAdapter(){

            public void handleResponse(SnacResponseEvent e) {
                SnacCommand cmd = e.getSnacCommand();
                if (cmd instanceof RoomResponse) {
                    RoomResponse response = (RoomResponse)cmd;
                    FullRoomInfo roominfo = response.getRoomInfo();
                    LOGGER.fine("Got join-room response for " + roominfo + "; connecting to chat room");
                    RoomFinderService.this.joinChatRoom(roominfo);
                } else {
                    LOGGER.warning("Got unknown response to JoinRoomCmd: " + cmd);
                }
            }
        });
    }

    public void joinChatRoom(FullRoomInfo roomInfo) {
        this.getAimConnection().getBosService().requestChatService(roomInfo, new MyOpenedChatRoomServiceListener(roomInfo));
    }

    public SnacFamilyInfo getSnacFamilyInfo() {
        return RoomCommand.FAMILY_INFO;
    }

    public void addRoomManagerServiceListener(RoomFinderServiceListener listener) {
        this.listeners.add(listener);
    }

    public void removeRoomManagerServiceListener(RoomFinderServiceListener listener) {
        this.listeners.remove(listener);
    }

    public void requestRoomInfo(final MiniRoomInfo roomInfo) {
        this.sendSnacRequest(new RoomInfoReq(roomInfo), new SnacRequestAdapter(){

            public void handleResponse(SnacResponseEvent e) {
                SnacCommand cmd = e.getSnacCommand();
                if (cmd instanceof RoomResponse) {
                    RoomResponse roomResponse = (RoomResponse)cmd;
                    LOGGER.finer("Got room info for " + roomResponse.getRoomInfo());
                    for (RoomFinderServiceListener listener : RoomFinderService.this.listeners) {
                        listener.handleRoomInfo(RoomFinderService.this, roomInfo, roomResponse.getRoomInfo());
                    }
                }
                RoomFinderService.this.setReady();
            }
        });
    }

    private class MyOpenedChatRoomServiceListener
    implements OpenedChatRoomServiceListener {
        private final FullRoomInfo roomInfo;

        public MyOpenedChatRoomServiceListener(FullRoomInfo fullRoomInfo) {
            this.roomInfo = fullRoomInfo;
        }

        public void handleChatRoomRedirect(MainBosService service, FullRoomInfo roomInfo, String host, int port, ByteBlock flapCookie) {
            LOGGER.fine("Got chat room redirect for " + roomInfo.getName() + ": " + host + ":" + port);
            BasicConnection conn = new BasicConnection(host, ExternalServiceManager.fixPort(port));
            conn.getClientFlapConn().setSocketFactory(RoomFinderService.this.getAimConnection().getProxy().getSocketFactory());
            conn.setCookie(flapCookie);
            conn.setServiceFactory(new ChatRoomServiceFactory(this.roomInfo));
            for (RoomFinderServiceListener listener : RoomFinderService.this.listeners) {
                listener.handleNewChatRoom(RoomFinderService.this, this.roomInfo, conn);
            }
            conn.connect();
        }
    }

    private class ChatRoomServiceFactory
    implements ServiceFactory {
        private FullRoomInfo roomInfo;

        public ChatRoomServiceFactory(FullRoomInfo roomInfo) {
            this.roomInfo = roomInfo;
        }

        public MutableService getService(OscarConnection conn, int family) {
            if (family == 1) {
                return new ExternalBosServiceImpl(RoomFinderService.this.getAimConnection(), conn);
            }
            if (family == 14) {
                return new ChatRoomService(RoomFinderService.this.getAimConnection(), conn, this.roomInfo);
            }
            return null;
        }
    }
}

