/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.sip.communicator.plugin.desktoputil.SIPCommPopupMenu;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import org.jitsi.service.neomedia.VolumeControl;
import org.jitsi.service.neomedia.event.VolumeChangeEvent;
import org.jitsi.service.neomedia.event.VolumeChangeListener;

public class VolumeControlSlider
extends TransparentPanel
implements VolumeChangeListener {
    private final JSlider volumeSlider;
    private final VolumeControl volumeControl;
    private SetVolumeThread setVolumeThread = null;
    private static final int MULTIPLIER = 100;

    public VolumeControlSlider(VolumeControl volumeControl, int orientation) {
        super((LayoutManager)new BorderLayout());
        this.volumeControl = volumeControl;
        volumeControl.addVolumeChangeListener((VolumeChangeListener)this);
        this.setVolumeThread = new SetVolumeThread(volumeControl);
        this.volumeSlider = new JSlider(orientation, 0, 100, 50);
        if (orientation == 1) {
            this.volumeSlider.setPreferredSize(new Dimension(20, 100));
        } else {
            this.volumeSlider.setPreferredSize(new Dimension(100, 20));
        }
        this.volumeSlider.setMinimum((int)(volumeControl.getMinValue() * 100.0f));
        this.volumeSlider.setMaximum((int)(volumeControl.getMaxValue() * 100.0f));
        this.volumeSlider.setValue((int)(volumeControl.getVolume() * 100.0f));
        this.volumeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int volume = source.getValue();
                VolumeControlSlider.this.setVolumeThread.setVolume((float)volume / 100.0f);
            }
        });
        this.add(this.volumeSlider);
    }

    public void volumeChange(VolumeChangeEvent volumeChangeEvent) {
        int newValue = (int)(volumeChangeEvent.getLevel() * 100.0f);
        if (this.volumeSlider.getValue() != newValue) {
            this.volumeSlider.setValue(newValue);
        }
    }

    public JPopupMenu getPopupMenu() {
        SIPCommPopupMenu popupMenu = new SIPCommPopupMenu();
        popupMenu.add((Component)((Object)this));
        return popupMenu;
    }

    public void addNotify() {
        super.addNotify();
        this.volumeChange(new VolumeChangeEvent(this.volumeControl, this.volumeControl.getVolume(), this.volumeControl.getMute()));
        if (!this.setVolumeThread.isAlive()) {
            this.setVolumeThread = new SetVolumeThread(this.volumeControl);
            this.setVolumeThread.start();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.setVolumeThread.isAlive()) {
            this.setVolumeThread.end();
        }
    }

    private class SetVolumeThread
    extends Thread {
        private boolean run;
        private final VolumeControl volumeControl;
        private float volume;
        private float lastVolumeSet;

        public SetVolumeThread(VolumeControl volumeControl) {
            super("VolumeControlSlider: VolumeControl.setVolume");
            this.run = true;
            this.volumeControl = volumeControl;
            this.volume = this.lastVolumeSet = volumeControl.getVolume();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.run) {
                SetVolumeThread setVolumeThread = this;
                synchronized (setVolumeThread) {
                    if (this.volume == this.lastVolumeSet) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.lastVolumeSet = this.volume;
                }
                this.volumeControl.setVolume(this.lastVolumeSet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setVolume(float newVolume) {
            SetVolumeThread setVolumeThread = this;
            synchronized (setVolumeThread) {
                this.volume = newVolume;
                if (this.volume != this.lastVolumeSet) {
                    this.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end() {
            SetVolumeThread setVolumeThread = this;
            synchronized (setVolumeThread) {
                this.run = false;
                this.notify();
            }
        }
    }
}

