/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.callhistory;

import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.impl.callhistory.CallHistoryActivator;
import net.java.sip.communicator.impl.callhistory.CallHistoryContactSource;
import net.java.sip.communicator.service.callhistory.CallPeerRecord;
import net.java.sip.communicator.service.callhistory.CallRecord;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetContactCapabilities;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.DataObject;
import net.java.sip.communicator.util.GuiUtils;

public class CallHistorySourceContact
extends DataObject
implements SourceContact {
    private static final String STRIP_ADDRESSES_TO_NUMBERS = "net.java.sip.communicator.impl.callhistory.STRIP_ADDRESSES_TO_NUMBERS";
    private final CallHistoryContactSource contactSource;
    private final CallRecord callRecord;
    private static final byte[] incomingIcon = CallHistoryActivator.getResources().getImageInBytes("service.gui.icons.INCOMING_CALL");
    private static byte[] outgoingIcon = CallHistoryActivator.getResources().getImageInBytes("service.gui.icons.OUTGOING_CALL");
    private static byte[] missedCallIcon = CallHistoryActivator.getResources().getImageInBytes("service.gui.icons.MISSED_CALL");
    private final List<ContactDetail> contactDetails = new LinkedList<ContactDetail>();
    private String displayName = "";
    private final String displayDetails;

    public CallHistorySourceContact(CallHistoryContactSource contactSource, CallRecord callRecord) {
        this.contactSource = contactSource;
        this.callRecord = callRecord;
        this.initPeerDetails();
        this.displayDetails = CallHistoryActivator.getResources().getI18NString("service.gui.AT") + ": " + CallHistorySourceContact.getDateString(callRecord.getStartTime().getTime()) + " " + CallHistoryActivator.getResources().getI18NString("service.gui.DURATION") + ": " + GuiUtils.formatTime((Date)callRecord.getStartTime(), (Date)callRecord.getEndTime());
    }

    private void initPeerDetails() {
        boolean stripAddress = false;
        String stripAddressProp = CallHistoryActivator.getResources().getSettingsString(STRIP_ADDRESSES_TO_NUMBERS);
        if (stripAddressProp != null && Boolean.parseBoolean(stripAddressProp)) {
            stripAddress = true;
        }
        for (CallPeerRecord peerRecord : this.callRecord.getPeerRecords()) {
            String name;
            String peerRecordDisplayName;
            String peerAddress = peerRecord.getPeerAddress();
            String peerSecondaryAddress = peerRecord.getPeerSecondaryAddress();
            if (peerAddress == null) continue;
            if (stripAddress && !peerAddress.startsWith("@")) {
                peerAddress = peerAddress.split("@")[0];
            }
            if ((peerRecordDisplayName = peerRecord.getDisplayName()) == null || peerRecordDisplayName.length() == 0) {
                peerRecordDisplayName = peerAddress;
            }
            ContactDetail contactDetail = new ContactDetail(peerAddress, peerRecordDisplayName);
            Hashtable<Class<OperationSetBasicTelephony>, ProtocolProviderService> preferredProviders = null;
            Hashtable<Class<OperationSetBasicTelephony>, String> preferredProtocols = null;
            ProtocolProviderService preferredProvider = this.callRecord.getProtocolProvider();
            if (preferredProvider != null) {
                OperationSetContactCapabilities opSetCaps;
                preferredProviders = new Hashtable<Class<OperationSetBasicTelephony>, ProtocolProviderService>();
                OperationSetPresence opSetPres = (OperationSetPresence)preferredProvider.getOperationSet(OperationSetPresence.class);
                Contact contact = null;
                if (opSetPres != null) {
                    contact = opSetPres.findContactByID(peerAddress);
                }
                if ((opSetCaps = (OperationSetContactCapabilities)preferredProvider.getOperationSet(OperationSetContactCapabilities.class)) != null && opSetPres != null) {
                    if (contact != null && opSetCaps.getOperationSet(contact, OperationSetBasicTelephony.class) != null) {
                        preferredProviders.put(OperationSetBasicTelephony.class, preferredProvider);
                    }
                } else {
                    preferredProviders.put(OperationSetBasicTelephony.class, preferredProvider);
                }
                contactDetail.setPreferredProviders(preferredProviders);
            } else {
                preferredProtocols = new Hashtable<Class<OperationSetBasicTelephony>, String>();
                preferredProtocols.put(OperationSetBasicTelephony.class, "SIP");
                contactDetail.setPreferredProtocols(preferredProtocols);
            }
            LinkedList<Class> supportedOpSets = new LinkedList<Class>();
            if (preferredProviders != null && preferredProviders.containsKey(OperationSetBasicTelephony.class) || preferredProtocols != null) {
                supportedOpSets.add(OperationSetBasicTelephony.class);
            }
            supportedOpSets.add(OperationSetPersistentPresence.class);
            contactDetail.setSupportedOpSets(supportedOpSets);
            this.contactDetails.add(contactDetail);
            if (peerSecondaryAddress != null) {
                ContactDetail secondaryContactDetail = new ContactDetail(peerSecondaryAddress);
                secondaryContactDetail.addSupportedOpSet(OperationSetPersistentPresence.class);
                this.contactDetails.add(secondaryContactDetail);
            }
            if ((name = peerRecord.getDisplayName()) == null || name.length() <= 0) {
                name = peerAddress;
            }
            if (this.displayName != null && this.displayName.length() > 0) continue;
            if (this.callRecord.getPeerRecords().size() > 1) {
                this.displayName = "Conference " + name;
                continue;
            }
            this.displayName = name;
        }
    }

    public List<ContactDetail> getContactDetails() {
        return new LinkedList<ContactDetail>(this.contactDetails);
    }

    public ContactSourceService getContactSource() {
        return this.contactSource;
    }

    public String getDisplayDetails() {
        return this.displayDetails;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public byte[] getImage() {
        if (this.callRecord.getDirection().equals("in")) {
            if (this.callRecord.getStartTime().equals(this.callRecord.getEndTime()) && this.callRecord.getEndReason() != 200) {
                return missedCallIcon;
            }
            return incomingIcon;
        }
        if (this.callRecord.getDirection().equals("out")) {
            return outgoingIcon;
        }
        return null;
    }

    public List<ContactDetail> getContactDetails(Class<? extends OperationSet> operationSet) {
        if (!operationSet.equals(OperationSetBasicTelephony.class) && !operationSet.equals(OperationSetPersistentPresence.class)) {
            return null;
        }
        return new LinkedList<ContactDetail>(this.contactDetails);
    }

    public List<ContactDetail> getContactDetails(ContactDetail.Category category) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Categories are not supported for call history records.");
    }

    public ContactDetail getPreferredContactDetail(Class<? extends OperationSet> operationSet) {
        if (!operationSet.equals(OperationSetBasicTelephony.class) && !operationSet.equals(OperationSetPersistentPresence.class)) {
            return null;
        }
        return this.contactDetails.get(0);
    }

    public static String getDateString(long date) {
        String time = GuiUtils.formatTime((long)date);
        if (GuiUtils.compareDatesOnly((long)date, (long)System.currentTimeMillis()) < 0) {
            StringBuffer dateStrBuf = new StringBuffer();
            GuiUtils.formatDate((long)date, (StringBuffer)dateStrBuf);
            dateStrBuf.append(" ");
            dateStrBuf.append(time);
            return dateStrBuf.toString();
        }
        return time;
    }

    public PresenceStatus getPresenceStatus() {
        return null;
    }

    public int getIndex() {
        return -1;
    }

    public String getContactAddress() {
        return null;
    }

    public void setContactAddress(String contactAddress) {
    }

    public boolean isDefaultImage() {
        return true;
    }
}

