/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.history;

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.history.HistoryWindow;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.util.skin.Skinnable;

public class SearchPanel
extends TransparentPanel
implements ActionListener,
DocumentListener,
Skinnable {
    private JTextField searchTextField = new JTextField();
    private final HistoryWindow historyWindow;
    private JButton searchButton;

    public SearchPanel(HistoryWindow historyWindow) {
        super((LayoutManager)new BorderLayout(5, 5));
        this.historyWindow = historyWindow;
        this.init();
    }

    private void init() {
        String searchString = GuiActivator.getResources().getI18NString("service.gui.SEARCH");
        JLabel searchLabel = new JLabel(searchString + ": ");
        this.searchButton = new JButton(searchString, new ImageIcon(ImageLoader.getImage(ImageLoader.SEARCH_ICON)));
        this.searchTextField.getDocument().addDocumentListener(this);
        this.add(searchLabel, "West");
        this.add(this.searchTextField, "Center");
        this.searchButton.setName("search");
        this.searchButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.SEARCH"));
        this.searchButton.addActionListener(this);
        this.historyWindow.getRootPane().setDefaultButton(this.searchButton);
        this.add(this.searchButton, "East");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        String buttonName = button.getName();
        if (buttonName.equalsIgnoreCase("search")) {
            this.historyWindow.showHistoryByKeyword(this.searchTextField.getText());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.searchTextField.getText() == null || this.searchTextField.getText().equals("")) {
            this.historyWindow.showHistoryByKeyword("");
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public void loadSkin() {
        this.searchButton.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.SEARCH_ICON)));
    }
}

