/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.icq.InfoRetreiver;
import net.java.sip.communicator.impl.protocol.icq.ProtocolProviderServiceIcqImpl;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredContactInfo;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.util.Logger;

public class OperationSetServerStoredContactInfoIcqImpl
implements OperationSetServerStoredContactInfo {
    private static final Logger logger = Logger.getLogger(OperationSetServerStoredContactInfoIcqImpl.class);
    private InfoRetreiver infoRetreiver;
    private Hashtable<String, List<OperationSetServerStoredContactInfo.DetailsResponseListener>> listenersForDetails = new Hashtable();
    private ProtocolProviderServiceIcqImpl icqProvider = null;

    protected OperationSetServerStoredContactInfoIcqImpl(InfoRetreiver infoRetreiver, ProtocolProviderServiceIcqImpl icqProvider) {
        this.infoRetreiver = infoRetreiver;
        this.icqProvider = icqProvider;
    }

    public <T extends ServerStoredDetails.GenericDetail> Iterator<T> getDetailsAndDescendants(Contact contact, Class<T> detailClass) {
        this.assertConnected();
        if (detailClass.equals(ServerStoredDetails.ImageDetail.class) && contact.getImage() != null) {
            Vector<ServerStoredDetails.ImageDetail> res = new Vector<ServerStoredDetails.ImageDetail>();
            res.add(new ServerStoredDetails.ImageDetail("Image", contact.getImage()));
            Iterator tIt = res.iterator();
            return tIt;
        }
        return this.infoRetreiver.getDetailsAndDescendants(contact.getAddress(), detailClass);
    }

    public Iterator<ServerStoredDetails.GenericDetail> getDetails(Contact contact, Class<? extends ServerStoredDetails.GenericDetail> detailClass) {
        this.assertConnected();
        if (detailClass.equals(ServerStoredDetails.ImageDetail.class) && contact.getImage() != null) {
            Vector<ServerStoredDetails.ImageDetail> res = new Vector<ServerStoredDetails.ImageDetail>();
            res.add(new ServerStoredDetails.ImageDetail("Image", contact.getImage()));
            return res.iterator();
        }
        return this.infoRetreiver.getDetails(contact.getAddress(), detailClass);
    }

    public Iterator<ServerStoredDetails.GenericDetail> getAllDetailsForContact(Contact contact) {
        this.assertConnected();
        List<ServerStoredDetails.GenericDetail> res = this.infoRetreiver.getContactDetails(contact.getAddress());
        if (contact.getImage() != null) {
            res.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.ImageDetail("Image", contact.getImage()));
        }
        return res.iterator();
    }

    private void assertConnected() throws IllegalStateException {
        if (this.icqProvider == null) {
            throw new IllegalStateException("The icq provider must be non-null and signed on the ICQ service before being able to communicate.");
        }
        if (!this.icqProvider.isRegistered()) {
            throw new IllegalStateException("The icq provider must be signed on the ICQ service before being able to communicate.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<ServerStoredDetails.GenericDetail> requestAllDetailsForContact(final Contact contact, OperationSetServerStoredContactInfo.DetailsResponseListener listener) {
        this.assertConnected();
        List<ServerStoredDetails.GenericDetail> res = this.infoRetreiver.getCachedContactDetails(contact.getAddress());
        if (res != null) {
            if (contact.getImage() != null) {
                res.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.ImageDetail("Image", contact.getImage()));
            }
            return res.iterator();
        }
        Hashtable<String, List<OperationSetServerStoredContactInfo.DetailsResponseListener>> hashtable = this.listenersForDetails;
        synchronized (hashtable) {
            List<OperationSetServerStoredContactInfo.DetailsResponseListener> ls = this.listenersForDetails.get(contact.getAddress());
            boolean isFirst = false;
            if (ls == null) {
                ls = new ArrayList<OperationSetServerStoredContactInfo.DetailsResponseListener>();
                isFirst = true;
                this.listenersForDetails.put(contact.getAddress(), ls);
            }
            if (!ls.contains(listener)) {
                ls.add(listener);
            }
            if (!isFirst) {
                return null;
            }
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List listeners;
                List<ServerStoredDetails.GenericDetail> result = OperationSetServerStoredContactInfoIcqImpl.this.infoRetreiver.retrieveDetails(contact.getAddress());
                if (contact.getImage() != null && result != null) {
                    result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.ImageDetail("Image", contact.getImage()));
                }
                Hashtable hashtable = OperationSetServerStoredContactInfoIcqImpl.this.listenersForDetails;
                synchronized (hashtable) {
                    listeners = (List)OperationSetServerStoredContactInfoIcqImpl.this.listenersForDetails.remove(contact.getAddress());
                }
                if (listeners == null || result == null) {
                    return;
                }
                for (OperationSetServerStoredContactInfo.DetailsResponseListener l : listeners) {
                    try {
                        l.detailsRetrieved(result.iterator());
                    }
                    catch (Throwable t) {
                        logger.error((Object)"Error delivering for retrieved details", t);
                    }
                }
            }
        }, this.getClass().getName() + ".RetrieveDetails").start();
        return null;
    }
}

