/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import org.jetbrains.annotations.Nullable;

public class ExtraInfoBlockHolder
implements Writable {
    public static final int CODE_DEFAULT = 7;
    private final ExtraInfoBlock first;
    private final int code;
    private final ExtraInfoBlock second;
    private final int totalSize;

    @Nullable
    public static ExtraInfoBlockHolder readBlockHolder(ByteBlock origBlock) {
        DefensiveTools.checkNull(origBlock, "block");
        int origOffset = origBlock.getOffset();
        ExtraInfoBlock first = ExtraInfoBlock.readExtraInfoBlock(origBlock);
        if (first == null) {
            return null;
        }
        ByteBlock block = origBlock.subBlock(first.getTotalSize());
        if (block.getLength() < 1) {
            return null;
        }
        short code = BinaryTools.getUByte(block, 0);
        ExtraInfoBlock second = ExtraInfoBlock.readExtraInfoBlock(block = block.subBlock(1));
        if (second == null) {
            return null;
        }
        int size = block.getOffset() + second.getTotalSize() - origOffset;
        return new ExtraInfoBlockHolder(first, code, second, size);
    }

    public static ExtraInfoBlockHolder[] readBlockHolders(ByteBlock block) {
        ExtraInfoBlockHolder bh;
        ArrayList<ExtraInfoBlockHolder> list = new ArrayList<ExtraInfoBlockHolder>();
        ByteBlock next = block;
        while ((bh = ExtraInfoBlockHolder.readBlockHolder(next)) != null) {
            list.add(bh);
            next = next.subBlock(bh.getTotalSize());
        }
        return list.toArray(new ExtraInfoBlockHolder[list.size()]);
    }

    protected ExtraInfoBlockHolder(ExtraInfoBlock first, int code, ExtraInfoBlock second, int totalSize) {
        DefensiveTools.checkRange(code, "code", -1);
        DefensiveTools.checkRange(totalSize, "totalSize", -1);
        this.first = first;
        this.code = code;
        this.second = second;
        this.totalSize = totalSize;
    }

    public ExtraInfoBlockHolder(ExtraInfoBlock both) {
        this(both, 7, both);
    }

    public ExtraInfoBlockHolder(ExtraInfoBlock first, int code, ExtraInfoBlock second) {
        this(first, code, second, -1);
    }

    public final ExtraInfoBlock getFirstBlock() {
        return this.first;
    }

    public final int getCode() {
        return this.code;
    }

    public final ExtraInfoBlock getSecondBlock() {
        return this.second;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public long getWritableLength() {
        return (this.first == null ? 0L : this.first.getWritableLength()) + 1L + (this.second == null ? 0L : this.second.getWritableLength());
    }

    public void write(OutputStream out) throws IOException {
        if (this.first != null) {
            this.first.write(out);
        }
        BinaryTools.writeUByte(out, this.code);
        if (this.second != null) {
            this.second.write(out);
        }
    }

    public String toString() {
        return "ExtraInfoBlockHolder: code=" + this.code + ", first=" + this.first + ", second=" + this.second;
    }
}

