/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.phonenumbers;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.util.regex.Pattern;
import net.java.sip.communicator.service.protocol.PhoneNumberI18nService;
import net.java.sip.communicator.service.protocol.ProtocolProviderActivator;
import org.jitsi.service.configuration.ConfigurationService;

public class PhoneNumberI18nServiceImpl
implements PhoneNumberI18nService {
    private static ConfigurationService configService = ProtocolProviderActivator.getConfigurationService();
    private static final Pattern removedCharactersToNormalizedPhoneNumber = Pattern.compile("[-\\(\\)\\.\\\\\\/ ]");
    private static final Pattern removedCharactersToNormalizedIdentifier = Pattern.compile("[\\(\\) ]");
    private static final Pattern charactersFordialPadNumber2 = Pattern.compile("[abc]", 2);
    private static final Pattern charactersFordialPadNumber3 = Pattern.compile("[def]", 2);
    private static final Pattern charactersFordialPadNumber4 = Pattern.compile("[ghi]", 2);
    private static final Pattern charactersFordialPadNumber5 = Pattern.compile("[jkl]", 2);
    private static final Pattern charactersFordialPadNumber6 = Pattern.compile("[mno]", 2);
    private static final Pattern charactersFordialPadNumber7 = Pattern.compile("[pqrs]", 2);
    private static final Pattern charactersFordialPadNumber8 = Pattern.compile("[tuv]", 2);
    private static final Pattern charactersFordialPadNumber9 = Pattern.compile("[wxyz]", 2);

    public String normalize(String possibleNumber) {
        String normalizedNumber = this.isPhoneNumber(possibleNumber) ? PhoneNumberI18nServiceImpl.normalizePhoneNumber(possibleNumber) : PhoneNumberI18nServiceImpl.normalizeIdentifier(possibleNumber);
        return normalizedNumber;
    }

    private static String normalizePhoneNumber(String phoneNumber) {
        phoneNumber = PhoneNumberI18nServiceImpl.convertAlphaCharactersInNumber(phoneNumber);
        return removedCharactersToNormalizedPhoneNumber.matcher(phoneNumber).replaceAll("");
    }

    private static String normalizeIdentifier(String id) {
        return removedCharactersToNormalizedIdentifier.matcher(id).replaceAll("");
    }

    public boolean phoneNumbersMatch(String aPhoneNumber, String bPhoneNumber) {
        PhoneNumberUtil.MatchType match = PhoneNumberUtil.getInstance().isNumberMatch(aPhoneNumber, bPhoneNumber);
        return match != PhoneNumberUtil.MatchType.NOT_A_NUMBER && match != PhoneNumberUtil.MatchType.NO_MATCH;
    }

    public String formatForDisplay(String phoneNumber) {
        try {
            Phonenumber.PhoneNumber pn = PhoneNumberUtil.getInstance().parse(phoneNumber, System.getProperty("user.country"));
            if (PhoneNumberUtil.getInstance().isPossibleNumber(pn)) {
                return PhoneNumberUtil.getInstance().format(pn, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
            }
        }
        catch (NumberParseException numberParseException) {
            // empty catch block
        }
        return phoneNumber;
    }

    public boolean isPhoneNumber(String possibleNumber) {
        if (possibleNumber.indexOf(64) == -1) {
            if (!possibleNumber.matches(".*[a-zA-Z].*")) {
                return true;
            }
            String tmpPossibleNumber = possibleNumber.replaceAll(" \\(\\)", "");
            if (configService.getBoolean("impl.gui.ACCEPT_PHONE_NUMBER_WITH_ALPHA_CHARS", true) && tmpPossibleNumber.startsWith("+")) {
                return true;
            }
        }
        return false;
    }

    private static String convertAlphaCharactersInNumber(String phoneNumber) {
        phoneNumber = charactersFordialPadNumber2.matcher(phoneNumber).replaceAll("2");
        phoneNumber = charactersFordialPadNumber3.matcher(phoneNumber).replaceAll("3");
        phoneNumber = charactersFordialPadNumber4.matcher(phoneNumber).replaceAll("4");
        phoneNumber = charactersFordialPadNumber5.matcher(phoneNumber).replaceAll("5");
        phoneNumber = charactersFordialPadNumber6.matcher(phoneNumber).replaceAll("6");
        phoneNumber = charactersFordialPadNumber7.matcher(phoneNumber).replaceAll("7");
        phoneNumber = charactersFordialPadNumber8.matcher(phoneNumber).replaceAll("8");
        return charactersFordialPadNumber9.matcher(phoneNumber).replaceAll("9");
    }
}

