/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.spellcheck;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import net.java.sip.communicator.plugin.spellcheck.Word;
import net.java.sip.communicator.util.Logger;

abstract class DocUnderliner
implements DocumentListener {
    private static final Logger logger = Logger.getLogger(DocUnderliner.class);
    private static final Color UNDERLINE_COLOR = new Color(255, 100, 100);
    private static final DefaultHighlighter.DefaultHighlightPainter UNDERLINER = new DefaultHighlighter.DefaultHighlightPainter(UNDERLINE_COLOR){

        @Override
        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape area, JTextComponent comp, View view) {
            Color color = this.getColor();
            if (color == null) {
                g.setColor(comp.getSelectionColor());
            } else {
                g.setColor(color);
            }
            if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                this.drawWavyLine(g, area.getBounds());
                return area;
            }
            try {
                Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, area);
                this.drawWavyLine(g, shape.getBounds());
                return shape.getBounds();
            }
            catch (BadLocationException exc) {
                String msg = "Bad bounds (programmer error in spell checker)";
                logger.error((Object)msg, (Throwable)exc);
                return area;
            }
        }

        private void drawWavyLine(Graphics g, Rectangle bounds) {
            int y = (int)(bounds.getY() + bounds.getHeight());
            int x1 = (int)bounds.getX();
            int x2 = (int)(bounds.getX() + bounds.getWidth());
            boolean upperCurve = true;
            for (int i = x1; i < x2 - 2; i += 3) {
                if (upperCurve) {
                    g.drawArc(i, y - 2, 3, 3, 0, 180);
                } else {
                    g.drawArc(i, y - 2, 3, 3, 180, 180);
                }
                upperCurve = !upperCurve;
            }
        }
    };
    private final Highlighter docHighlighter;
    private final CaretListener endChecker = new CaretListener(){
        private boolean atEnd = false;

        @Override
        public void caretUpdate(CaretEvent event) {
            if (event.getSource() instanceof JTextComponent) {
                boolean currentlyAtEnd;
                JTextComponent comp = (JTextComponent)event.getSource();
                Document doc = comp.getDocument();
                boolean bl = currentlyAtEnd = event.getDot() == doc.getLength();
                if (DocUnderliner.this.isEnabled && this.atEnd && !currentlyAtEnd) {
                    String text = comp.getText();
                    Word changed = Word.getWord(text, text.length() - 1, false);
                    DocUnderliner.this.format(changed);
                    DocUnderliner.this.promptRepaint();
                }
                this.atEnd = currentlyAtEnd;
            }
        }
    };
    private boolean isEnabled = true;

    abstract boolean getFormatting(String var1);

    abstract int getCaretPosition();

    abstract void promptRepaint();

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        final JEditorPane editorPane = new JEditorPane();
        editorPane.setPreferredSize(new Dimension(400, 500));
        DocUnderliner formatter = new DocUnderliner(editorPane.getHighlighter()){

            @Override
            boolean getFormatting(String word) {
                return word.contains("foo");
            }

            @Override
            int getCaretPosition() {
                return editorPane.getCaretPosition();
            }

            @Override
            void promptRepaint() {
                editorPane.repaint();
            }
        };
        editorPane.getDocument().addDocumentListener(formatter);
        editorPane.addCaretListener(formatter.getEndChecker());
        frame.add(editorPane);
        frame.pack();
        frame.setVisible(true);
    }

    DocUnderliner(Highlighter docHighlighter) {
        this.docHighlighter = docHighlighter;
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        if (!this.isEnabled) {
            return;
        }
        try {
            Document doc = event.getDocument();
            String text = doc.getText(0, doc.getLength());
            if (event.getLength() == 1) {
                char changeChar = text.charAt(event.getOffset());
                if (this.getCaretPosition() == text.length() - 1) {
                    if (!Character.isLetter(changeChar)) {
                        Word last = Word.getWord(text, text.length() - 1, true);
                        this.format(last);
                    } else {
                        this.clearUnderlining(event.getOffset(), event.getOffset() + 1);
                    }
                } else if (Character.isLetter(changeChar)) {
                    int previousIndex = Math.max(0, event.getOffset() - 1);
                    Word changed = Character.isLetter(text.charAt(previousIndex)) ? Word.getWord(text, event.getOffset(), true) : Word.getWord(text, event.getOffset(), false);
                    this.format(changed);
                } else {
                    Word firstWord = Word.getWord(text, event.getOffset(), true);
                    Word secondWord = Word.getWord(text, event.getOffset() + 1, false);
                    this.format(firstWord);
                    this.format(secondWord);
                }
            } else {
                Word changed = Word.getWord(text, event.getOffset(), true);
                int wordStart = changed.getStart();
                while (wordStart < event.getOffset() + event.getLength()) {
                    this.format(changed);
                    int end = Math.min(changed.getStart() + changed.getText().length() + 1, text.length());
                    changed = Word.getWord(text, end, false);
                    wordStart = end;
                }
            }
        }
        catch (BadLocationException exc) {
            String msg = "Bad bounds (programmer error in spell checker)";
            logger.error((Object)msg, (Throwable)exc);
        }
        catch (Throwable exc) {
            logger.error((Object)"Error words processing", exc);
        }
        this.promptRepaint();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        if (!this.isEnabled) {
            return;
        }
        try {
            Document doc = event.getDocument();
            String text = doc.getText(0, doc.getLength());
            if (text.length() != 0) {
                Word changed = event.getOffset() == 0 || !Character.isLetter(text.charAt(event.getOffset() - 1)) ? Word.getWord(text, event.getOffset(), false) : Word.getWord(text, event.getOffset() - 1, true);
                this.format(changed);
            }
            this.promptRepaint();
        }
        catch (BadLocationException exc) {
            String msg = "Bad bounds (programmer error in spell checker)";
            logger.error((Object)msg, (Throwable)exc);
        }
        catch (Throwable exc) {
            logger.error((Object)"Error words processing", exc);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public CaretListener getEndChecker() {
        return this.endChecker;
    }

    public void format(Word word) {
        if (!this.isEnabled) {
            return;
        }
        String text = word.getText();
        if (text.length() > 0) {
            this.clearUnderlining(word.getStart(), word.getStart() + text.length());
            if (this.getFormatting(text)) {
                this.underlineRange(word.getStart(), word.getStart() + text.length());
            }
        }
    }

    private void underlineRange(int start, int end) {
        if (end > start) {
            try {
                if (this.isEnabled) {
                    this.docHighlighter.addHighlight(start, end, UNDERLINER);
                }
            }
            catch (BadLocationException exc) {
                String msg = "Bad bounds (programmer error in spell checker)";
                logger.error((Object)msg, (Throwable)exc);
            }
        }
    }

    private void clearUnderlining(int start, int end) {
        if (end > start && this.isEnabled) {
            for (Highlighter.Highlight highlight : this.docHighlighter.getHighlights()) {
                if ((highlight.getStartOffset() > start || highlight.getEndOffset() <= start) && (highlight.getStartOffset() >= end || highlight.getEndOffset() < end)) continue;
                this.docHighlighter.removeHighlight(highlight);
            }
        }
    }

    public void setEnabled(boolean enable, String message) {
        if (this.isEnabled != enable) {
            this.isEnabled = enable;
            if (this.isEnabled) {
                this.reset(message);
            } else {
                this.docHighlighter.removeAllHighlights();
            }
            this.promptRepaint();
        }
    }

    public void reset(String message) {
        if (!this.isEnabled) {
            return;
        }
        this.docHighlighter.removeAllHighlights();
        if (message.length() > 0) {
            Word changed = Word.getWord(message, 0, true);
            int wordStart = changed.getStart();
            while (wordStart < message.length()) {
                this.format(changed);
                int end = Math.min(changed.getStart() + changed.getText().length() + 1, message.length());
                changed = Word.getWord(message, end, false);
                wordStart = end;
            }
        }
        this.promptRepaint();
    }
}

