/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout3d;

import java.util.Date;
import java.util.Random;
import javax.media.j3d.BoundingSphere;
import javax.vecmath.Point3f;
import org.apache.commons.collections15.Transformer;

public class RandomLocationTransformer<V>
implements Transformer<V, Point3f> {
    BoundingSphere d;
    Random random;

    public RandomLocationTransformer(BoundingSphere d) {
        this(d, new Date().getTime());
    }

    public RandomLocationTransformer(BoundingSphere d, long seed) {
        this.d = d;
        this.random = new Random(seed);
    }

    private float random() {
        return (this.random.nextFloat() * 2.0f - 1.0f) * (float)this.d.getRadius();
    }

    @Override
    public Point3f transform(V v) {
        return new Point3f(this.random(), this.random(), this.random());
    }
}

