/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class LensMagnificationGraphMousePlugin
extends AbstractGraphMousePlugin
implements MouseWheelListener {
    protected float floor = 1.0f;
    protected float ceiling = 5.0f;
    protected float delta = 0.2f;

    public LensMagnificationGraphMousePlugin() {
        this(2);
    }

    public LensMagnificationGraphMousePlugin(float floor, float ceiling, float delta) {
        this(2, floor, ceiling, delta);
    }

    public LensMagnificationGraphMousePlugin(int modifiers) {
        this(modifiers, 1.0f, 4.0f, 0.2f);
    }

    public LensMagnificationGraphMousePlugin(int modifiers, float floor, float ceiling, float delta) {
        super(modifiers);
        this.floor = floor;
        this.ceiling = ceiling;
        this.delta = delta;
    }

    @Override
    public boolean checkModifiers(MouseEvent e) {
        return (e.getModifiers() & this.modifiers) != 0;
    }

    private void changeMagnification(MutableTransformer transformer, float delta) {
        if (transformer instanceof LensTransformer) {
            LensTransformer ht = (LensTransformer)transformer;
            float magnification = ht.getMagnification() + delta;
            magnification = Math.max(this.floor, magnification);
            magnification = Math.min(magnification, this.ceiling);
            ht.setMagnification(magnification);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        boolean accepted = this.checkModifiers(e);
        float delta = this.delta;
        if (accepted) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            MutableTransformer modelTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT);
            MutableTransformer viewTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW);
            int amount = e.getWheelRotation();
            if (amount < 0) {
                delta = -delta;
            }
            this.changeMagnification(modelTransformer, delta);
            this.changeMagnification(viewTransformer, delta);
            vv.repaint();
            e.consume();
        }
    }
}

