/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import lcmc.utilities.CancelCallback;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;

public final class ProgressBar
implements ActionListener {
    private JProgressBar progressBar;
    private JPanel pbPanel;
    private volatile boolean stopNow = false;
    private boolean holdIt = false;
    private int progress = 0;
    private int time = 0;
    private int timeout;
    private static final int DEFAULT_TIMEOUT = 50000;
    private Thread progressThread = null;
    private static final int DEBUG_THRESHOLD = 120000;
    private static final int MAX_PB_VALUE = 100;
    private MyButton cancelButton = null;
    private CancelCallback cancelCallback;
    private static final ImageIcon CANCEL_ICON = Tools.createImageIcon(Tools.getDefault("ProgressBar.CancelIcon"));
    private static final int HIDE_PB_AFTER = 1000;

    ProgressBar(String title, CancelCallback cancelCallback, int width, int height) {
        this.cancelCallback = cancelCallback;
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setPreferredSize(new Dimension(width, height));
        this.progressBar.setBackground(Tools.getDefaultColor("ProgressBar.Background"));
        this.progressBar.setForeground(Tools.getDefaultColor("ProgressBar.Foreground"));
        this.pbPanel = new JPanel();
        if (title != null) {
            TitledBorder titledBorder = BorderFactory.createTitledBorder(title);
            this.pbPanel.setBorder(titledBorder);
        }
        this.pbPanel.add(this.progressBar);
        if (cancelCallback != null) {
            this.cancelButton = new MyButton(Tools.getString("ProgressBar.Cancel"), CANCEL_ICON);
            this.cancelButton.setEnabled(false);
            this.cancelButton.addActionListener(this);
            this.pbPanel.add(this.cancelButton);
        }
        Dimension d = new Dimension(Short.MAX_VALUE, (int)this.pbPanel.getPreferredSize().getHeight());
        this.pbPanel.setMaximumSize(d);
        this.pbPanel.setPreferredSize(d);
        this.progressBar.setVisible(false);
        if (this.cancelButton != null) {
            this.cancelButton.setVisible(false);
        }
    }

    ProgressBar(CancelCallback cancelCallbackA, int width, int height) {
        this(null, cancelCallbackA, width, height);
    }

    public ProgressBar(String title, CancelCallback cancelCallbackA) {
        this(title, cancelCallbackA, Tools.getDefaultInt("ProgressBar.DefaultWidth"), Tools.getDefaultInt("ProgressBar.DefaultHeight"));
    }

    public ProgressBar(CancelCallback cancelCallbackA) {
        this(null, cancelCallbackA, Tools.getDefaultInt("ProgressBar.DefaultWidth"), Tools.getDefaultInt("ProgressBar.DefaultHeight"));
    }

    public void setCancelEnabled(boolean enable) {
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(enable);
        }
    }

    public void start(int t) {
        this.timeout = t;
        this.stopNow = false;
        if (this.timeout == 0) {
            this.timeout = 50000;
        }
        if (this.progressThread == null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Tools.debug(this, "running postgresbar timeout: " + ProgressBar.this.timeout, 1);
                    int sleepTime = Tools.getDefaultInt("ProgressBar.Sleep");
                    int progressBarDelay = Tools.getDefaultInt("ProgressBar.Delay");
                    int threshold = 120000;
                    boolean isVisible = false;
                    while (!ProgressBar.this.stopNow) {
                        try {
                            Thread.sleep(sleepTime);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                        if (ProgressBar.this.time > progressBarDelay && !isVisible) {
                            isVisible = true;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ProgressBar.this.progressBar.setVisible(true);
                                    if (ProgressBar.this.cancelButton != null) {
                                        ProgressBar.this.cancelButton.setVisible(true);
                                    }
                                }
                            });
                        }
                        if (!ProgressBar.this.holdIt) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ProgressBar.this.progressBar.setValue(ProgressBar.this.progress * 100 / ProgressBar.this.timeout);
                                }
                            });
                            ProgressBar.this.progress += sleepTime;
                        }
                        ProgressBar.this.time += sleepTime;
                        if (ProgressBar.this.time > threshold) {
                            Tools.appWarning("Thread with timeout: " + ProgressBar.this.timeout + " is running way too long");
                            threshold += 120000;
                        }
                        if (ProgressBar.this.progress < ProgressBar.this.timeout) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProgressBar.this.progressBar.setIndeterminate(true);
                            }
                        });
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProgressBar.this.progressBar.setIndeterminate(false);
                            ProgressBar.this.progressBar.setValue(100);
                        }
                    });
                    ProgressBar.this.progressThread = null;
                }
            };
            this.progressThread = new Thread(runnable);
            this.progressThread.start();
        } else {
            this.progress = 0;
            this.time = 0;
        }
    }

    public JPanel getProgressBarPane() {
        return this.pbPanel;
    }

    public void done() {
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(false);
        }
        this.stopNow = true;
        this.progress = this.timeout;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressBar.this.progressBar.setIndeterminate(false);
                ProgressBar.this.progressBar.setValue(100);
            }
        });
    }

    public void doneError() {
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(false);
        }
        this.stopNow = true;
        this.progress = 0;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressBar.this.progressBar.setIndeterminate(false);
                ProgressBar.this.progressBar.setValue(0);
            }
        });
    }

    void doneHide() {
        this.done();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressBar.this.progressBar.setVisible(false);
                if (ProgressBar.this.cancelButton != null) {
                    ProgressBar.this.cancelButton.setVisible(false);
                }
            }
        });
    }

    void doneErrorHide() {
        this.doneError();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressBar.this.progressBar.setVisible(false);
                if (ProgressBar.this.cancelButton != null) {
                    ProgressBar.this.cancelButton.setVisible(false);
                }
            }
        });
    }

    public void hold() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressBar.this.progressBar.setVisible(true);
                if (ProgressBar.this.cancelButton != null) {
                    ProgressBar.this.cancelButton.setVisible(true);
                }
                ProgressBar.this.progressBar.setIndeterminate(true);
            }
        });
        this.holdIt = true;
    }

    void cont() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressBar.this.progressBar.setIndeterminate(false);
            }
        });
        this.holdIt = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(Tools.getString("ProgressBar.Cancel"))) {
            Tools.debug(this, "cancel button pressed", 1);
            this.cancelCallback.cancel();
        }
    }
}

