/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.cluster;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import lcmc.data.AccessMode;
import lcmc.data.Cluster;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.cluster.DialogCluster;
import lcmc.gui.dialog.cluster.Finish;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.Corosync;
import lcmc.utilities.DRBD;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.Heartbeat;
import lcmc.utilities.MyButton;
import lcmc.utilities.Openais;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

public class Init
extends DialogCluster {
    private static final long serialVersionUID = 1L;
    private List<JLabel> drbdLoadedInfos;
    private List<MyButton> drbdLoadButtons;
    private List<JLabel> pmStartedInfos;
    private List<MyButton> pmStartButtons;
    private List<JLabel> hbStartedInfos;
    private List<MyButton> hbStartButtons;
    private JPanel mainPanel;
    private volatile boolean checkClusterStopped;
    private Boolean[] lastDrbdLoaded;
    private Boolean[] lastPmStarted;
    private Boolean[] lastPmRc;
    private Boolean[] lastPmInstalled;
    private Boolean[] lastPmConf;
    private Boolean[] lastHbStarted;
    private Boolean[] lastHbRc;
    private Boolean[] lastHbInstalled;
    private Boolean[] lastHbConf;
    private Thread checkClusterThread = null;
    private String button = null;
    private static final int CHECK_INTERVAL = 1000;
    private static final String HB_BUTTON_SWITCH = Tools.getString("Dialog.Cluster.Init.HbButtonSwitch");
    private static final String CS_AIS_BUTTON_SWITCH = Tools.getString("Dialog.Cluster.Init.CsAisButtonSwitch");
    private static final String COROSYNC_INIT_SCRIPT = "use /etc/init.d/corosync";
    private static final String OPENAIS_INIT_SCRIPT = "/etc/init.d/openais";
    private final Widget useOpenaisButton = WidgetFactory.createInstance(Widget.Type.RADIOGROUP, Widget.NO_DEFAULT, new String[]{"use /etc/init.d/corosync", "/etc/init.d/openais"}, Widget.NO_REGEXP, 0, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.ADMIN, false), Widget.NO_BUTTON);

    public Init(WizardDialog previousDialog, Cluster cluster) {
        super(previousDialog, cluster);
        this.setButton(this.finishButton());
    }

    private void setButton(String button) {
        this.button = button;
    }

    private void stopCheckCluster() {
        this.checkClusterStopped = true;
    }

    @Override
    public final WizardDialog getPreviousDialog() {
        this.stopCheckCluster();
        return super.getPreviousDialog();
    }

    @Override
    protected final void finishDialog() {
        this.stopCheckCluster();
    }

    @Override
    public final void cancelDialog() {
        this.stopCheckCluster();
    }

    @Override
    public final WizardDialog nextDialog() {
        this.stopCheckCluster();
        return new Finish(this, this.getCluster());
    }

    @Override
    protected final String getClusterDialogTitle() {
        return Tools.getString("Dialog.Cluster.Init.Title");
    }

    @Override
    protected final String getDescription() {
        return Tools.getString("Dialog.Cluster.Init.Description");
    }

    @Override
    protected final void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[0]);
    }

    @Override
    protected void initDialogAfterVisible() {
        this.lastDrbdLoaded = null;
        this.lastPmStarted = null;
        this.lastPmRc = null;
        this.lastHbStarted = null;
        this.lastHbRc = null;
        this.checkClusterStopped = false;
        this.checkClusterThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!Init.this.checkClusterStopped) {
                    Init.this.checkCluster(true);
                    if (Init.this.checkClusterStopped) continue;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                Init.this.checkClusterThread = null;
            }
        });
        this.checkClusterThread.start();
    }

    private void checkCluster(boolean periodic) {
        boolean lastHbStartedExists;
        boolean lastPmStartedExists;
        boolean lastDrbdLoadedExists;
        Host[] hosts = this.getCluster().getHostsArray();
        SSH.ExecCommandThread[] infoThreads = new SSH.ExecCommandThread[hosts.length];
        int i = 0;
        for (final Host h : hosts) {
            infoThreads[i] = h.execCommand("Cluster.Init.getInstallationInfo", null, new ExecCallback(){

                @Override
                public void done(String ans) {
                    for (String line : ans.split("\\r?\\n")) {
                        h.parseInstallationInfo(line);
                    }
                }

                @Override
                public void doneError(String ans, int exitCode) {
                    Tools.appWarning("could not get install info");
                }
            }, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
            ++i;
        }
        for (SSH.ExecCommandThread t : infoThreads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        i = 0;
        boolean oneFailed = false;
        boolean oneChanged = false;
        boolean bl = lastDrbdLoadedExists = this.lastDrbdLoaded != null;
        if (!lastDrbdLoadedExists) {
            this.lastDrbdLoaded = new Boolean[hosts.length];
        }
        boolean bl2 = lastPmStartedExists = this.lastPmStarted != null;
        if (!lastPmStartedExists) {
            this.lastPmStarted = new Boolean[hosts.length];
            this.lastPmRc = new Boolean[hosts.length];
            this.lastPmConf = new Boolean[hosts.length];
            this.lastPmInstalled = new Boolean[hosts.length];
        }
        boolean bl3 = lastHbStartedExists = this.lastHbStarted != null;
        if (!lastHbStartedExists) {
            this.lastHbStarted = new Boolean[hosts.length];
            this.lastHbRc = new Boolean[hosts.length];
            this.lastHbConf = new Boolean[hosts.length];
            this.lastHbInstalled = new Boolean[hosts.length];
        }
        boolean needOpenaisButton = false;
        for (Host h : hosts) {
            boolean drbdFailed = false;
            boolean csAisFailed = false;
            boolean hbFailed = false;
            boolean drbdLoadedChanged = false;
            boolean drbdLoaded = h.isDrbdLoaded();
            if (lastDrbdLoadedExists) {
                if (this.lastDrbdLoaded[i] != drbdLoaded) {
                    oneChanged = true;
                    drbdLoadedChanged = true;
                    this.lastDrbdLoaded[i] = drbdLoaded;
                }
            } else {
                oneChanged = true;
                drbdLoadedChanged = true;
                this.lastDrbdLoaded[i] = drbdLoaded;
            }
            final JLabel drbdLoadedInfo = this.drbdLoadedInfos.get(i);
            if (drbdLoaded) {
                if (drbdLoadedChanged) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            drbdLoadedInfo.setText(Tools.getString("Dialog.Cluster.Init.DrbdIsLoaded"));
                            drbdLoadedInfo.setForeground(Color.BLACK);
                        }
                    });
                }
            } else {
                drbdFailed = true;
                if (drbdLoadedChanged) {
                    final MyButton drbdLoadButton = this.drbdLoadButtons.get(i);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            drbdLoadedInfo.setText(Tools.getString("Dialog.Cluster.Init.DrbdIsNotLoaded"));
                            drbdLoadedInfo.setForeground(Color.RED);
                            drbdLoadButton.setVisible(true);
                        }
                    });
                }
            }
            final boolean csAisIsInstalled = h.getOpenaisVersion() != null || h.getCorosyncVersion() != null;
            final boolean csAisRunning = h.isCsRunning() || h.isAisRunning();
            final boolean csAisIsRc = h.isCsRc() || h.isAisRc();
            final boolean csAisIsConf = h.isCsAisConf();
            final boolean heartbeatIsInstalled = h.getHeartbeatVersion() != null;
            final boolean heartbeatIsRunning = h.isHeartbeatRunning();
            final boolean heartbeatIsRc = h.isHeartbeatRc();
            final boolean heartbeatIsConf = h.isHeartbeatConf();
            if (!csAisRunning && h.isCsInit() && h.isAisInit()) {
                needOpenaisButton = true;
            }
            boolean hbChanged = false;
            boolean csAisChanged = false;
            if (lastPmStartedExists) {
                if (this.lastPmStarted[i] != csAisRunning) {
                    oneChanged = true;
                    csAisChanged = true;
                    this.lastPmStarted[i] = csAisRunning;
                }
                if (this.lastPmRc[i] != csAisIsRc) {
                    oneChanged = true;
                    csAisChanged = true;
                    this.lastPmRc[i] = csAisIsRc;
                }
                if (this.lastPmConf[i] != csAisIsConf) {
                    oneChanged = true;
                    csAisChanged = true;
                    this.lastPmConf[i] = csAisIsConf;
                }
                if (this.lastPmInstalled[i] != csAisIsInstalled) {
                    oneChanged = true;
                    csAisChanged = true;
                    this.lastPmInstalled[i] = csAisIsInstalled;
                }
                if (this.lastHbStarted[i] != heartbeatIsRunning) {
                    oneChanged = true;
                    hbChanged = true;
                    this.lastHbStarted[i] = heartbeatIsRunning;
                }
                if (this.lastHbRc[i] != heartbeatIsRc) {
                    oneChanged = true;
                    hbChanged = true;
                    this.lastHbRc[i] = heartbeatIsRc;
                }
                if (this.lastHbConf[i] != heartbeatIsConf) {
                    oneChanged = true;
                    hbChanged = true;
                    this.lastHbConf[i] = heartbeatIsConf;
                }
                if (this.lastHbInstalled[i] != heartbeatIsInstalled) {
                    oneChanged = true;
                    hbChanged = true;
                    this.lastHbInstalled[i] = heartbeatIsInstalled;
                }
            } else {
                oneChanged = true;
                csAisChanged = true;
                this.lastPmStarted[i] = csAisRunning;
                this.lastPmRc[i] = csAisIsRc;
                this.lastPmConf[i] = csAisIsConf;
                this.lastPmInstalled[i] = csAisIsInstalled;
                hbChanged = true;
                this.lastHbStarted[i] = heartbeatIsRunning;
                this.lastHbRc[i] = heartbeatIsRc;
                this.lastHbConf[i] = heartbeatIsConf;
                this.lastHbInstalled[i] = heartbeatIsInstalled;
            }
            final JLabel pmStartedInfo = this.pmStartedInfos.get(i);
            final MyButton csAisStartButton = this.pmStartButtons.get(i);
            String is = "Corosync";
            if (!this.useCorosync(h) && h.getOpenaisVersion() != null) {
                is = "OpenAIS";
            }
            final String initScript = is;
            if (csAisRunning) {
                if (csAisChanged || hbChanged) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            pmStartedInfo.setText(initScript + Tools.getString("Dialog.Cluster.Init.CsAisIsRunning"));
                            pmStartedInfo.setForeground(Color.BLACK);
                            if (csAisIsRc) {
                                csAisStartButton.setVisible(false);
                                pmStartedInfo.setText(initScript + Tools.getString("Dialog.Cluster.Init.CsAisIsRc"));
                            } else if (heartbeatIsRunning || heartbeatIsRc) {
                                csAisStartButton.setText(CS_AIS_BUTTON_SWITCH);
                                csAisStartButton.setVisible(true);
                            } else {
                                csAisStartButton.setText(Tools.getString("Dialog.Cluster.Init.CsAisButtonRc"));
                                csAisStartButton.setVisible(true);
                            }
                        }
                    });
                }
            } else {
                csAisFailed = true;
                if (csAisChanged || hbChanged) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (heartbeatIsRunning || heartbeatIsRc) {
                                csAisStartButton.setText(CS_AIS_BUTTON_SWITCH);
                            } else {
                                csAisStartButton.setText(Tools.getString("Dialog.Cluster.Init.StartCsAisButton"));
                            }
                            if (!csAisIsInstalled) {
                                pmStartedInfo.setText(initScript + Tools.getString("Dialog.Cluster.Init.CsAisIsNotInstalled"));
                                csAisStartButton.setEnabled(false);
                            } else if (!csAisIsConf) {
                                pmStartedInfo.setText(initScript + Tools.getString("Dialog.Cluster.Init.CsAisIsNotConfigured"));
                                csAisStartButton.setEnabled(false);
                            } else {
                                pmStartedInfo.setText(initScript + Tools.getString("Dialog.Cluster.Init.CsAisIsStopped"));
                                if (heartbeatIsRunning) {
                                    csAisStartButton.setEnabled(false);
                                } else {
                                    Tools.getGUIData().setAccessible(csAisStartButton, ConfigData.AccessType.OP);
                                }
                            }
                            csAisStartButton.setVisible(true);
                            pmStartedInfo.setForeground(Color.RED);
                        }
                    });
                }
            }
            final JLabel hbStartedInfo = this.hbStartedInfos.get(i);
            final MyButton hbStartButton = this.hbStartButtons.get(i);
            if (heartbeatIsRunning) {
                if (hbChanged || csAisChanged) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            hbStartedInfo.setText(Tools.getString("Dialog.Cluster.Init.HbIsRunning"));
                            hbStartedInfo.setForeground(Color.BLACK);
                            if (heartbeatIsRc) {
                                hbStartButton.setVisible(false);
                                hbStartedInfo.setText(Tools.getString("Dialog.Cluster.Init.HbIsRc"));
                            } else if (csAisRunning || csAisIsRc) {
                                hbStartButton.setText(HB_BUTTON_SWITCH);
                                hbStartButton.setVisible(true);
                            } else {
                                hbStartButton.setText(Tools.getString("Dialog.Cluster.Init.HbButtonRc"));
                                hbStartButton.setVisible(true);
                            }
                        }
                    });
                }
            } else {
                hbFailed = true;
                if (hbChanged || csAisChanged) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (csAisRunning || csAisIsRc) {
                                hbStartButton.setText(HB_BUTTON_SWITCH);
                            } else {
                                hbStartButton.setText(Tools.getString("Dialog.Cluster.Init.StartHbButton"));
                            }
                            if (!heartbeatIsInstalled) {
                                hbStartedInfo.setText(Tools.getString("Dialog.Cluster.Init.HbIsNotInstalled"));
                                hbStartButton.setEnabled(false);
                            } else if (!heartbeatIsConf) {
                                hbStartedInfo.setText(Tools.getString("Dialog.Cluster.Init.HbIsNotConfigured"));
                                hbStartButton.setEnabled(false);
                            } else {
                                hbStartedInfo.setText(Tools.getString("Dialog.Cluster.Init.HbIsStopped"));
                                if (csAisRunning) {
                                    hbStartButton.setEnabled(false);
                                } else {
                                    Tools.getGUIData().setAccessible(hbStartButton, ConfigData.AccessType.OP);
                                }
                            }
                            hbStartButton.setVisible(true);
                            hbStartedInfo.setForeground(Color.RED);
                        }
                    });
                }
            }
            if (drbdFailed || csAisFailed && hbFailed) {
                oneFailed = true;
            }
            ++i;
        }
        final boolean nob = needOpenaisButton;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Init.this.useOpenaisButton.setEnabled(nob);
            }
        });
        if (oneChanged || !periodic) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Init.this.mainPanel.invalidate();
                    Init.this.mainPanel.validate();
                    Init.this.mainPanel.repaint();
                }
            });
            if (oneFailed) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Init.this.buttonClass(Init.this.button).setEnabled(false);
                    }
                });
                this.nextButtonSetEnabled(false);
            } else {
                this.nextButtonSetEnabled(true);
            }
            this.enableComponents();
            if (!Tools.getConfigData().getAutoClusters().isEmpty()) {
                Tools.sleep(1000);
                this.pressNextButton();
            }
        }
    }

    @Override
    protected final JComponent getInputPane() {
        Thread t = this.checkClusterThread;
        if (t != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.drbdLoadedInfos = new ArrayList<JLabel>();
        this.drbdLoadButtons = new ArrayList<MyButton>();
        this.pmStartedInfos = new ArrayList<JLabel>();
        this.pmStartButtons = new ArrayList<MyButton>();
        this.hbStartedInfos = new ArrayList<JLabel>();
        this.hbStartButtons = new ArrayList<MyButton>();
        this.mainPanel = new JPanel(new GridLayout(1, 0));
        Host[] hosts = this.getCluster().getHostsArray();
        int i = 0;
        boolean oneStartedAsOpenais = false;
        boolean noCorosync = false;
        for (final Host host : hosts) {
            final int index = i;
            SpringLayout layout = new SpringLayout();
            JPanel pane = new JPanel(layout);
            pane.setAlignmentX(0.0f);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(host.getName());
            titledBorder.setTitleJustification(1);
            pane.setBorder(titledBorder);
            this.drbdLoadedInfos.add(new JLabel(Tools.getString("Dialog.Cluster.Init.CheckingDrbd")));
            MyButton drbdb = new MyButton(Tools.getString("Dialog.Cluster.Init.LoadDrbdButton"));
            drbdb.setBackgroundColor(Tools.getDefaultColor("ConfigDialog.Button"));
            this.drbdLoadButtons.add(drbdb);
            this.drbdLoadButtons.get(i).setVisible(false);
            this.drbdLoadButtons.get(i).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((MyButton)Init.this.drbdLoadButtons.get(index)).setVisible(false);
                                }
                            });
                            boolean testOnly = false;
                            DRBD.load(host, false);
                            if (host.isDrbdUpgraded()) {
                                DRBD.adjust(host, "all", null, false);
                            }
                            Init.this.checkCluster(false);
                        }
                    });
                    thread.start();
                }
            });
            pane.add(this.drbdLoadedInfos.get(i));
            pane.add(this.drbdLoadButtons.get(i));
            this.hbStartedInfos.add(new JLabel(Tools.getString("Dialog.Cluster.Init.CheckingHb")));
            MyButton button = host.isCsRunning() || host.isAisRunning() || host.isCsRc() || host.isAisRc() ? new MyButton(HB_BUTTON_SWITCH) : new MyButton(Tools.getString("Dialog.Cluster.Init.StartHbButton"));
            button.setBackgroundColor(Tools.getDefaultColor("ConfigDialog.Button"));
            this.hbStartButtons.add(button);
            this.hbStartButtons.get(i).setVisible(false);
            this.hbStartButtons.get(i).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(final ActionEvent e) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Init.this.disableComponents();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((MyButton)Init.this.hbStartButtons.get(index)).setVisible(false);
                                }
                            });
                            if (Tools.getString("Dialog.Cluster.Init.HbButtonRc").equals(e.getActionCommand())) {
                                Heartbeat.addHeartbeatToRc(host);
                            } else if (Init.this.useCorosync(host) && HB_BUTTON_SWITCH.equals(e.getActionCommand())) {
                                Heartbeat.switchFromCorosyncToHeartbeat(host);
                            } else if (!Init.this.useCorosync(host) && HB_BUTTON_SWITCH.equals(e.getActionCommand())) {
                                Heartbeat.switchFromOpenaisToHeartbeat(host);
                            } else if (host.isHeartbeatRc()) {
                                Heartbeat.startHeartbeat(host);
                            } else {
                                Heartbeat.startHeartbeatRc(host);
                            }
                            Init.this.checkCluster(false);
                        }
                    });
                    thread.start();
                }
            });
            pane.add(this.hbStartedInfos.get(i));
            pane.add(this.hbStartButtons.get(i));
            this.pmStartedInfos.add(new JLabel(Tools.getString("Dialog.Cluster.Init.CheckingPm")));
            MyButton pmsb = new MyButton(Tools.getString("Dialog.Cluster.Init.StartCsAisButton"));
            pmsb.setBackgroundColor(Tools.getDefaultColor("ConfigDialog.Button"));
            this.pmStartButtons.add(pmsb);
            this.pmStartButtons.get(i).setVisible(false);
            this.pmStartButtons.get(i).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(final ActionEvent e) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Init.this.disableComponents();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((MyButton)Init.this.pmStartButtons.get(index)).setVisible(false);
                                }
                            });
                            if (Tools.getString("Dialog.Cluster.Init.CsAisButtonRc").equals(e.getActionCommand())) {
                                if (Init.this.useCorosync(host)) {
                                    Corosync.addCorosyncToRc(host);
                                } else {
                                    Openais.addOpenaisToRc(host);
                                }
                            } else if (CS_AIS_BUTTON_SWITCH.equals(e.getActionCommand())) {
                                if (Init.this.useCorosync(host)) {
                                    Corosync.switchToCorosync(host);
                                } else {
                                    Openais.switchToOpenais(host);
                                }
                            } else if (host.isCsRc() || host.isAisRc()) {
                                if (Init.this.useCorosync(host)) {
                                    Corosync.startCorosync(host);
                                } else {
                                    Openais.startOpenais(host);
                                }
                            } else if (Init.this.useCorosync(host)) {
                                Corosync.startCorosyncRc(host);
                            } else {
                                Openais.startOpenaisRc(host);
                            }
                            Init.this.checkCluster(false);
                        }
                    });
                    thread.start();
                }
            });
            if (host.isCsRunning() && host.isAisRunning()) {
                oneStartedAsOpenais = true;
            }
            if (!host.isCsInit()) {
                noCorosync = true;
            }
            pane.add(this.pmStartedInfos.get(i));
            pane.add(this.pmStartButtons.get(i));
            ++i;
            SpringUtilities.makeCompactGrid(pane, 3, 2, 1, 1, 1, 0);
            this.mainPanel.add(pane);
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JScrollPane s = new JScrollPane(this.mainPanel);
        if (oneStartedAsOpenais || noCorosync) {
            this.useOpenaisButton.setValue(OPENAIS_INIT_SCRIPT);
        } else {
            this.useOpenaisButton.setValue(COROSYNC_INIT_SCRIPT);
        }
        this.useOpenaisButton.setEnabled(false);
        this.useOpenaisButton.setBackgroundColor(Color.WHITE);
        this.useOpenaisButton.setMaximumSize(this.useOpenaisButton.getMinimumSize());
        p.add(this.useOpenaisButton);
        p.add(s);
        return p;
    }

    @Override
    protected final boolean skipButtonEnabled() {
        return true;
    }

    private boolean useCorosync(Host host) {
        if (!host.isCorosync() || !host.isCsInit()) {
            return false;
        }
        if (host.isCsInit() && COROSYNC_INIT_SCRIPT.equals(this.useOpenaisButton.getStringValue())) {
            return true;
        }
        return !host.isAisInit();
    }
}

