/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.vm;

import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.vm.Display;
import lcmc.gui.dialog.vm.Finish;
import lcmc.gui.dialog.vm.VMConfig;
import lcmc.gui.resources.VMSInterfaceInfo;
import lcmc.gui.resources.VMSVirtualDomainInfo;
import lcmc.utilities.Tools;

final class Network
extends VMConfig {
    private static final long serialVersionUID = 1L;
    private JComponent inputPane = null;
    private static final String[] PARAMS = new String[]{"type", "mac_address", "source_network", "source_bridge", "script_path", "model_type"};
    private VMSInterfaceInfo vmsii = null;
    private WizardDialog nextDialogObject = null;

    Network(WizardDialog previousDialog, VMSVirtualDomainInfo vmsVirtualDomainInfo) {
        super(previousDialog, vmsVirtualDomainInfo);
    }

    @Override
    public WizardDialog nextDialog() {
        if (this.nextDialogObject == null) {
            this.nextDialogObject = this.getVMSVirtualDomainInfo().needDisplay() ? new Display(this, this.getVMSVirtualDomainInfo()) : new Finish(this, this.getVMSVirtualDomainInfo());
        }
        return this.nextDialogObject;
    }

    @Override
    protected String getDialogTitle() {
        return Tools.getString("Dialog.vm.Network.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.vm.Network.Description");
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        this.enableComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean enable = Network.this.vmsii.checkResourceFieldsCorrect(null, Network.this.vmsii.getRealParametersFromXML());
                Network.this.buttonClass(Network.this.nextButton()).setEnabled(enable);
            }
        });
    }

    @Override
    protected JComponent getInputPane() {
        if (this.vmsii != null) {
            this.vmsii.selectMyself();
        }
        if (this.inputPane != null) {
            return this.inputPane;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.setAlignmentY(0.0f);
        if (this.vmsii == null) {
            this.vmsii = this.getVMSVirtualDomainInfo().addInterfacePanel();
            this.vmsii.waitForInfoPanel();
        }
        this.vmsii.savePreferredValues();
        this.vmsii.getResource().setValue("type", "network");
        this.vmsii.getResource().setValue("source_network", "default");
        this.vmsii.getResource().setValue("model_type", "");
        this.vmsii.addWizardParams(optionsPanel, PARAMS, this.buttonClass(this.nextButton()), Tools.getDefaultSize("Dialog.vm.Resource.LabelWidth"), Tools.getDefaultSize("Dialog.vm.Resource.FieldWidth"), null);
        this.vmsii.getWidget("model_type", "widget").setValue("");
        panel.add(optionsPanel);
        JScrollPane sp = new JScrollPane(panel);
        sp.setMaximumSize(new Dimension(Short.MAX_VALUE, 200));
        sp.setPreferredSize(new Dimension(Short.MAX_VALUE, 200));
        this.inputPane = sp;
        return sp;
    }
}

