/*
 * Decompiled with CFR 0.152.
 */
package lcmc.utilities;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lcmc.Exceptions;
import lcmc.data.Host;
import lcmc.utilities.ConvertCmdCallback;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

public final class DRBD {
    private static final String DEVICE_PH = "@DEVICE@";
    private static final String RESOURCE_VOLUME_PH = "@RES-VOL@";
    private static final String DRBDDEV_PH = "@DRBDDEV@";
    private static final String FILESYSTEM_PH = "@FILESYSTEM@";
    private static volatile String drbdtestOutput = null;
    private static final ReadWriteLock M_DRBD_TEST_LOCK = new ReentrantReadWriteLock();
    private static final Lock M_DRBD_TEST_READLOCK = M_DRBD_TEST_LOCK.readLock();
    private static final Lock M_DRBD_TEST_WRITELOCK = M_DRBD_TEST_LOCK.writeLock();
    public static final String ALL = "all";
    public static final boolean TESTONLY = true;
    public static final boolean LIVE = false;

    private DRBD() {
    }

    private static SSH.SSHOutput execCommand(Host host, String command, ExecCallback execCallback, boolean outputVisible, boolean testOnly) {
        if (testOnly) {
            if (command.indexOf("@DRYRUN@") < 0) {
                Tools.appError("dry run not available");
                return null;
            }
            String cmd = command.replaceAll("@DRYRUN@", "-d");
            if (cmd.indexOf("@DRYRUNCONF@") >= 0) {
                cmd = cmd.replaceAll("@DRYRUNCONF@", "-c /var/lib/drbd/drbd.conf-lcmc-test");
            }
            SSH.SSHOutput output = Tools.execCommand(host, cmd, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
            M_DRBD_TEST_WRITELOCK.lock();
            drbdtestOutput = drbdtestOutput == null ? output.getOutput() : drbdtestOutput + output.getOutput();
            M_DRBD_TEST_WRITELOCK.unlock();
            return output;
        }
        String cmd = command.indexOf("@DRYRUN@") >= 0 ? command.replaceAll("@DRYRUN@", "") : command;
        cmd = cmd.replaceAll("@DRYRUNCONF@", "");
        return Tools.execCommandProgressIndicator(host, cmd, execCallback, outputVisible, Tools.getString("DRBD.ExecutingCommand") + " " + cmd.replaceAll("@DMCSUDO@", " ") + "...", SSH.DEFAULT_COMMAND_TIMEOUT);
    }

    public static String getDRBDtest() {
        M_DRBD_TEST_READLOCK.lock();
        String out = drbdtestOutput;
        drbdtestOutput = null;
        M_DRBD_TEST_READLOCK.unlock();
        return out;
    }

    public static boolean attach(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.attach(host, resource, volume, null, testOnly);
    }

    private static Map<String, String> getResVolReplaceHash(Host host, String resource, String volume) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        if (volume != null && host.hasVolumes()) {
            replaceHash.put(RESOURCE_VOLUME_PH, resource + "/" + volume);
        } else {
            replaceHash.put(RESOURCE_VOLUME_PH, resource);
        }
        return replaceHash;
    }

    public static boolean attach(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.attach", DRBD.getResVolReplaceHash(host, resource, volume));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean detach(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.detach(host, resource, volume, null, testOnly);
    }

    public static boolean detach(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.detach", DRBD.getResVolReplaceHash(host, resource, volume));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean connect(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.connect(host, resource, volume, null, testOnly);
    }

    public static boolean connect(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.connect", DRBD.getResVolReplaceHash(host, resource, volume));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean disconnect(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.disconnect(host, resource, volume, null, testOnly);
    }

    public static boolean disconnect(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.disconnect", DRBD.getResVolReplaceHash(host, resource, volume));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean pauseSync(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.pauseSync(host, resource, volume, null, testOnly);
    }

    public static boolean pauseSync(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.pauseSync", DRBD.getResVolReplaceHash(host, resource, volume));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean resumeSync(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.resumeSync(host, resource, volume, null, testOnly);
    }

    public static boolean resumeSync(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.resumeSync", DRBD.getResVolReplaceHash(host, resource, volume));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean setPrimary(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.setPrimary(host, resource, volume, null, testOnly);
    }

    public static boolean setPrimary(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.setPrimary", DRBD.getResVolReplaceHash(host, resource, volume));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean setSecondary(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.setSecondary(host, resource, volume, null, testOnly);
    }

    public static boolean setSecondary(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.setSecondary", DRBD.getResVolReplaceHash(host, resource, volume));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean initDrbd(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.initDrbd(host, resource, volume, null, testOnly);
    }

    public static boolean initDrbd(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.initDrbd", DRBD.getResVolReplaceHash(host, resource, volume));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean createMD(Host host, String resource, String volume, String device, boolean testOnly) {
        return DRBD.createMD(host, resource, volume, device, null, testOnly);
    }

    public static boolean createMD(Host host, String resource, String volume, String device, ExecCallback execCallback, boolean testOnly) {
        Map<String, String> replaceHash = DRBD.getResVolReplaceHash(host, resource, volume);
        replaceHash.put(DEVICE_PH, device);
        String command = host.getDistCommand("DRBD.createMD", replaceHash);
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean createMDDestroyData(Host host, String resource, String volume, String device, boolean testOnly) {
        return DRBD.createMDDestroyData(host, resource, volume, device, null, testOnly);
    }

    public static boolean createMDDestroyData(Host host, String resource, String volume, String device, ExecCallback execCallback, boolean testOnly) {
        Map<String, String> replaceHash = DRBD.getResVolReplaceHash(host, resource, volume);
        replaceHash.put(DEVICE_PH, device);
        String command = host.getDistCommand("DRBD.createMDDestroyData", replaceHash);
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean makeFilesystem(Host host, String blockDevice, String filesystem, boolean testOnly) {
        return DRBD.makeFilesystem(host, blockDevice, filesystem, null, testOnly);
    }

    public static boolean makeFilesystem(Host host, String blockDevice, String filesystem, ExecCallback execCallback, boolean testOnly) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put(DRBDDEV_PH, blockDevice);
        if ("jfs".equals(filesystem) || "reiserfs".equals(filesystem)) {
            replaceHash.put(FILESYSTEM_PH, filesystem + " -q");
        } else {
            replaceHash.put(FILESYSTEM_PH, filesystem);
        }
        String command = host.getDistCommand("DRBD.makeFilesystem", replaceHash);
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean skipInitialFullSync(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.skipInitialFullSync(host, resource, volume, null, testOnly);
    }

    public static boolean skipInitialFullSync(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        try {
            String drbdV = host.getDrbdVersion();
            String command = Tools.compareVersions(host.getDrbdVersion(), "8.3") <= 0 ? host.getDistCommand("DRBD.skipInitSync.8.3", DRBD.getResVolReplaceHash(host, resource, volume)) : host.getDistCommand("DRBD.skipInitSync", DRBD.getResVolReplaceHash(host, resource, volume));
            SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
            return ret.getExitCode() == 0;
        }
        catch (Exceptions.IllegalVersionException e) {
            Tools.appWarning(e.getMessage(), e);
            return false;
        }
    }

    public static boolean forcePrimary(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.forcePrimary(host, resource, volume, null, testOnly);
    }

    public static boolean forcePrimary(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        try {
            String drbdV = host.getDrbdVersion();
            String command = Tools.compareVersions(host.getDrbdVersion(), "8.3.7") <= 0 ? host.getDistCommand("DRBD.forcePrimary.8.3.7", DRBD.getResVolReplaceHash(host, resource, volume)) : (Tools.compareVersions(host.getDrbdVersion(), "8.3") <= 0 ? host.getDistCommand("DRBD.forcePrimary.8.3", DRBD.getResVolReplaceHash(host, resource, volume)) : host.getDistCommand("DRBD.forcePrimary", DRBD.getResVolReplaceHash(host, resource, volume)));
            SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
            return ret.getExitCode() == 0;
        }
        catch (Exceptions.IllegalVersionException e) {
            Tools.appWarning(e.getMessage(), e);
            return false;
        }
    }

    public static boolean invalidate(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.invalidate(host, resource, volume, null, testOnly);
    }

    public static boolean invalidate(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.invalidate", DRBD.getResVolReplaceHash(host, resource, volume));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean discardData(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.discardData(host, resource, volume, null, testOnly);
    }

    public static boolean discardData(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.discardData", DRBD.getResVolReplaceHash(host, resource, volume));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean resize(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.resize(host, resource, volume, null, testOnly);
    }

    public static boolean resize(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.resize", DRBD.getResVolReplaceHash(host, resource, volume));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean verify(Host host, String resource, String volume, boolean testOnly) {
        String command = host.getDistCommand("DRBD.verify", DRBD.getResVolReplaceHash(host, resource, volume));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, null, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static int adjust(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.adjust(host, resource, null, null, testOnly);
    }

    public static int adjust(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.adjust", DRBD.getResVolReplaceHash(host, resource, volume));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, false, testOnly);
        Pattern p = Pattern.compile(".*Failure: \\((\\d+)\\).*", 32);
        Matcher m = p.matcher(ret.getOutput());
        if (m.matches()) {
            return Integer.parseInt(m.group(1));
        }
        return 0;
    }

    public static int proxyUp(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.proxyUp(host, resource, null, null, testOnly);
    }

    public static int proxyUp(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        String command = DRBD.getDistCommand("DRBD.proxyUp", host, resource, volume);
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, false, testOnly);
        return ret.getExitCode();
    }

    public static int proxyDown(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.proxyDown(host, resource, null, null, testOnly);
    }

    public static int proxyDown(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.proxyDown", DRBD.getResVolReplaceHash(host, resource, volume));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, false, testOnly);
        return ret.getExitCode();
    }

    public static String getGI(Host host, String resource, String volume, boolean testOnly) {
        String command = host.getDistCommand("DRBD.get-gi", DRBD.getResVolReplaceHash(host, resource, volume));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, null, false, testOnly);
        if (ret.getExitCode() == 0) {
            return ret.getOutput();
        }
        return null;
    }

    public static void adjustDryrun(Host host, String resource, String volume) {
        DRBD.adjustDryrun(host, resource, volume, null);
    }

    public static void adjustDryrun(Host host, String resource, String volume, ExecCallback execCallback) {
        String command = host.getDistCommand("DRBD.adjust.dryrun", DRBD.getResVolReplaceHash(host, resource, volume));
        DRBD.execCommand(host, command, execCallback, true, false);
    }

    public static boolean down(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.down(host, resource, volume, null, testOnly);
    }

    public static boolean down(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.down", DRBD.getResVolReplaceHash(host, resource, volume));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean up(Host host, String resource, String volume, boolean testOnly) {
        return DRBD.up(host, resource, volume, null, testOnly);
    }

    public static boolean up(Host host, String resource, String volume, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.up", DRBD.getResVolReplaceHash(host, resource, volume));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean start(Host host, boolean testOnly) {
        return DRBD.start(host, null, testOnly);
    }

    public static boolean start(Host host, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.start", (ConvertCmdCallback)null);
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean load(Host host, boolean testOnly) {
        return DRBD.load(host, null, testOnly);
    }

    public static boolean load(Host host, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.load", (ConvertCmdCallback)null);
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean startProxy(Host host, boolean testOnly) {
        return DRBD.startProxy(host, null, testOnly);
    }

    public static boolean startProxy(Host host, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.startProxy", (ConvertCmdCallback)null);
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        host.updateDrbdParameters();
        return ret.getExitCode() == 0;
    }

    public static boolean stopProxy(Host host, boolean testOnly) {
        return DRBD.stopProxy(host, null, testOnly);
    }

    public static boolean stopProxy(Host host, ExecCallback execCallback, boolean testOnly) {
        String command = host.getDistCommand("DRBD.stopProxy", (ConvertCmdCallback)null);
        SSH.SSHOutput ret = DRBD.execCommand(host, command, execCallback, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean delMinor(Host host, String blockDevice, boolean testOnly) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put(DRBDDEV_PH, blockDevice);
        String command = host.getDistCommand("DRBD.delMinor", replaceHash);
        SSH.SSHOutput ret = DRBD.execCommand(host, command, null, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean delConnection(Host host, String resource, boolean testOnly) {
        String command = host.getDistCommand("DRBD.resDelConnection", DRBD.getResVolReplaceHash(host, resource, null));
        SSH.SSHOutput ret = DRBD.execCommand(host, command, null, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static String getDistCommand(String cmd, Host host, String resource, String volume) {
        return host.getDistCommand(cmd, DRBD.getResVolReplaceHash(host, resource, volume));
    }
}

