/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rdr.InStream;
import rdr.OutStream;
import rfb.Encoder;
import rfb.Exception;
import rfb.PixelFormat;

public class ConnParams {
    public int majorVersion;
    public int minorVersion;
    public int width;
    public int height;
    public String name;
    public boolean useCopyRect;
    public boolean supportsLocalCursor;
    public boolean supportsDesktopResize;
    private PixelFormat pf_;
    private int nEncodings_;
    private int[] encodings_;
    private int currentEncoding_;

    public boolean readVersion(InStream is) {
        byte[] b = new byte[12];
        is.readBytes(b, 0, 12);
        try {
            if (b[0] != 82 || b[1] != 70 || b[2] != 66 || b[3] != 32 || b[4] < 48 || b[4] > 57 || b[5] < 48 || b[5] > 57 || b[6] < 48 || b[6] > 57 || b[7] != 46 || b[8] < 48 || b[8] > 57 || b[9] < 48 || b[9] > 57 || b[10] < 48 || b[10] > 57 || b[11] != 10) {
                return false;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        this.majorVersion = (b[4] - 48) * 100 + (b[5] - 48) * 10 + (b[6] - 48);
        this.minorVersion = (b[8] - 48) * 100 + (b[9] - 48) * 10 + (b[10] - 48);
        return true;
    }

    public void writeVersion(OutStream os) {
        byte[] b = new byte[]{82, 70, 66, 32, (byte)(48 + this.majorVersion / 100 % 10), (byte)(48 + this.majorVersion / 10 % 10), (byte)(48 + this.majorVersion % 10), 46, (byte)(48 + this.minorVersion / 100 % 10), (byte)(48 + this.minorVersion / 10 % 10), (byte)(48 + this.minorVersion % 10), 10};
        os.writeBytes(b, 0, 12);
        os.flush();
    }

    public void setVersion(int major, int minor) {
        this.majorVersion = major;
        this.minorVersion = minor;
    }

    public boolean isVersion(int major, int minor) {
        return this.majorVersion == major && this.minorVersion == minor;
    }

    public boolean beforeVersion(int major, int minor) {
        return this.majorVersion < major || this.majorVersion == major && this.minorVersion < minor;
    }

    public boolean afterVersion(int major, int minor) {
        return !this.beforeVersion(major, minor + 1);
    }

    public PixelFormat pf() {
        return this.pf_;
    }

    public void setPF(PixelFormat pf) {
        this.pf_ = pf;
        if (pf.bpp != 8 && pf.bpp != 16 && pf.bpp != 32) {
            throw new Exception("setPF: not 8, 16 or 32 bpp?");
        }
    }

    public int currentEncoding() {
        return this.currentEncoding_;
    }

    public int nEncodings() {
        return this.nEncodings_;
    }

    public int[] encodings() {
        return this.encodings_;
    }

    public void setEncodings(int nEncodings, int[] encodings) {
        if (nEncodings > this.nEncodings_) {
            this.encodings_ = new int[nEncodings];
        }
        this.nEncodings_ = nEncodings;
        this.useCopyRect = false;
        this.supportsLocalCursor = false;
        this.supportsDesktopResize = false;
        this.currentEncoding_ = 0;
        for (int i = nEncodings - 1; i >= 0; --i) {
            this.encodings_[i] = encodings[i];
            if (encodings[i] == 1) {
                this.useCopyRect = true;
                continue;
            }
            if (encodings[i] == -239) {
                this.supportsLocalCursor = true;
                continue;
            }
            if (encodings[i] == -223) {
                this.supportsDesktopResize = true;
                continue;
            }
            if (encodings[i] > 255 || !Encoder.supported(encodings[i])) continue;
            this.currentEncoding_ = encodings[i];
        }
    }
}

