/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.cglib;

import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.creation.cglib.AcrossJVMSerializationFeature;
import org.mockito.internal.creation.cglib.ClassImposterizer;
import org.mockito.internal.creation.cglib.MethodInterceptorFilter;
import org.mockito.internal.creation.instance.InstantiatorProvider;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.MockMaker;

public class CglibMockMaker
implements MockMaker {
    @Override
    public <T> T createMock(MockCreationSettings<T> mockCreationSettings, MockHandler mockHandler) {
        InternalMockHandler internalMockHandler = this.cast(mockHandler);
        new AcrossJVMSerializationFeature().enableSerializationAcrossJVM(mockCreationSettings);
        return new ClassImposterizer(new InstantiatorProvider().getInstantiator(mockCreationSettings)).imposterise((MethodInterceptor)new MethodInterceptorFilter(internalMockHandler, mockCreationSettings), mockCreationSettings.getTypeToMock(), mockCreationSettings.getExtraInterfaces());
    }

    private InternalMockHandler cast(MockHandler mockHandler) {
        if (!(mockHandler instanceof InternalMockHandler)) {
            throw new MockitoException("At the moment you cannot provide own implementations of MockHandler.\nPlease see the javadocs for the MockMaker interface.");
        }
        return (InternalMockHandler)mockHandler;
    }

    @Override
    public void resetMock(Object object, MockHandler mockHandler, MockCreationSettings mockCreationSettings) {
        ((Factory)object).setCallback(0, (Callback)new MethodInterceptorFilter(this.cast(mockHandler), mockCreationSettings));
    }

    @Override
    public MockHandler getHandler(Object object) {
        if (!(object instanceof Factory)) {
            return null;
        }
        Factory factory = (Factory)object;
        Callback callback = factory.getCallback(0);
        if (!(callback instanceof MethodInterceptorFilter)) {
            return null;
        }
        return ((MethodInterceptorFilter)callback).getHandler();
    }
}

