/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.handler;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.MatchersBinder;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.stubbing.InvocationContainerImpl;
import org.mockito.internal.stubbing.OngoingStubbingImpl;
import org.mockito.internal.stubbing.StubbedInvocationMatcher;
import org.mockito.internal.stubbing.VoidMethodStubbableImpl;
import org.mockito.internal.verification.MockAwareVerificationMode;
import org.mockito.internal.verification.VerificationDataImpl;
import org.mockito.invocation.Invocation;
import org.mockito.mock.MockCreationSettings;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.VoidMethodStubbable;
import org.mockito.verification.VerificationMode;

class MockHandlerImpl<T>
implements InternalMockHandler<T> {
    private static final long serialVersionUID = -2917871070982574165L;
    InvocationContainerImpl invocationContainerImpl;
    MatchersBinder matchersBinder = new MatchersBinder();
    MockingProgress mockingProgress = new ThreadSafeMockingProgress();
    private final MockCreationSettings mockSettings;

    public MockHandlerImpl(MockCreationSettings mockCreationSettings) {
        this.mockSettings = mockCreationSettings;
        this.mockingProgress = new ThreadSafeMockingProgress();
        this.matchersBinder = new MatchersBinder();
        this.invocationContainerImpl = new InvocationContainerImpl(this.mockingProgress, mockCreationSettings);
    }

    @Override
    public Object handle(Invocation invocation) throws Throwable {
        if (this.invocationContainerImpl.hasAnswersForStubbing()) {
            InvocationMatcher invocationMatcher = this.matchersBinder.bindMatchers(this.mockingProgress.getArgumentMatcherStorage(), invocation);
            this.invocationContainerImpl.setMethodForStubbing(invocationMatcher);
            return null;
        }
        VerificationMode verificationMode = this.mockingProgress.pullVerificationMode();
        InvocationMatcher invocationMatcher = this.matchersBinder.bindMatchers(this.mockingProgress.getArgumentMatcherStorage(), invocation);
        this.mockingProgress.validateState();
        if (verificationMode != null) {
            if (((MockAwareVerificationMode)verificationMode).getMock() == invocation.getMock()) {
                VerificationDataImpl verificationDataImpl = this.createVerificationData(this.invocationContainerImpl, invocationMatcher);
                verificationMode.verify(verificationDataImpl);
                return null;
            }
            this.mockingProgress.verificationStarted(verificationMode);
        }
        this.invocationContainerImpl.setInvocationForPotentialStubbing(invocationMatcher);
        OngoingStubbingImpl ongoingStubbingImpl = new OngoingStubbingImpl(this.invocationContainerImpl);
        this.mockingProgress.reportOngoingStubbing(ongoingStubbingImpl);
        StubbedInvocationMatcher stubbedInvocationMatcher = this.invocationContainerImpl.findAnswerFor(invocation);
        if (stubbedInvocationMatcher != null) {
            stubbedInvocationMatcher.captureArgumentsFrom(invocation);
            return stubbedInvocationMatcher.answer(invocation);
        }
        Object t = this.mockSettings.getDefaultAnswer().answer(invocation);
        this.invocationContainerImpl.resetInvocationForPotentialStubbing(invocationMatcher);
        return t;
    }

    @Override
    public VoidMethodStubbable<T> voidMethodStubbable(T t) {
        return new VoidMethodStubbableImpl<T>(t, this.invocationContainerImpl);
    }

    @Override
    public MockCreationSettings getMockSettings() {
        return this.mockSettings;
    }

    @Override
    public void setAnswersForStubbing(List<Answer> list) {
        this.invocationContainerImpl.setAnswersForStubbing(list);
    }

    @Override
    public InvocationContainer getInvocationContainer() {
        return this.invocationContainerImpl;
    }

    private VerificationDataImpl createVerificationData(InvocationContainerImpl invocationContainerImpl, InvocationMatcher invocationMatcher) {
        if (this.mockSettings.isStubOnly()) {
            new Reporter().stubPassedToVerify();
        }
        return new VerificationDataImpl(invocationContainerImpl, invocationMatcher);
    }
}

