/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.dmt.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import org.osgi.service.dmt.security.DmtPrincipalPermission;

final class DmtPrincipalPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = -6692103535775802684L;
    private ArrayList perms = new ArrayList();

    @Override
    public void add(Permission permission) {
        if (!(permission instanceof DmtPrincipalPermission)) {
            throw new IllegalArgumentException("Cannot add permission, invalid permission type: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("Cannot add permission, collection is marked read-only.");
        }
        if (!this.implies(permission)) {
            Iterator iterator = this.perms.iterator();
            while (iterator.hasNext()) {
                if (!permission.implies((DmtPrincipalPermission)iterator.next())) continue;
                iterator.remove();
            }
            this.perms.add(permission);
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof DmtPrincipalPermission)) {
            return false;
        }
        DmtPrincipalPermission dmtPrincipalPermission = (DmtPrincipalPermission)permission;
        Iterator iterator = this.perms.iterator();
        while (iterator.hasNext()) {
            if (!((DmtPrincipalPermission)iterator.next()).impliesPrincipal(dmtPrincipalPermission)) continue;
            return true;
        }
        return false;
    }

    public Enumeration elements() {
        return Collections.enumeration(this.perms);
    }
}

