/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Binding;
import com.icl.saxon.expr.ExpressionParser;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.pattern.NameTest;
import com.icl.saxon.pattern.NamespaceTest;
import java.util.Hashtable;

public class StandaloneContext
implements StaticContext {
    private NamePool namePool;
    private Hashtable namespaces = new Hashtable();

    public StandaloneContext() {
        this(NamePool.getDefaultNamePool());
    }

    public StandaloneContext(NamePool namePool) {
        this.namePool = namePool;
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
        this.declareNamespace("saxon", "http://icl.com/saxon");
        this.declareNamespace("", "");
    }

    public void declareNamespace(String string, String string2) {
        this.namespaces.put(string, string2);
        this.namePool.allocateNamespaceCode(string, string2);
    }

    @Override
    public StaticContext makeRuntimeContext(NamePool namePool) {
        return null;
    }

    @Override
    public String getSystemId() {
        return "";
    }

    @Override
    public String getBaseURI() {
        return "";
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public String getURIForPrefix(String string) throws XPathException {
        String string2 = (String)this.namespaces.get(string);
        if (string2 == null) {
            throw new XPathException("Prefix " + string + " has not been declared");
        }
        return string2;
    }

    @Override
    public final int makeNameCode(String string, boolean bl) throws XPathException {
        String string2 = Name.getPrefix(string);
        String string3 = Name.getLocalName(string);
        String string4 = string2.equals("") && bl ? "" : this.getURIForPrefix(string2);
        return this.namePool.allocate(string2, string4, string3);
    }

    @Override
    public final int getFingerprint(String string, boolean bl) throws XPathException {
        String string2 = Name.getPrefix(string);
        String string3 = Name.getLocalName(string);
        String string4 = string2.equals("") && bl ? "" : this.getURIForPrefix(string2);
        return this.namePool.getFingerprint(string4, string3);
    }

    @Override
    public NameTest makeNameTest(short s, String string, boolean bl) throws XPathException {
        return new NameTest(s, this.makeNameCode(string, bl));
    }

    @Override
    public NamespaceTest makeNamespaceTest(short s, String string) throws XPathException {
        return new NamespaceTest(this.namePool, s, this.getURICodeForPrefix(string));
    }

    private short getURICodeForPrefix(String string) throws XPathException {
        String string2 = this.getURIForPrefix(string);
        return this.namePool.getCodeForURI(string2);
    }

    @Override
    public Binding bindVariable(int n) throws XPathException {
        throw new XPathException("Variables are not allowed in a standalone expression");
    }

    @Override
    public boolean isExtensionNamespace(short s) {
        return false;
    }

    @Override
    public boolean forwardsCompatibleModeIsEnabled() {
        return false;
    }

    @Override
    public Function getStyleSheetFunction(int n) throws XPathException {
        return null;
    }

    @Override
    public Class getExternalJavaClass(String string) {
        return null;
    }

    @Override
    public boolean isElementAvailable(String string) throws XPathException {
        return false;
    }

    @Override
    public boolean isFunctionAvailable(String string) throws XPathException {
        String string2 = Name.getPrefix(string);
        if (string2.equals("")) {
            return ExpressionParser.makeSystemFunction(string) != null;
        }
        return false;
    }

    @Override
    public boolean allowsKeyFunction() {
        return false;
    }

    @Override
    public String getVersion() {
        return "1.1";
    }
}

